/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster.topology;

import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.cluster.topology.RedisClusterNodeSnapshot;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceLists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class TopologyComparators {
    public static List<RedisClusterNode> predefinedSort(Iterable<RedisClusterNode> clusterNodes, Iterable<RedisURI> fixedOrder) {
        LettuceAssert.notNull(clusterNodes, "Cluster nodes must not be null");
        LettuceAssert.notNull(fixedOrder, "Fixed order must not be null");
        List<RedisURI> fixedOrderList = LettuceLists.newList(fixedOrder);
        List<RedisClusterNode> withOrderSpecification = LettuceLists.newList(clusterNodes).stream().filter(redisClusterNode -> fixedOrderList.contains(redisClusterNode.getUri())).collect(Collectors.toList());
        List withoutSpecification = LettuceLists.newList(clusterNodes).stream().filter(redisClusterNode -> !fixedOrderList.contains(redisClusterNode.getUri())).collect(Collectors.toList());
        withOrderSpecification.sort(new PredefinedRedisClusterNodeComparator(fixedOrderList));
        withoutSpecification.sort((o1, o2) -> RedisURIComparator.INSTANCE.compare(o1.getUri(), o2.getUri()));
        withOrderSpecification.addAll(withoutSpecification);
        return withOrderSpecification;
    }

    public static List<RedisClusterNode> sortByUri(Iterable<RedisClusterNode> clusterNodes) {
        LettuceAssert.notNull(clusterNodes, "Cluster nodes must not be null");
        List<RedisClusterNode> ordered = LettuceLists.newList(clusterNodes);
        ordered.sort((o1, o2) -> RedisURIComparator.INSTANCE.compare(o1.getUri(), o2.getUri()));
        return ordered;
    }

    public static List<RedisClusterNode> sortByClientCount(Iterable<RedisClusterNode> clusterNodes) {
        LettuceAssert.notNull(clusterNodes, "Cluster nodes must not be null");
        List<RedisClusterNode> ordered = LettuceLists.newList(clusterNodes);
        ordered.sort(ClientCountComparator.INSTANCE);
        return ordered;
    }

    public static List<RedisClusterNode> sortByLatency(Iterable<RedisClusterNode> clusterNodes) {
        List<RedisClusterNode> ordered = LettuceLists.newList(clusterNodes);
        ordered.sort(LatencyComparator.INSTANCE);
        return ordered;
    }

    public static boolean isChanged(Partitions o1, Partitions o2) {
        if (o1.size() != o2.size()) {
            return true;
        }
        for (RedisClusterNode base : o2) {
            if (TopologyComparators.essentiallyEqualsTo(base, o1.getPartitionByNodeId(base.getNodeId()))) continue;
            return true;
        }
        return false;
    }

    static boolean essentiallyEqualsTo(RedisClusterNode o1, RedisClusterNode o2) {
        if (o2 == null) {
            return false;
        }
        if (!TopologyComparators.sameFlags(o1, o2, RedisClusterNode.NodeFlag.UPSTREAM)) {
            return false;
        }
        if (!TopologyComparators.sameFlags(o1, o2, RedisClusterNode.NodeFlag.REPLICA)) {
            return false;
        }
        return o1.hasSameSlotsAs(o2);
    }

    private static boolean sameFlags(RedisClusterNode base, RedisClusterNode other, RedisClusterNode.NodeFlag flag) {
        if (base.is(flag)) {
            return other.is(flag);
        }
        return !other.is(flag);
    }

    static class PredefinedRedisClusterNodeComparator
    implements Comparator<RedisClusterNode> {
        private final List<RedisURI> fixedOrder;

        public PredefinedRedisClusterNodeComparator(List<RedisURI> fixedOrder) {
            this.fixedOrder = fixedOrder;
        }

        @Override
        public int compare(RedisClusterNode o1, RedisClusterNode o2) {
            int index1 = this.fixedOrder.indexOf(o1.getUri());
            int index2 = this.fixedOrder.indexOf(o2.getUri());
            return Integer.compare(index1, index2);
        }
    }

    static enum ClientCountComparator implements Comparator<RedisClusterNode>
    {
        INSTANCE;


        @Override
        public int compare(RedisClusterNode o1, RedisClusterNode o2) {
            if (o1 instanceof RedisClusterNodeSnapshot && o2 instanceof RedisClusterNodeSnapshot) {
                RedisClusterNodeSnapshot w1 = (RedisClusterNodeSnapshot)o1;
                RedisClusterNodeSnapshot w2 = (RedisClusterNodeSnapshot)o2;
                if (w1.getConnectedClients() != null && w2.getConnectedClients() != null) {
                    return w1.getConnectedClients().compareTo(w2.getConnectedClients());
                }
                if (w1.getConnectedClients() == null && w2.getConnectedClients() != null) {
                    return 1;
                }
                if (w1.getConnectedClients() != null && w2.getConnectedClients() == null) {
                    return -1;
                }
            }
            return 0;
        }
    }

    static enum LatencyComparator implements Comparator<RedisClusterNode>
    {
        INSTANCE;


        @Override
        public int compare(RedisClusterNode o1, RedisClusterNode o2) {
            if (o1 instanceof RedisClusterNodeSnapshot && o2 instanceof RedisClusterNodeSnapshot) {
                RedisClusterNodeSnapshot w1 = (RedisClusterNodeSnapshot)o1;
                RedisClusterNodeSnapshot w2 = (RedisClusterNodeSnapshot)o2;
                if (w1.getLatencyNs() != null && w2.getLatencyNs() != null) {
                    return w1.getLatencyNs().compareTo(w2.getLatencyNs());
                }
                if (w1.getLatencyNs() != null && w2.getLatencyNs() == null) {
                    return -1;
                }
                if (w1.getLatencyNs() == null && w2.getLatencyNs() != null) {
                    return 1;
                }
            }
            return 0;
        }
    }

    static enum RedisURIComparator implements Comparator<RedisURI>
    {
        INSTANCE;


        @Override
        public int compare(RedisURI o1, RedisURI o2) {
            String h1 = "";
            String h2 = "";
            if (o1 != null) {
                h1 = o1.getHost() + ":" + o1.getPort();
            }
            if (o2 != null) {
                h2 = o2.getHost() + ":" + o2.getPort();
            }
            return h1.compareToIgnoreCase(h2);
        }
    }

    static enum SortAction {
        BY_LATENCY{

            @Override
            void sort(Partitions partitions) {
                partitions.getPartitions().sort(LatencyComparator.INSTANCE);
            }
        }
        ,
        NONE{

            @Override
            void sort(Partitions partitions) {
            }
        }
        ,
        RANDOMIZE{

            @Override
            void sort(Partitions partitions) {
                Collections.shuffle(partitions.getPartitions());
            }
        };


        abstract void sort(Partitions var1);

        static SortAction getSortAction() {
            String sortAction = System.getProperty("io.lettuce.core.topology.sort", BY_LATENCY.name());
            for (SortAction action : SortAction.values()) {
                if (!sortAction.equalsIgnoreCase(action.name())) continue;
                return action;
            }
            return BY_LATENCY;
        }
    }
}

