/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.protocol;

import io.lettuce.core.internal.LettuceStrings;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.protocol.ProtocolVersion;
import io.lettuce.core.protocol.RedisProtocolException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class RedisStateMachine {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisStateMachine.class);
    private static final ByteBuffer QUEUED = StandardCharsets.US_ASCII.encode("QUEUED");
    private static final int TERMINATOR_LENGTH = 2;
    private static final int NOT_FOUND = -1;
    private static final State.Type[] TYPE_BY_BYTE_MARKER = new State.Type[128];
    private final State[] stack = new State[32];
    private final boolean debugEnabled = logger.isDebugEnabled();
    private final ByteBuf responseElementBuffer;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Resp2LongProcessor longProcessor = new Resp2LongProcessor();
    private ProtocolVersion protocolVersion = null;
    private int stackElements;

    public RedisStateMachine(ByteBufAllocator alloc) {
        this.responseElementBuffer = alloc.buffer(1024);
    }

    public boolean isDiscoverProtocol() {
        return this.protocolVersion == null;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public boolean decode(ByteBuf buffer, CommandOutput<?, ?, ?> output) {
        return this.decode(buffer, output, ex -> {});
    }

    public boolean decode(ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
        buffer.touch((Object)"RedisStateMachine.decode(\u2026)");
        if (this.isEmpty(this.stack)) {
            this.add(this.stack, new State());
        }
        if (output == null) {
            return this.isEmpty(this.stack);
        }
        boolean resp3Indicator = this.doDecode(buffer, output, errorHandler);
        if (this.debugEnabled) {
            logger.debug("Decode done, empty stack: {}", (Object)this.isEmpty(this.stack));
        }
        if (this.isDiscoverProtocol()) {
            if (resp3Indicator) {
                this.setProtocolVersion(ProtocolVersion.RESP3);
            } else {
                this.setProtocolVersion(ProtocolVersion.RESP2);
            }
        }
        return this.isEmpty(this.stack);
    }

    private boolean doDecode(ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
        boolean resp3Indicator = false;
        while (!this.isEmpty(this.stack)) {
            State.Result result;
            State state = this.peek(this.stack);
            if (state.type == null) {
                if (!buffer.isReadable()) break;
                state.type = this.readReplyType(buffer);
                if (state.type == State.Type.HELLO_V3 || state.type == State.Type.MAP) {
                    resp3Indicator = true;
                }
                buffer.markReaderIndex();
            }
            if (State.Result.BREAK_LOOP.equals((Object)(result = state.type.handle(this, state, buffer, output, errorHandler)))) break;
            if (State.Result.CONTINUE_LOOP.equals((Object)result)) continue;
            buffer.markReaderIndex();
            this.remove(this.stack);
            output.complete(this.size(this.stack));
        }
        return resp3Indicator;
    }

    static State.Result handleSingle(RedisStateMachine rsm, State state, ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
        ByteBuffer bytes = rsm.readLine(buffer);
        if (bytes == null) {
            return State.Result.BREAK_LOOP;
        }
        if (!QUEUED.equals(bytes)) {
            rsm.safeSetSingle(output, bytes, errorHandler);
        }
        return State.Result.NORMAL_END;
    }

    static State.Result handleBigNumber(RedisStateMachine rsm, State state, ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
        ByteBuffer bytes = rsm.readLine(buffer);
        if (bytes == null) {
            return State.Result.BREAK_LOOP;
        }
        rsm.safeSetBigNumber(output, bytes, errorHandler);
        return State.Result.NORMAL_END;
    }

    static State.Result handleError(RedisStateMachine rsm, State state, ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
        ByteBuffer bytes = rsm.readLine(buffer);
        if (bytes == null) {
            return State.Result.BREAK_LOOP;
        }
        rsm.safeSetError(output, bytes, errorHandler);
        return State.Result.NORMAL_END;
    }

    static State.Result handleNull(RedisStateMachine rsm, State state, ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
        if (rsm.readLine(buffer) == null) {
            return State.Result.BREAK_LOOP;
        }
        rsm.safeSet(output, null, errorHandler);
        return State.Result.NORMAL_END;
    }

    static State.Result handleInteger(RedisStateMachine rsm, State state, ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
        int end = rsm.findLineEnd(buffer);
        if (end == -1) {
            return State.Result.BREAK_LOOP;
        }
        long integer = rsm.readLong(buffer, buffer.readerIndex(), end);
        rsm.safeSet(output, integer, errorHandler);
        return State.Result.NORMAL_END;
    }

    static State.Result handleBoolean(RedisStateMachine rsm, State state, ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
        if (rsm.findLineEnd(buffer) == -1) {
            return State.Result.BREAK_LOOP;
        }
        boolean value = rsm.readBoolean(buffer);
        rsm.safeSet(output, value, errorHandler);
        return State.Result.NORMAL_END;
    }

    static State.Result handleFloat(RedisStateMachine rsm, State state, ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
        int end = rsm.findLineEnd(buffer);
        if (end == -1) {
            return State.Result.BREAK_LOOP;
        }
        double f = rsm.readFloat(buffer, buffer.readerIndex(), end);
        rsm.safeSet(output, f, errorHandler);
        return State.Result.NORMAL_END;
    }

    static State.Result handleBulkAndVerbatim(RedisStateMachine rsm, State state, ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
        int end = rsm.findLineEnd(buffer);
        if (end == -1) {
            return State.Result.BREAK_LOOP;
        }
        int length = (int)rsm.readLong(buffer, buffer.readerIndex(), end);
        if (length != -1) {
            state.type = state.type == State.Type.VERBATIM ? State.Type.VERBATIM_STRING : State.Type.BYTES;
            state.count = length + 2;
            buffer.markReaderIndex();
            return State.Result.CONTINUE_LOOP;
        }
        rsm.safeSet(output, null, errorHandler);
        return State.Result.NORMAL_END;
    }

    static State.Result handleBulkError(RedisStateMachine rsm, State state, ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
        int end = rsm.findLineEnd(buffer);
        if (end == -1) {
            return State.Result.BREAK_LOOP;
        }
        int length = (int)rsm.readLong(buffer, buffer.readerIndex(), end);
        if (length != -1) {
            state.type = State.Type.BYTES;
            state.count = length + 2;
            buffer.markReaderIndex();
            return State.Result.CONTINUE_LOOP;
        }
        rsm.safeSetError(output, null, errorHandler);
        return State.Result.NORMAL_END;
    }

    static State.Result handleHelloV3(RedisStateMachine rsm, State state, ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
        if (state.count == -1) {
            int end = rsm.findLineEnd(buffer);
            if (end == -1) {
                return State.Result.BREAK_LOOP;
            }
            RedisStateMachine.readAndMarkReadIdx(rsm, state, buffer, end);
        }
        return RedisStateMachine.returnDependStateCount(rsm, state);
    }

    static State.Result handlePushAndMulti(RedisStateMachine rsm, State state, ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
        if (state.count == -1) {
            int end = rsm.findLineEnd(buffer);
            if (end == -1) {
                return State.Result.BREAK_LOOP;
            }
            RedisStateMachine.readAndMarkReadIdx(rsm, state, buffer, end);
            rsm.safeMultiArray(output, state.count, errorHandler);
        }
        return RedisStateMachine.returnDependStateCount(rsm, state);
    }

    static State.Result handleMap(RedisStateMachine rsm, State state, ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
        if (state.count == -1) {
            int end = rsm.findLineEnd(buffer);
            if (end == -1) {
                return State.Result.BREAK_LOOP;
            }
            int length = RedisStateMachine.readAndMarkReadIdx(rsm, state, buffer, end);
            rsm.safeMultiMap(output, state.count, errorHandler);
            state.count = length * 2;
        }
        return RedisStateMachine.returnDependStateCount(rsm, state);
    }

    static State.Result handleSet(RedisStateMachine rsm, State state, ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
        if (state.count == -1) {
            int end = rsm.findLineEnd(buffer);
            if (end == -1) {
                return State.Result.BREAK_LOOP;
            }
            RedisStateMachine.readAndMarkReadIdx(rsm, state, buffer, end);
            rsm.safeMultiSet(output, state.count, errorHandler);
        }
        return RedisStateMachine.returnDependStateCount(rsm, state);
    }

    static int readAndMarkReadIdx(RedisStateMachine rsm, State state, ByteBuf buffer, int end) {
        int length;
        state.count = length = (int)rsm.readLong(buffer, buffer.readerIndex(), end);
        buffer.markReaderIndex();
        return length;
    }

    static State.Result returnDependStateCount(RedisStateMachine rsm, State state) {
        if (state.count <= 0) {
            return State.Result.NORMAL_END;
        }
        --state.count;
        rsm.addFirst(rsm.stack, new State());
        return State.Result.CONTINUE_LOOP;
    }

    static State.Result handleVerbatim(RedisStateMachine rsm, State state, ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
        ByteBuffer bytes = rsm.readBytes(buffer, state.count);
        if (bytes == null) {
            return State.Result.BREAK_LOOP;
        }
        bytes.position(bytes.position() + 4);
        rsm.safeSet(output, bytes, errorHandler);
        return State.Result.NORMAL_END;
    }

    static State.Result handleBytes(RedisStateMachine rsm, State state, ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
        ByteBuffer bytes = rsm.readBytes(buffer, state.count);
        if (bytes == null) {
            return State.Result.BREAK_LOOP;
        }
        rsm.safeSet(output, bytes, errorHandler);
        return State.Result.NORMAL_END;
    }

    private static State.Result handleAttribute(RedisStateMachine rsm, State state, ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
        throw new RedisProtocolException("Not implemented");
    }

    public void reset() {
        Arrays.fill(this.stack, null);
        this.stackElements = 0;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.responseElementBuffer.release();
        }
    }

    private int findLineEnd(ByteBuf buffer) {
        int index = buffer.forEachByte(ByteProcessor.FIND_LF);
        return index > 0 && buffer.getByte(index - 1) == 13 ? index - 1 : -1;
    }

    private State.Type readReplyType(ByteBuf buffer) {
        byte b = buffer.readByte();
        State.Type type = TYPE_BY_BYTE_MARKER[b];
        if (type == null) {
            throw new RedisProtocolException("Invalid first byte: " + b + " (" + new String(new byte[]{b}) + ") at buffer index " + buffer.readerIndex() + " decoding using " + (Object)((Object)this.getProtocolVersion()));
        }
        return type;
    }

    private long readLong(ByteBuf buffer, int start, int end) {
        return this.longProcessor.getValue(buffer, start, end);
    }

    private double readFloat(ByteBuf buffer, int start, int end) {
        int valueLength = end - start;
        String value = buffer.toString(start, valueLength, StandardCharsets.US_ASCII);
        buffer.skipBytes(valueLength + 2);
        return LettuceStrings.toDouble(value);
    }

    private boolean readBoolean(ByteBuf buffer) {
        byte b = buffer.readByte();
        buffer.skipBytes(2);
        switch (b) {
            case 116: {
                return true;
            }
            case 102: {
                return false;
            }
        }
        throw new RedisProtocolException("Unexpected BOOLEAN value: " + b);
    }

    private ByteBuffer readLine(ByteBuf buffer) {
        ByteBuffer bytes = null;
        int end = this.findLineEnd(buffer);
        if (end > -1) {
            bytes = this.readBytes0(buffer, end - buffer.readerIndex());
            buffer.skipBytes(2);
            buffer.markReaderIndex();
        }
        return bytes;
    }

    private ByteBuffer readBytes(ByteBuf buffer, int count) {
        if (buffer.readableBytes() >= count) {
            ByteBuffer byteBuffer = this.readBytes0(buffer, count - 2);
            buffer.skipBytes(2);
            buffer.markReaderIndex();
            return byteBuffer;
        }
        return null;
    }

    private ByteBuffer readBytes0(ByteBuf buffer, int count) {
        this.responseElementBuffer.clear();
        if (this.responseElementBuffer.capacity() < count) {
            this.responseElementBuffer.capacity(count);
        }
        buffer.readBytes(this.responseElementBuffer, count);
        ByteBuffer bytes = this.responseElementBuffer.internalNioBuffer(0, count);
        return bytes;
    }

    private void remove(State[] stack) {
        stack[this.stackElements - 1] = null;
        --this.stackElements;
    }

    private void addFirst(State[] stack, State state) {
        stack[this.stackElements++] = state;
    }

    private State peek(State[] stack) {
        return stack[this.stackElements - 1];
    }

    private void add(State[] stack, State state) {
        if (this.stackElements != 0) {
            System.arraycopy(stack, 0, stack, 1, this.stackElements);
        }
        stack[0] = state;
        ++this.stackElements;
    }

    private int size(State[] stack) {
        return this.stackElements;
    }

    private boolean isEmpty(State[] stack) {
        return this.stackElements == 0;
    }

    protected void safeSet(CommandOutput<?, ?, ?> output, boolean value, Consumer<Exception> errorHandler) {
        try {
            output.set(value);
        }
        catch (Exception e) {
            errorHandler.accept(e);
        }
    }

    protected void safeSet(CommandOutput<?, ?, ?> output, long number, Consumer<Exception> errorHandler) {
        try {
            output.set(number);
        }
        catch (Exception e) {
            errorHandler.accept(e);
        }
    }

    protected void safeSet(CommandOutput<?, ?, ?> output, double number, Consumer<Exception> errorHandler) {
        try {
            output.set(number);
        }
        catch (Exception e) {
            errorHandler.accept(e);
        }
    }

    protected void safeSet(CommandOutput<?, ?, ?> output, ByteBuffer bytes, Consumer<Exception> errorHandler) {
        try {
            output.set(bytes);
        }
        catch (Exception e) {
            errorHandler.accept(e);
        }
    }

    protected void safeSetSingle(CommandOutput<?, ?, ?> output, ByteBuffer bytes, Consumer<Exception> errorHandler) {
        try {
            output.set(bytes);
        }
        catch (Exception e) {
            errorHandler.accept(e);
        }
    }

    protected void safeSetBigNumber(CommandOutput<?, ?, ?> output, ByteBuffer bytes, Consumer<Exception> errorHandler) {
        try {
            output.setBigNumber(bytes);
        }
        catch (Exception e) {
            errorHandler.accept(e);
        }
    }

    protected void safeMultiArray(CommandOutput<?, ?, ?> output, int count, Consumer<Exception> errorHandler) {
        try {
            output.multiArray(count);
        }
        catch (Exception e) {
            errorHandler.accept(e);
        }
    }

    protected void safeMultiPush(CommandOutput<?, ?, ?> output, int count, Consumer<Exception> errorHandler) {
        try {
            output.multiPush(count);
        }
        catch (Exception e) {
            errorHandler.accept(e);
        }
    }

    protected void safeMultiSet(CommandOutput<?, ?, ?> output, int count, Consumer<Exception> errorHandler) {
        try {
            output.multiSet(count);
        }
        catch (Exception e) {
            errorHandler.accept(e);
        }
    }

    protected void safeMultiMap(CommandOutput<?, ?, ?> output, int count, Consumer<Exception> errorHandler) {
        try {
            output.multiMap(count);
        }
        catch (Exception e) {
            errorHandler.accept(e);
        }
    }

    protected void safeSetError(CommandOutput<?, ?, ?> output, ByteBuffer bytes, Consumer<Exception> errorHandler) {
        try {
            output.setError(bytes);
        }
        catch (Exception e) {
            errorHandler.accept(e);
        }
    }

    static {
        for (State.Type type : State.Type.values()) {
            if (type == State.Type.BYTES || type == State.Type.VERBATIM_STRING) continue;
            if (TYPE_BY_BYTE_MARKER[type.marker] != null) {
                throw new IllegalStateException("Cannot overwrite message marker assignment for '" + new String(new byte[]{type.marker}) + "' with " + type);
            }
            RedisStateMachine.TYPE_BY_BYTE_MARKER[type.marker] = type;
        }
    }

    static class State {
        Type type = null;
        int count = -1;

        State() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName());
            sb.append(" [type=").append(this.type);
            sb.append(", count=").append(this.count);
            sb.append(']');
            return sb.toString();
        }

        static enum Type implements StateHandler
        {
            SINGLE('+', RedisStateMachine::handleSingle),
            ERROR('-', RedisStateMachine::handleError),
            INTEGER(':', RedisStateMachine::handleInteger),
            FLOAT(',', RedisStateMachine::handleFloat),
            BOOLEAN('#', RedisStateMachine::handleBoolean),
            BULK_ERROR('!', RedisStateMachine::handleBulkError),
            VERBATIM('=', RedisStateMachine::handleBulkAndVerbatim),
            VERBATIM_STRING('=', RedisStateMachine::handleVerbatim),
            BIG_NUMBER('(', RedisStateMachine::handleBigNumber),
            MAP('%', RedisStateMachine::handleMap),
            SET('~', RedisStateMachine::handleSet),
            ATTRIBUTE('|', (x$0, x$1, x$2, x$3, x$4) -> RedisStateMachine.access$000(x$0, x$1, x$2, x$3, x$4)),
            PUSH('>', RedisStateMachine::handlePushAndMulti),
            HELLO_V3('@', RedisStateMachine::handleHelloV3),
            NULL('_', RedisStateMachine::handleNull),
            BULK('$', RedisStateMachine::handleBulkAndVerbatim),
            MULTI('*', RedisStateMachine::handlePushAndMulti),
            BYTES('*', RedisStateMachine::handleBytes);

            final byte marker;
            private final StateHandler behavior;

            private Type(char marker, StateHandler behavior) {
                this.marker = (byte)marker;
                this.behavior = behavior;
            }

            @Override
            public Result handle(RedisStateMachine rsm, State state, ByteBuf buffer, CommandOutput<?, ?, ?> output, Consumer<Exception> errorHandler) {
                return this.behavior.handle(rsm, state, buffer, output, errorHandler);
            }
        }

        static enum Result {
            NORMAL_END,
            BREAK_LOOP,
            CONTINUE_LOOP;

        }

        @FunctionalInterface
        static interface StateHandler {
            public Result handle(RedisStateMachine var1, State var2, ByteBuf var3, CommandOutput<?, ?, ?> var4, Consumer<Exception> var5);
        }
    }

    static class Resp2LongProcessor
    implements ByteProcessor {
        long result;
        boolean negative;
        boolean first;

        Resp2LongProcessor() {
        }

        public long getValue(ByteBuf buffer, int start, int end) {
            this.result = 0L;
            this.first = true;
            int length = end - start;
            buffer.forEachByte(start, length, (ByteProcessor)this);
            if (!this.negative) {
                this.result = -this.result;
            }
            buffer.skipBytes(length + 2);
            return this.result;
        }

        public boolean process(byte value) {
            if (this.first) {
                this.first = false;
                if (value == 45) {
                    this.negative = true;
                } else {
                    this.negative = false;
                    int digit = value - 48;
                    this.result = this.result * 10L - (long)digit;
                }
                return true;
            }
            int digit = value - 48;
            this.result = this.result * 10L - (long)digit;
            return true;
        }
    }
}

