/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.GeoArgs;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;

public final class GeoSearch {
    public static <K> GeoRef<K> fromMember(K member) {
        LettuceAssert.notNull(member, "Reference member must not be null");
        return new FromMember<K>(member);
    }

    public static <K> GeoRef<K> fromCoordinates(double longitude, double latitude) {
        return new FromCoordinates(longitude, latitude);
    }

    public static GeoPredicate byRadius(double distance, GeoArgs.Unit unit) {
        return new Radius(distance, unit);
    }

    public static GeoPredicate byBox(double width, double height, GeoArgs.Unit unit) {
        return new Box(width, height, unit);
    }

    static class FromMember<K>
    implements GeoRef<K> {
        final K member;

        public FromMember(K member) {
            this.member = member;
        }

        @Override
        public <K, V> void build(CommandArgs<K, V> args) {
            args.add("FROMMEMBER").addKey(this.member);
        }
    }

    static class FromCoordinates
    implements GeoRef<Object> {
        final double longitude;
        final double latitude;

        public FromCoordinates(double longitude, double latitude) {
            this.longitude = longitude;
            this.latitude = latitude;
        }

        @Override
        public <K, V> void build(CommandArgs<K, V> args) {
            args.add("FROMLONLAT").add(this.longitude).add(this.latitude);
        }
    }

    static class Radius
    implements GeoPredicate {
        final double distance;
        final GeoArgs.Unit unit;

        public Radius(double distance, GeoArgs.Unit unit) {
            this.distance = distance;
            this.unit = unit;
        }

        @Override
        public <K, V> void build(CommandArgs<K, V> args) {
            args.add("BYRADIUS").add(this.distance).add(this.unit);
        }
    }

    static class Box
    implements GeoPredicate {
        final double width;
        final double height;
        final GeoArgs.Unit unit;

        public Box(double width, double height, GeoArgs.Unit unit) {
            this.width = width;
            this.height = height;
            this.unit = unit;
        }

        @Override
        public <K, V> void build(CommandArgs<K, V> args) {
            args.add("BYBOX").add(this.width).add(this.height).add(this.unit);
        }
    }

    public static interface GeoPredicate
    extends CompositeArgument {
    }

    public static interface GeoRef<K>
    extends CompositeArgument {
    }
}

