/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.ProtocolKeyword;

public class GeoArgs
implements CompositeArgument {
    private boolean withdistance;
    private boolean withcoordinates;
    private boolean withhash;
    private Long count;
    private boolean any;
    private Sort sort = Sort.none;

    public GeoArgs withDistance() {
        this.withdistance = true;
        return this;
    }

    public GeoArgs withCoordinates() {
        this.withcoordinates = true;
        return this;
    }

    public GeoArgs withHash() {
        this.withhash = true;
        return this;
    }

    public GeoArgs withCount(long count) {
        return this.withCount(count, false);
    }

    public GeoArgs withCount(long count, boolean any) {
        LettuceAssert.isTrue(count > 0L, "Count must be greater 0");
        this.count = count;
        this.any = any;
        return this;
    }

    public boolean isWithDistance() {
        return this.withdistance;
    }

    public boolean isWithCoordinates() {
        return this.withcoordinates;
    }

    public boolean isWithHash() {
        return this.withhash;
    }

    public GeoArgs asc() {
        return this.sort(Sort.asc);
    }

    public GeoArgs desc() {
        return this.sort(Sort.desc);
    }

    public GeoArgs sort(Sort sort) {
        LettuceAssert.notNull((Object)sort, "Sort must not be null");
        this.sort = sort;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.withdistance) {
            args.add("WITHDIST");
        }
        if (this.withhash) {
            args.add("WITHHASH");
        }
        if (this.withcoordinates) {
            args.add("WITHCOORD");
        }
        if (this.sort != null && this.sort != Sort.none) {
            args.add(this.sort.name());
        }
        if (this.count != null) {
            args.add(CommandKeyword.COUNT).add(this.count);
            if (this.any) {
                args.add("ANY");
            }
        }
    }

    public static enum Sort {
        asc,
        desc,
        none;

    }

    public static enum Unit implements ProtocolKeyword
    {
        m,
        km,
        ft,
        mi;

        private final byte[] asBytes = this.name().getBytes();

        @Override
        public byte[] getBytes() {
            return this.asBytes;
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static GeoArgs distance() {
            return new GeoArgs().withDistance();
        }

        public static GeoArgs coordinates() {
            return new GeoArgs().withCoordinates();
        }

        public static GeoArgs hash() {
            return new GeoArgs().withHash();
        }

        public static GeoArgs full() {
            return new GeoArgs().withDistance().withCoordinates().withHash();
        }

        public static GeoArgs count(long count) {
            return new GeoArgs().withCount(count);
        }
    }
}

