/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.svn.wc;

import java.io.File;
import java.util.List;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.core.exceptions.WrapperException;
import org.magicwerk.brownies.svn.wc.SvnInfoCommand;
import org.magicwerk.brownies.svn.wc.SvnLogCommand;
import org.magicwerk.brownies.svn.wc.SvnPropGetCommand;
import org.magicwerk.brownies.svn.wc.SvnStatusCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.cli.svn.SVN;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SvnWcTools {
    static final Logger LOG = LoggerFactory.getLogger(SvnWcTools.class);

    public static boolean execute(String ... args) {
        return new SvnCli().execute(args);
    }

    public static boolean hasProperty(String file, String property) {
        SVNPropertyValue value = SvnWcTools.getPropertyValue(file, property);
        return value != null;
    }

    public static String getPropertyAsString(String file, String property) {
        SVNPropertyValue value = SvnWcTools.getPropertyValue(file, property);
        if (value == null) {
            return null;
        }
        return SVNPropertyValue.getPropertyAsString((SVNPropertyValue)value);
    }

    public static SVNPropertyValue getPropertyValue(String file, String property) {
        SvnPropGetCommand propGet = new SvnPropGetCommand().setFile(file).setPropName(property);
        SVNPropertyData data = propGet.getProperty();
        if (data == null) {
            return null;
        }
        return data.getValue();
    }

    public static boolean isVersioned(String file) {
        SvnStatusCommand propStatus = new SvnStatusCommand(file);
        SVNStatusType statusType = propStatus.getCommitStatus();
        return statusType != null && statusType != SVNStatusType.STATUS_UNVERSIONED;
    }

    public static IList<SVNLogEntry> getLogEntries(String file) {
        SvnLogCommand cmd = new SvnLogCommand().setPath(file);
        return cmd.getLogEntries();
    }

    public static SVNLogEntry getLogEntries(String file, long rev) {
        SvnLogCommand cmd = new SvnLogCommand().setPath(file).setRevision("" + rev);
        return (SVNLogEntry)cmd.getLogEntries().getSingleOrEmpty();
    }

    public static SVNInfo getInfo(String file) {
        SvnInfoCommand cmd = new SvnInfoCommand().setPath(file);
        return (SVNInfo)cmd.getInfos().getSingle();
    }

    public static List<SVNInfo> getInfo(String file, boolean recursive) {
        SvnInfoCommand cmd = new SvnInfoCommand().setPath(file).setRecursive(recursive);
        return cmd.getInfos();
    }

    public static SVNStatus getStatus(String file) {
        LOG.debug("SvnWcTools.getStatus {}", (Object)file);
        SvnStatusCommand statusCmd = new SvnStatusCommand(file);
        return statusCmd.getStatus();
    }

    public static SVNStatusType getStatusType(String file) {
        return SvnWcTools.getStatusType(SvnWcTools.getStatus(file));
    }

    public static SVNStatusType getStatusType(SVNStatus status) {
        if (status == null) {
            return null;
        }
        return status.getCombinedNodeAndContentsStatus();
    }

    public static long getCommitRevision(SVNStatus status) {
        if (status.isVersioned() && status.getCommittedRevision().isValid()) {
            return status.getCommittedRevision().getNumber();
        }
        return -1L;
    }

    public static long getRevision(SVNStatus status) {
        if (status.isVersioned() && status.getRevision().isValid()) {
            return status.getRevision().getNumber();
        }
        return -1L;
    }

    public static IList<SVNStatus> getSvnStatusList(String dir, boolean recursive) {
        SVNClientManager clientManager = SVNClientManager.newInstance();
        boolean isRemote = false;
        boolean isReportUnmodified = true;
        boolean isIncludeIgnored = false;
        boolean isCollectParentExternals = false;
        StatusHandler statusHandler = new StatusHandler();
        try {
            clientManager.getStatusClient().doStatus(new File(dir), recursive, isRemote, isReportUnmodified, isIncludeIgnored, isCollectParentExternals, (ISVNStatusHandler)statusHandler);
        }
        catch (SVNException e) {
            throw new WrapperException((Throwable)e);
        }
        return statusHandler.statusList;
    }

    static class StatusHandler
    implements ISVNStatusHandler,
    ISVNEventHandler {
        IList<SVNStatus> statusList = GapList.create();

        StatusHandler() {
        }

        public void handleStatus(SVNStatus status) {
            this.statusList.add((Object)status);
        }

        public void handleEvent(SVNEvent event, double progress) {
            SVNEventAction action = event.getAction();
            if (action == SVNEventAction.STATUS_COMPLETED) {
                System.out.println("Status against revision:  " + event.getRevision());
            }
        }

        public void checkCancelled() throws SVNCancelException {
        }
    }

    static class SvnCli
    extends SVN {
        boolean success;

        SvnCli() {
        }

        public boolean execute(String ... args) {
            super.run(args);
            return this.success;
        }

        public void failure() {
            this.success = false;
        }

        public void success() {
            this.success = true;
        }
    }
}

