/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.svn;

import java.io.InputStream;
import java.util.Map;
import org.magicwerk.brownies.core.ObjectTools;
import org.magicwerk.brownies.core.StreamTools;
import org.magicwerk.brownies.svn.ISvnEntry;
import org.magicwerk.brownies.svn.ISvnFile;
import org.magicwerk.brownies.svn.SvnFile;
import org.magicwerk.brownies.svn.SvnSession;
import org.tmatesoft.svn.core.SVNProperty;

public class SvnTools {
    public static boolean isTextType(ISvnFile file) {
        String mimeType = (String)file.getSystemProperties().get("svn:mime-type");
        boolean isTextType = SVNProperty.isTextMimeType((String)mimeType);
        return isTextType;
    }

    public static boolean isContentEqual(SvnSession session, String path1, long rev1, String path2, long rev2) {
        SvnFile file1 = session.getFile(path1, rev1);
        SvnFile file2 = session.getFile(path2, rev2);
        return SvnTools.isContentEqual(file1, file2);
    }

    public static boolean isContentEqual(ISvnFile file1, ISvnFile file2) {
        InputStream content2;
        InputStream content1 = file1.getContent();
        return StreamTools.diff((InputStream)content1, (InputStream)(content2 = file2.getContent())) == 0L;
    }

    public static boolean isPropertiesEqual(ISvnEntry entry1, ISvnEntry entry2) {
        Map<String, Object> properties1 = entry1.getProperties();
        Map<String, Object> properties2 = entry2.getProperties();
        return ObjectTools.equals(properties1, properties2);
    }
}

