/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.svn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.magicwerk.brownies.core.files.PathTools;
import org.magicwerk.brownies.core.files.filemodel.IEntry;
import org.magicwerk.brownies.svn.ISvnDirectory;
import org.magicwerk.brownies.svn.SvnEntry;
import org.magicwerk.brownies.svn.SvnFile;
import org.magicwerk.brownies.svn.SvnSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;

public class SvnDirectory
extends SvnEntry
implements ISvnDirectory {
    private static Logger LOG = LoggerFactory.getLogger(SvnDirectory.class);

    SvnDirectory(SvnSession connection, String path, long revision, SVNDirEntry info) {
        super(connection, path, revision, info);
    }

    public IEntry.Type getType() {
        return IEntry.Type.DIRECTORY;
    }

    public List<IEntry> list() {
        try {
            ArrayList<IEntry> list = new ArrayList<IEntry>();
            LOG.debug("SVN: getDir entries ({}, {})", (Object)this.getPath(), (Object)this.getRevision());
            Collection entries = this.getSession().getRepository().getDir(this.getSession().getLocalPath(this.getPath()), this.getRevision(), null, (Collection)null);
            LOG.debug("SVN: getDir entries done");
            for (SVNDirEntry entry : entries) {
                String path = PathTools.getPath((String)this.getSession().getLocalPath(this.getPath()), (String)entry.getName());
                if (entry.getKind() == SVNNodeKind.DIR) {
                    SvnDirectory dir = new SvnDirectory(this.getSession(), path, this.getRevision(), entry);
                    list.add(dir);
                    continue;
                }
                if (entry.getKind() != SVNNodeKind.FILE) continue;
                SvnFile file = new SvnFile(this.getSession(), path, this.getRevision(), entry);
                list.add(file);
            }
            return list;
        }
        catch (SVNException e) {
            throw new RuntimeException(e);
        }
    }
}

