/*
 * Copyright 2011 by Thomas Mauch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id$
 */
package org.magicwerk.brownies.svn.wc;

import java.util.List;

import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.svn.SVNPropGetCommand;
import org.tmatesoft.svn.core.wc.SVNPropertyData;

/**
 * Implementation of the SVN command "prop get".
 *
 * @author Thomas Mauch
 * @version $Id$
 */
public class SvnPropGetCommand extends SvnCommand {
	private String file;
	private String propName;
	private SVNPropertyData propData;

	public SvnPropGetCommand setFile(String file) {
		this.file = file;
		return this;
	}

	public SvnPropGetCommand setPropName(String propName) {
		this.propName = propName;
		return this;
	}

	/**
	 * Returns data for property.
	 * 
	 * @return	property data
	 */
	public SVNPropertyData getProperty() {
		String[] args = { "propget", "-v", propName, file };
		run(args);
		return propData;
	}

	@Override
	protected AbstractSVNCommand getCommand() {
		return new SVNPropGetCommand() {
			@SuppressWarnings("rawtypes")
			@Override
			protected void printProplist(List props) {
				for (Object prop : props) {
					SVNPropertyData data = (SVNPropertyData) prop;
					if (data.getName().equals(propName)) {
						propData = data;
					}
				}
			}
		};
	}
}
