/*
 * Copyright 2010 by Thomas Mauch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: SvnFile.java 1046 2011-01-09 22:10:10Z magic $
 */
package org.magicwerk.brownies.svn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import org.magicwerk.brownies.core.strings.escape.StringEscapeTools;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;

/**
 * Representation of a file in a SVN repository.
 * 
 * @author Thomas Mauch
 * @version $Id: SvnFile.java 1046 2011-01-09 22:10:10Z magic $
 */
public class SvnFile extends SvnEntry implements ISvnFile {
	private ByteArrayOutputStream content;

	SvnFile(SvnSession connection, String path, long revision, SVNDirEntry info) {
		super(connection, path, revision, info);
	}

	@Override
	public Type getType() {
		return Type.FILE;
	}

	@Override
	public boolean isTextType() {
		return SvnTools.isTextType(this);
	}

	@Override
	public InputStream getContent() {
		return new ByteArrayInputStream(readContent().toByteArray());
	}

	@Override
	public byte[] getHash() {
		String checksum = getSystemPropertyAsString("svn:entry:checksum");
		byte[] checksumBytes = StringEscapeTools.fromHex(checksum);
		return checksumBytes;

		//		if (hash == null) {
		//			hash = ChksumTools.getMd5(StreamTools.getInputStream(readContent()));
		//		}
		//		assert(Arrays.equals(hash, checksumBytes));
		//		String hashStr = StringTools.toHex(hash);
		//		assert checksum.equals(hashStr);
		//		return hash;

	}

	@Override
	public long getSize() {
		return getInfo().getSize();
	}

	//    long readSize() {
	//    	try {
	//    		content = new ByteArrayOutputStream();
	//    		SVNDirEntry entry = getSession().getRepository().info(getPath(), getRevision());
	//    		return entry.getSize();
	//    	}
	//	    catch (SVNException e) {
	//	        throw new RuntimeException(e);
	//	    }
	//    }

	ByteArrayOutputStream readContent() {
		if (content != null) {
			return content;
		}
		try {
			content = new ByteArrayOutputStream();
			getSession().getRepository().getFile(getPath(), getRevision(), null, content);
			return content;
		} catch (SVNException e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public void getContent(OutputStream content) {
		try {
			getSession().getRepository().getFile(getPath(), getRevision(), null, content);
		} catch (SVNException e) {
			throw new RuntimeException(e);
		}
	}
}

//class ContentOutputStream extends OutputStream {
//	private List<StreamConsumer> consumers = new ArrayList<StreamConsumer>();
//	
//	public void addConsumer(StreamConsumer consumer) {
//		consumers.add(consumer);
//	}
//	
//    @Override
//	public void write(byte[] data) throws IOException {
//		for (StreamConsumer consumer: consumers) {
//			consumer.consume(data, 0, data.length);
//		}
//	}
//	
//	@Override
//    public void write(byte b[], int off, int len) throws IOException {
//		for (StreamConsumer consumer: consumers) {
//			consumer.consume(b, off, len);
//		}
//	}
//
//	@Override
//	public void write(int b) throws IOException {
//		// not called by SVNKit and therefore not implemented
//		throw new AssertionError();
//	}
//
//}
//
//interface StreamConsumer {
//	/**
//	 * Consume the given data.
//	 * The data passed must not be altered.
//	 * 
//	 * @param data
//	 * @param off
//	 * @param len
//	 */
//	void consume(byte[] data, int off, int len);
//}
//
//class HashProvider implements StreamConsumer {
//	private MessageDigest digest = ChksumTools.getMd5Digest();
//	
//	@Override
//	public void consume(byte[] data, int off, int len) {
//		digest.update(data, off, len);
//	}
//
//	public byte[] getHash() {
//		byte[] hash = digest.digest();
//		return hash;
//	}
//}
//
//class SizeProvider implements StreamConsumer {
//	private long size;
//	
//	public long getSize() {
//		return size;
//	}
//	
//	@Override
//	public void consume(byte[] data, int off, int len) {
//		size += len;
//	}
//}
//
//class OutputConsumer implements StreamConsumer {
//	private OutputStream output;
//	
//	public OutputConsumer(OutputStream output) {
//		this.output = output;
//	}
//	
//	@Override
//	public void consume(byte[] data, int off, int len) {
//		try {
//			output.write(data, off, len);
//		}
//		catch (IOException e) {
//			throw new RuntimeException(e);
//		}
//	}
//}
