/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.svn.wc;

import java.io.FileOutputStream;
import java.io.OutputStream;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.core.StreamTools;
import org.magicwerk.brownies.core.exceptions.WrapperException;
import org.magicwerk.brownies.svn.wc.SvnCommand;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.svn.SVNCatCommand;

public class SvnCatCommand
extends SvnCommand {
    private String path;
    private long revision;
    private String target;
    private FileOutputStream fileOutputStream;

    public SvnCatCommand(String path, long revision, String target) {
        this.path = path;
        this.revision = revision;
        this.target = target;
    }

    @Override
    protected OutputStream getOutputStream() {
        try {
            if (this.target != null) {
                this.fileOutputStream = new FileOutputStream(this.target);
                return this.fileOutputStream;
            }
            return System.out;
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
    }

    @Override
    protected void dispose() {
        StreamTools.close((OutputStream)this.fileOutputStream);
    }

    public void execute() {
        GapList args = GapList.create();
        args.add((Object)"cat");
        if (this.revision != -1L) {
            args.addArray((Object[])new String[]{"-r", String.valueOf(this.revision)});
        }
        args.add((Object)this.path);
        this.run((String[])args.toArray((Object[])new String[0]));
    }

    @Override
    protected AbstractSVNCommand getCommand() {
        return new SVNCatCommand();
    }
}

