/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.svn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.magicwerk.brownies.core.files.filemodel.IEntry;
import org.magicwerk.brownies.core.strings.escape.StringEscapeTools;
import org.magicwerk.brownies.svn.ISvnFile;
import org.magicwerk.brownies.svn.SvnEntry;
import org.magicwerk.brownies.svn.SvnSession;
import org.magicwerk.brownies.svn.SvnTools;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;

public class SvnFile
extends SvnEntry
implements ISvnFile {
    private ByteArrayOutputStream content;

    SvnFile(SvnSession connection, String path, long revision, SVNDirEntry info) {
        super(connection, path, revision, info);
    }

    public IEntry.Type getType() {
        return IEntry.Type.FILE;
    }

    @Override
    public boolean isTextType() {
        return SvnTools.isTextType(this);
    }

    public InputStream getContent() {
        return new ByteArrayInputStream(this.readContent().toByteArray());
    }

    @Override
    public byte[] getHash() {
        String checksum = this.getSystemPropertyAsString("svn:entry:checksum");
        byte[] checksumBytes = StringEscapeTools.fromHex((String)checksum);
        return checksumBytes;
    }

    public long getSize() {
        return this.getInfo().getSize();
    }

    ByteArrayOutputStream readContent() {
        if (this.content != null) {
            return this.content;
        }
        try {
            this.content = new ByteArrayOutputStream();
            this.getSession().getRepository().getFile(this.getPath(), this.getRevision(), null, (OutputStream)this.content);
            return this.content;
        }
        catch (SVNException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void getContent(OutputStream content) {
        try {
            this.getSession().getRepository().getFile(this.getPath(), this.getRevision(), null, content);
        }
        catch (SVNException e) {
            throw new RuntimeException(e);
        }
    }
}

