/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.svn;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.magicwerk.brownies.core.CharsetTools;
import org.magicwerk.brownies.core.files.PathTools;
import org.magicwerk.brownies.core.files.filemodel.IDirectory;
import org.magicwerk.brownies.core.files.filemodel.IEntry;
import org.magicwerk.brownies.core.time.TimeTools;
import org.magicwerk.brownies.svn.ISvnEntry;
import org.magicwerk.brownies.svn.SvnSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;

public abstract class SvnEntry
implements ISvnEntry {
    static final Logger LOG = LoggerFactory.getLogger(SvnEntry.class);
    private SvnSession session;
    private String path;
    private long revision;
    private Map<String, Object> properties;
    private Map<String, Object> systemProperties;
    private SVNDirEntry info;

    protected SvnEntry(SvnSession session, String path, long revision, SVNDirEntry info) {
        this.session = session;
        this.path = path;
        this.revision = revision;
        this.info = info;
    }

    SVNDirEntry getInfo() {
        if (this.info == null) {
            this.info = this.session.readInfo(this.path, this.revision);
            SVNNodeKind nodeKind = this.info.getKind();
            if (this.getType() == IEntry.Type.FILE && nodeKind != SVNNodeKind.FILE || this.getType() == IEntry.Type.DIRECTORY && nodeKind != SVNNodeKind.DIR) {
                throw new IllegalStateException();
            }
        }
        return this.info;
    }

    Map<String, Object> readProperties() {
        if (this.properties == null) {
            this.initProperties();
        }
        return this.properties;
    }

    Map<String, Object> readSystemProperties() {
        if (this.properties == null) {
            this.initProperties();
        }
        return this.systemProperties;
    }

    void initProperties() {
        try {
            SVNProperties svnProperties = new SVNProperties();
            switch (this.getType()) {
                case DIRECTORY: {
                    LOG.debug("SVN: getDir properties ({}, {})", (Object)this.path, (Object)this.revision);
                    this.getSession().getRepository().getDir(this.path, this.revision, svnProperties, (ISVNDirEntryHandler)null);
                    LOG.debug("SVN: getDir properties done");
                    break;
                }
                case FILE: {
                    LOG.debug("SVN: getFile properties ({}, {})", (Object)this.path, (Object)this.revision);
                    this.getSession().getRepository().getFile(this.path, this.revision, svnProperties, null);
                    LOG.debug("SVN: getFile properties done");
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.properties = new TreeMap<String, Object>();
            this.systemProperties = new TreeMap<String, Object>();
            Iterator iterator = svnProperties.asMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry obj;
                Map.Entry entry = obj = iterator.next();
                String name = (String)entry.getKey();
                SVNPropertyValue value = (SVNPropertyValue)entry.getValue();
                if (SVNProperty.isRegularProperty((String)name)) {
                    this.properties.put(name, SVNPropertyValue.getPropertyAsBytes((SVNPropertyValue)value));
                    continue;
                }
                this.systemProperties.put(name, SVNPropertyValue.getPropertyAsBytes((SVNPropertyValue)value));
            }
        }
        catch (SVNException e) {
            throw new RuntimeException(e);
        }
    }

    public SvnSession getSession() {
        return this.session;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    @Override
    public long getCommitRevision() {
        return this.getInfo().getRevision();
    }

    @Override
    public String getCommitAuthor() {
        return this.getInfo().getAuthor();
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.readProperties();
    }

    @Override
    public Map<String, Object> getSystemProperties() {
        return this.readSystemProperties();
    }

    @Override
    public byte[] getProperty(String name) {
        return (byte[])this.readProperties().get(name);
    }

    @Override
    public String getPropertyAsString(String name) {
        byte[] data = this.getProperty(name);
        return CharsetTools.getString((byte[])data);
    }

    @Override
    public byte[] getSystemProperty(String name) {
        return (byte[])this.readSystemProperties().get(name);
    }

    @Override
    public String getSystemPropertyAsString(String name) {
        byte[] data = this.getSystemProperty(name);
        if (data == null) {
            return null;
        }
        return CharsetTools.getString((byte[])data);
    }

    public ZonedDateTime getLastModifiedDate() {
        String dateStr = this.getSystemPropertyAsString("svn:entry:committed-date");
        Instant d = Instant.parse(dateStr);
        ZonedDateTime date = TimeTools.toZonedDateTime((Date)this.getInfo().getDate());
        return date;
    }

    public String getName() {
        return PathTools.getName((String)this.path);
    }

    public IDirectory getParent() {
        String root;
        String path = this.getPath();
        if (path.equals(root = this.session.getRepositoryRoot())) {
            return null;
        }
        String parentPath = PathTools.getDir((String)path);
        return this.session.getDirectory(parentPath);
    }

    public String toString() {
        return this.getPath() + " [" + this.getType().toString() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.session == null ? 0 : this.session.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SvnEntry other = (SvnEntry)obj;
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.session == null ? other.session != null : !this.session.equals(other.session));
    }
}

