package org.magicwerk.brownies.svn.log;

import java.io.InputStream;

import org.exolab.castor.mapping.Mapping;
import org.magicwerk.brownies.castor.CastorTools;
import org.magicwerk.brownies.core.StreamTools;


/**
 * Tools for handling SVN log files.
 * 
 * @author Thomas Mauch
 * @version $Id$
 */
public class LogTools {
	/**
	 * Read SVN log file as produced by the commands
	 * "svn log --xml" or "svn log --xml -v".
	 * 
	 * @param file	file path
	 * @return		parsed log data
	 */
	static public Log readLogFile(String file) {
		InputStream in = null;
		try {
			in = LogTools.class.getResourceAsStream("svn-log.map.xml");
			Mapping mapping = CastorTools.loadMapping(in);
			Log log = (Log) CastorTools.readObject(file, "UTF-8", mapping);
			return log;
		} 
		finally {
			StreamTools.close(in);
		}
	}
	
}
