package org.magicwerk.brownies.svn.log;

import java.util.Date;
import java.util.List;

import org.magicwerk.brownies.core.print.PrintTools;

/**
 * Represent all entries related to a single commit log entry.
 * It contains exactly the information stored in a {@literal <logentry>} item
 * of the svn log output.
 *
 * @author Thomas Mauch
 * @version $Id$
 */
public class LogEntry {
	private int revision;
	private String author;
	private Date date; // 2008-07-23T09:49:10.588500Z
	private String message;
	private List<Path> revisionPaths;

	/**
	 * @return the revisionPaths
	 */
	public List<Path> getRevisionPaths() {
		return revisionPaths;
	}

	/**
	 * @param revisionPaths the logEntries to set
	 */
	public void setRevisionPaths(List<Path> revisionPaths) {
		this.revisionPaths = revisionPaths;
	}

	/**
	 * @return the date
	 */
	public Date getDate() {
		return date;
	}

	/**
	 * @param date the date to set
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * @return the message
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * @param message the message to set
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * @return the revision
	 */
	public int getRevision() {
		return revision;
	}

	/**
	 * @param revision the revision to set
	 */
	public void setRevision(int revision) {
		this.revision = revision;
	}

	/**
	 * @return the author
	 */
	public String getAuthor() {
		return author;
	}

	/**
	 * @param author the author to set
	 */
	public void setAuthor(String author) {
		this.author = author;
	}

	@Override
	public String toString() {
		return PrintTools.printToString(this);
	}
}
