/*
 * Copyright 2010 by Thomas Mauch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: SvnTools.java 1046 2011-01-09 22:10:10Z magic $
 */
package org.magicwerk.brownies.svn;

import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.core.status.Status;
import org.magicwerk.brownies.core.streams.CaptureSystemOutput;
import org.magicwerk.brownies.core.streams.CaptureSystemOutput.CaptureMode;
import org.tmatesoft.svn.cli.svn.SVN;

/**
 * Tools for working with Subversion.
 *
 * @author Thomas Mauch
 * @version $Id: SvnTools.java 1046 2011-01-09 22:10:10Z magic $
 */
public class SvnRunner extends SVN {

	boolean capture = true;
	boolean print = true;
	int status = 0;

	public Status exec(IList<String> args) {
		int status = 0;
		String out = null;
		try {
			CaptureSystemOutput.startCapture(CaptureMode.SystemOutErr, !print);
			super.run(args.toArray(String.class));
		} finally {
			if (capture) {
				out = CaptureSystemOutput.stopCapture();
			}
		}
		return Status.of(status).setMessage(out);
	}

	public SvnRunner setCapture(boolean capture) {
		this.capture = capture;
		return this;
	}

	public SvnRunner setPrint(boolean print) {
		this.print = print;
		return this;
	}

	@Override
	public void failure() {
		status = 1;
	}

	@Override
	public void success() {
		status = 0;
	}

}
