/*
 * Copyright 2010 by Thomas Mauch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: ISvnSession.java 842 2010-08-19 23:15:33Z magic $
 */
package org.magicwerk.brownies.svn;

import org.magicwerk.brownies.core.files.filemodel.IEntry;
import org.magicwerk.brownies.core.files.filemodel.ISession;

public interface ISvnSession extends ISession {
	public String getRepositoryRoot();
	
	//@Override
	public ISvnDirectory getRoot();
	public ISvnDirectory getRoot(long revision);

	/**
	 * Return ISvnEntry reference to requested file in revision head.
	 * 
	 * @see 			#getEntry(String, long)
	 * @param path		path to entry
	 * @return			reference to requested entry
	 * @throws			RuntimeException if no such entry is found
	 */
	public ISvnEntry getEntry(String path);

	/**
	 * Return ISvnFile reference to requested file in revision head.
	 * 
	 * @see 			#getFile(String, long)
	 * @param path		path to file
	 * @return			reference to requested file
	 * @throws			RuntimeException if no such file is found
	 */
	public ISvnFile getFile(String path);

	/**
	 * Return ISvnDir reference to requested directory in revision head.
	 * 
	 * @see 			#getFile(String, long)
	 * @param path		path to directory
	 * @return			reference to requested directory
	 * @throws			RuntimeException if no such directory is found
	 */
	public ISvnDirectory getDirectory(String path);

	/**
	 * Gets the head revision number of the repository
 	 *
	 * @return	revision number of head
	 */
	public long getHeadRevision();

	/**
	 * Return ISvnEntry reference to requested entry.
	 * 
	 * @param path		path to entry
	 * @param revision	revision number (use -1 for head revision)
	 * @return			reference to requested entry
	 * @throws			RuntimeException if no such entry is found
	 */
	public ISvnEntry getEntry(String path, long revision);

	/**
	 * Return ISvnFile reference to requested file.
	 * 
	 * @param path		Path to file
	 * @param revision	revision number (use -1 for head revision)
	 * @return			reference to requested file
	 * @throws			RuntimeException if no such file is found
	 */
	public ISvnFile getFile(String path, long revision);

	/**
	 * Return ISvnDir reference to requested directory.
	 * 
	 * @param path		path to directory
	 * @param revision	revision number (use -1 for head revision)
	 * @return			reference to requested directory
	 * @throws			RuntimeException if no such directory is found
	 */
	public ISvnDirectory getDirectory(String path, long revision);

	/**
	 * Returns type of entry with given path and revision.
	 * If no such entry exists, null is returned.
	 * 
	 * @param path		path to entry
	 * @param revision	revision number (use -1 for head revision)
	 * @return			type of entry or null
	 */
	public IEntry.Type getType(String path, long revision);
}