/*
 * Copyright 2010 by Thomas Mauch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: ISvnFile.java 842 2010-08-19 23:15:33Z magic $
 */
package org.magicwerk.brownies.svn;

import java.io.OutputStream;

import org.magicwerk.brownies.core.files.filemodel.IFile;


/**
 * Representation of a file in a SVN repository.
 * 
 * @author Thomas Mauch
 * @version $Id: ISvnFile.java 842 2010-08-19 23:15:33Z magic $
 */
public interface ISvnFile extends IFile, ISvnEntry {
	/**
	 * Determines whether this is text or binary file.
	 * The decision is based on the property svn:mime-type.
	 * 
	 * @return true for text file, false for binary file.
	 */
	public boolean isTextType();

	public byte[] getHash();
	
	public void getContent(OutputStream output);
}
