/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.svn.wc;

import java.util.List;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.svn.SvnException;
import org.magicwerk.brownies.svn.wc.SvnCommand;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.svn.SVNInfoCommand;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNInfo;

public class SvnInfoCommand
extends SvnCommand {
    String file;
    boolean recursive;
    IList<SVNInfo> infos;

    public SvnInfoCommand setPath(String file) {
        this.file = file;
        return this;
    }

    public SvnInfoCommand setRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    @Override
    public List<String> buildArgs() {
        GapList args = GapList.create();
        args.addArray((Object[])new String[]{"info", this.file});
        if (this.recursive) {
            args.add((Object)"-R");
        }
        return args;
    }

    public IList<SVNInfo> getInfos() {
        block2: {
            try {
                this.infos = GapList.create();
                this.run();
            }
            catch (SvnException e) {
                SVNException se = (SVNException)e.getCause();
                int code = se.getErrorMessage().getErrorCode().getCode();
                if (code != 2009) break block2;
                return null;
            }
        }
        return this.infos;
    }

    @Override
    protected AbstractSVNCommand getCommand() {
        return new SVNInfoCommand(){

            protected void printInfo(SVNInfo info) {
                SvnInfoCommand.this.monitor.updated((Object)("Getting info for " + SvnInfoCommand.getFilePath(info)));
                SvnInfoCommand.this.infos.add((Object)info);
            }
        };
    }

    public static String getFilePath(SVNInfo info) {
        return info.getFile().getPath();
    }

    public static String getUrlPath(SVNInfo info) {
        return info.getURL().getPath();
    }
}

