/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.svn.wc;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.core.PrintTools;
import org.magicwerk.brownies.core.context.IMonitor;
import org.magicwerk.brownies.core.context.Monitor;
import org.magicwerk.brownies.core.streams.NullPrintStream;
import org.magicwerk.brownies.core.strings.StringPrinter;
import org.magicwerk.brownies.core.strings.escape.StringListEscaper;
import org.magicwerk.brownies.svn.SvnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.AbstractSVNCommandEnvironment;
import org.tmatesoft.svn.cli.svn.SVN;
import org.tmatesoft.svn.cli.svn.SVNCommandEnvironment;
import org.tmatesoft.svn.core.SVNException;

public abstract class SvnCommand
extends SVN {
    static final Logger LOG = LoggerFactory.getLogger(SvnCommand.class);
    static final StringListEscaper argsEscaper = StringListEscaper.DosListEscaper();
    SVNException exception;
    IMonitor monitor = Monitor.get();
    List<String> args;

    protected void run() {
        List<String> cmdArgs = this.args != null ? this.args : this.buildArgs();
        String[] cmdArgsArray = cmdArgs.toArray(new String[0]);
        this.run(cmdArgsArray);
    }

    protected List<String> buildArgs() {
        return null;
    }

    public SvnCommand setArgs(String ... args) {
        this.args = GapList.create((Object[])args);
        return this;
    }

    public SvnCommand setArgs(List<String> args) {
        this.args = GapList.create(args);
        return this;
    }

    public SvnCommand setArgLine(String argLine) {
        this.args = argsEscaper.decode(argLine);
        return this;
    }

    public void run(String[] args) {
        LOG.debug("Executing {}", (Object)PrintTools.toString((Object)args));
        super.run(args);
        if (this.exception != null) {
            String cmd = new StringPrinter().setElemMarker(" ").addAll((Iterable)GapList.create((Object[])args)).toString();
            String msg = "Command svn " + cmd + " failed";
            throw new SvnException(msg, this.exception);
        }
    }

    protected abstract AbstractSVNCommand getCommand();

    protected void registerCommands() {
        AbstractSVNCommand.registerCommand((AbstractSVNCommand)this.getCommand());
    }

    protected OutputStream getOutputStream() {
        return NullPrintStream.INSTANCE;
    }

    protected AbstractSVNCommandEnvironment createCommandEnvironment() {
        return new SVNCommandEnvironment(this.getProgramName(), new PrintStream(this.getOutputStream()), (PrintStream)NullPrintStream.INSTANCE, null){

            public boolean run() {
                this.getCommand().init((AbstractSVNCommandEnvironment)this);
                try {
                    this.getCommand().run();
                }
                catch (SVNException e) {
                    SvnCommand.this.exception = e;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.getOut().flush();
                    this.getErr().flush();
                }
                return true;
            }

            public void dispose() {
                SvnCommand.this.dispose();
                super.dispose();
            }
        };
    }

    protected void dispose() {
    }

    public void success() {
    }

    public void failure() {
    }
}

