/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.svn;

import java.util.ArrayList;
import java.util.List;
import org.magicwerk.brownies.core.StringTools;
import org.magicwerk.brownies.core.files.filemodel.IEntry;
import org.magicwerk.brownies.core.files.filemodel.ISession;
import org.magicwerk.brownies.svn.ISvnSession;
import org.magicwerk.brownies.svn.SvnAuthException;
import org.magicwerk.brownies.svn.SvnDirectory;
import org.magicwerk.brownies.svn.SvnEntry;
import org.magicwerk.brownies.svn.SvnException;
import org.magicwerk.brownies.svn.SvnFile;
import org.magicwerk.brownies.svn.log.LogEntry;
import org.magicwerk.brownies.svn.log.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;

public class SvnSession
implements ISession,
ISvnSession {
    private static Logger LOG = LoggerFactory.getLogger(SvnSession.class);
    private SVNRepository repository;
    private String repositoryRoot;
    private long defaultRevision = -1L;
    private String username;
    private String password;

    public SvnSession(String url, String username, String password) {
        this.username = username;
        this.password = password;
        try {
            this.repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)url));
            BasicAuthenticationManager authManager = new BasicAuthenticationManager(username, password);
            this.repository.setAuthenticationManager((ISVNAuthenticationManager)authManager);
            SVNURL svnUrl = this.repository.getRepositoryRoot(true);
            this.repositoryRoot = svnUrl.toDecodedString();
            this.repository.setLocation(svnUrl, false);
        }
        catch (SVNAuthenticationException e) {
            throw new SvnAuthException(e);
        }
        catch (SVNException e) {
            throw new SvnException(e);
        }
    }

    public void close() {
        this.repository.closeSession();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public static SvnDirectory getDirectory(String url, String username, String password) {
        SvnSession conn = new SvnSession(url, username, password);
        String root = conn.getRepositoryRoot();
        String dir = StringTools.removeHeadIf((String)url, (String)root);
        return conn.getDirectory(dir);
    }

    public static SvnFile getFile(String url, String username, String password, long revision) {
        SvnSession conn = new SvnSession(url, username, password);
        String root = conn.getRepositoryRoot();
        String file = StringTools.removeHeadIf((String)url, (String)root);
        return conn.getFile(file, revision);
    }

    public long getDefaultRevision() {
        return this.defaultRevision;
    }

    public void setDefaultRevision(long defaultRevision) {
        this.defaultRevision = defaultRevision;
    }

    public SVNRepository getRepository() {
        return this.repository;
    }

    String getLocalPath(String path) {
        if (StringTools.isEmpty((String)path) || path.startsWith("/")) {
            return path;
        }
        String localPath = StringTools.removeHead((String)path, (String)this.repositoryRoot);
        if (localPath == null) {
            throw new IllegalArgumentException("Path " + path + " does not match root " + this.repositoryRoot);
        }
        return localPath;
    }

    @Override
    public String getRepositoryRoot() {
        return this.repositoryRoot;
    }

    @Override
    public long getHeadRevision() {
        try {
            return this.repository.getLatestRevision();
        }
        catch (SVNException svne) {
            throw new SvnException(svne);
        }
    }

    @Override
    public SvnFile getFile(String path) {
        return this.getFile(path, this.defaultRevision);
    }

    @Override
    public SvnDirectory getDirectory(String path) {
        return this.getDirectory(path, this.defaultRevision);
    }

    public boolean isDirectory(String path) {
        return this.isDirectory(path, this.defaultRevision);
    }

    public boolean isFile(String path) {
        return this.isFile(path, this.defaultRevision);
    }

    public boolean isDirectory(String path, long revision) {
        path = this.getLocalPath(path);
        try {
            SVNNodeKind nodeKind = this.repository.checkPath(path, revision);
            return nodeKind == SVNNodeKind.DIR;
        }
        catch (SVNException svne) {
            throw new SvnException(svne);
        }
    }

    public boolean isFile(String path, long revision) {
        path = this.getLocalPath(path);
        try {
            SVNNodeKind nodeKind = this.repository.checkPath(path, revision);
            return nodeKind == SVNNodeKind.FILE;
        }
        catch (SVNException svne) {
            throw new SvnException(svne);
        }
    }

    @Override
    public SvnDirectory getRoot() {
        return this.getRoot(this.defaultRevision);
    }

    @Override
    public SvnDirectory getRoot(long revision) {
        return this.getDirectory(this.repositoryRoot, revision);
    }

    public IEntry.Type getType(String path) {
        return this.getType(path, this.defaultRevision);
    }

    SVNDirEntry readInfo(String path, long revision) {
        try {
            LOG.debug("SVN: readInfo ({}, {})", (Object)path, (Object)revision);
            SVNDirEntry info = this.repository.info(path, revision);
            LOG.debug("SVN: readInfo done");
            return info;
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (SVNException e) {
            throw new SvnException(e);
        }
    }

    private SvnFile readFile(String path, long revision, SVNDirEntry info) {
        return new SvnFile(this, path, revision, info);
    }

    private SvnDirectory readDirectory(String path, long revision, SVNDirEntry info) {
        return new SvnDirectory(this, path, revision, info);
    }

    @Override
    public IEntry.Type getType(String path, long revision) {
        SVNDirEntry info = this.readInfo(path = this.getLocalPath(path), revision);
        if (info == null) {
            return null;
        }
        SVNNodeKind nodeKind = info.getKind();
        if (nodeKind == SVNNodeKind.FILE) {
            return IEntry.Type.FILE;
        }
        if (nodeKind == SVNNodeKind.DIR) {
            return IEntry.Type.DIRECTORY;
        }
        throw new AssertionError();
    }

    @Override
    public SvnEntry getEntry(String path) {
        return this.getEntry(path, this.defaultRevision);
    }

    @Override
    public SvnEntry getEntry(String path, long revision) {
        SVNDirEntry info = this.readInfo(path = this.getLocalPath(path), revision);
        if (info == null) {
            throw new RuntimeException("No entry found at " + path + " (revision " + revision + ")");
        }
        SVNNodeKind nodeKind = info.getKind();
        if (nodeKind == SVNNodeKind.DIR) {
            return this.readDirectory(path, revision, info);
        }
        if (nodeKind == SVNNodeKind.FILE) {
            return this.readFile(path, revision, info);
        }
        throw new AssertionError();
    }

    public SvnEntry getEntry(String path, long revision, IEntry.Type type) {
        switch (type) {
            case DIRECTORY: {
                return this.readDirectory(path, revision, null);
            }
            case FILE: {
                return this.readFile(path, revision, null);
            }
        }
        throw new AssertionError();
    }

    @Override
    public SvnFile getFile(String path, long revision) {
        SVNDirEntry info = this.readInfo(path = this.getLocalPath(path), revision);
        if (info == null || info.getKind() != SVNNodeKind.FILE) {
            throw new SvnException("No file found at " + path + " (revision " + revision + ")");
        }
        return this.readFile(path, revision, info);
    }

    @Override
    public SvnDirectory getDirectory(String path, long revision) {
        SVNDirEntry info = this.readInfo(path = this.getLocalPath(path), revision);
        if (info == null || info.getKind() != SVNNodeKind.DIR) {
            throw new SvnException("No directory found at " + path + " (revision " + revision + ")");
        }
        return this.readDirectory(path, revision, info);
    }

    public LogEntry getLogEntry(long rev) {
        return this.getLogEntries(rev, rev, null).get(0);
    }

    public LogEntry getLogEntry(long rev, String path) {
        return this.getLogEntries(rev, rev, path).get(0);
    }

    public List<LogEntry> getLogEntries(long startRev, long endRev) {
        return this.getLogEntries(startRev, endRev, null);
    }

    public List<LogEntry> getLogEntries(long startRev, long endRev, String path) {
        try {
            SVNURL location = null;
            String locationUri = null;
            if (path != null) {
                location = this.repository.getLocation();
                locationUri = location.toString();
                location = location.appendPath(path, false);
                this.repository.setLocation(location, false);
            }
            final ArrayList<LogEntry> logEntries = new ArrayList<LogEntry>();
            this.repository.log(new String[]{""}, startRev, endRev, true, true, new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry sle) {
                    logEntries.add(SvnSession.toLogEntry(sle));
                }
            });
            if (path != null) {
                location = SVNURL.parseURIEncoded((String)locationUri);
                this.repository.setLocation(location, false);
            }
            return logEntries;
        }
        catch (SVNException e) {
            throw new SvnException(e);
        }
    }

    static LogEntry toLogEntry(SVNLogEntry sle) {
        LogEntry le = new LogEntry();
        le.setRevision((int)sle.getRevision());
        le.setAuthor(sle.getAuthor());
        le.setDate(sle.getDate());
        le.setMessage(sle.getMessage());
        ArrayList<Path> paths = new ArrayList<Path>();
        for (SVNLogEntryPath slep : sle.getChangedPaths().values()) {
            Path path = new Path();
            path.setAction(slep.getType());
            path.setPath(slep.getPath());
            path.setCopyFromPath(slep.getCopyPath());
            path.setCopyFromRev((int)slep.getCopyRevision());
            paths.add(path);
        }
        le.setRevisionPaths(paths);
        return le;
    }

    private static void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    static {
        SvnSession.setupLibrary();
    }
}

