/*
 * Copyright 2011 by Thomas Mauch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id$
 */
package org.magicwerk.brownies.svn.wc;

import java.util.List;

import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.svn.SVNLogCommand;
import org.tmatesoft.svn.core.SVNLogEntry;

/**
 * Implementation of the SVN command "log".
 *
 * @author Thomas Mauch
 * @version $Id$
 */
public class SvnLogCommand extends SvnCommand {
	private String path;
	private String revisionExpr;
	private IList<SVNLogEntry> logEntries;

	public SvnLogCommand setPath(String path) {
		this.path = path;
		return this;
	}

	public SvnLogCommand setRevision(String revisionExpr) {
		this.revisionExpr = revisionExpr;
		return this;
	}

	/**
	 * Get log entries.
	 *
	 * @return list of log entries
	 */
	public IList<SVNLogEntry> getLogEntries() {
		logEntries = GapList.create();
		run();
		return logEntries;
	}

	@Override
	protected List<String> buildArgs() {
		IList<String> args = GapList.create();
		// Use --verbose to get affected paths
		args.addArray("log", path, "--verbose");
		if (revisionExpr != null) {
			args.addArray("-r", String.valueOf(revisionExpr));
		}
		return args;
	}

	@Override
	protected AbstractSVNCommand getCommand() {
		return new SVNLogCommand() {
			//			@Override
			//			public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
			//				logEntries.add(logEntry);
			//			}
		};
	}
}
