package org.magicwerk.brownies.svn.log;

import org.magicwerk.brownies.core.PrintTools;


/**
 * Information about a path affected by a commit.
 * It contains exactly the information stored in a {@literal <path>} item
 * of the svn log output.
 *
 * @author Thomas Mauch
 * @version $Id$
 */
public class Path {
	private char action;
	private String path;
	private String copyFromPath;
	private int copyFromRev;
	
	/**
	 * @return the action
	 */
	public char getAction() {
		return action;
	}
	/**
	 * @param action the action to set
	 */
	public void setAction(char action) {
		this.action = action;
	}
	/**
	 * @return the path
	 */
	public String getPath() {
		return path;
	}
	/**
	 * @param path the path to set
	 */
	public void setPath(String path) {
		this.path = path;
	}
	/**
	 * @return the copyFromPath
	 */
	public String getCopyFromPath() {
		return copyFromPath;
	}
	/**
	 * @param copyFromPath the copyFromPath to set
	 */
	public void setCopyFromPath(String copyFromPath) {
		this.copyFromPath = copyFromPath;
	}
	/**
	 * @return the copyFromRev
	 */
	public int getCopyFromRev() {
		return copyFromRev;
	}
	/**
	 * @param copyFromRev the copyFromRev to set
	 */
	public void setCopyFromRev(int copyFromRev) {
		this.copyFromRev = copyFromRev;
	}
	
	@Override
	public String toString() {
		return PrintTools.printToString(this);
	}
}
