/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge.data;

import org.madlonkay.supertmxmerge.data.ITmx;
import org.madlonkay.supertmxmerge.data.ITuv;
import org.madlonkay.supertmxmerge.data.Key;
import org.madlonkay.supertmxmerge.data.MergeAnalysis;
import org.madlonkay.supertmxmerge.data.ResolutionSet;

public abstract class ResolutionStrategy {
    public static final ResolutionStrategy BASE = new ResolutionStrategy(){

        @Override
        public ITuv resolveConflict(Key key, ITuv baseTuv, ITuv leftTuv, ITuv rightTuv) {
            return baseTuv;
        }
    };
    public static final ResolutionStrategy LEFT = new ResolutionStrategy(){

        @Override
        public ITuv resolveConflict(Key key, ITuv baseTuv, ITuv leftTuv, ITuv rightTuv) {
            return leftTuv;
        }
    };
    public static final ResolutionStrategy RIGHT = new ResolutionStrategy(){

        @Override
        public ITuv resolveConflict(Key key, ITuv baseTuv, ITuv leftTuv, ITuv rightTuv) {
            return rightTuv;
        }
    };

    public ResolutionSet resolve(MergeAnalysis<Key, ITuv> analysis, ITmx baseTmx, ITmx leftTmx, ITmx rightTmx) {
        ResolutionSet resolution = ResolutionSet.fromAnalysis(analysis, leftTmx, rightTmx);
        for (Key key : analysis.conflicts) {
            ITuv rightTuv;
            ITuv leftTuv;
            ITuv baseTuv;
            ITuv selection = this.resolveConflict(key, baseTuv = (ITuv)baseTmx.get(key), leftTuv = (ITuv)leftTmx.get(key), rightTuv = (ITuv)rightTmx.get(key));
            if (selection == baseTuv) continue;
            if (selection == leftTuv) {
                this.dispatchKey(resolution, key, baseTmx, leftTmx);
                continue;
            }
            if (selection == rightTuv) {
                this.dispatchKey(resolution, key, baseTmx, rightTmx);
                continue;
            }
            throw new RuntimeException("ResolutionStrategy resolved conflict with unknown ITuv.");
        }
        return resolution;
    }

    public abstract ITuv resolveConflict(Key var1, ITuv var2, ITuv var3, ITuv var4);

    private void dispatchKey(ResolutionSet resolution, Key key, ITmx baseTmx, ITmx thisTmx) {
        if (!thisTmx.containsKey(key)) {
            resolution.toDelete.add(key);
        } else if (baseTmx.containsKey(key)) {
            resolution.toReplace.put(key, (ITuv)thisTmx.get(key));
        } else {
            resolution.toAdd.put(key, thisTmx.getTu(key));
        }
    }
}

