/*
 * Copyright (C) 2013 Aaron Madlon-Kay <aaron@madlon-kay.com>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301  USA
 */
package org.madlonkay.supertmxmerge.data;

import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author Aaron Madlon-Kay <aaron@madlon-kay.com>
 */
public class Key {
    
    public final String sourceText;
    public Map<String, String> props;
    public final Object foreignKey;
    
    public Key(String sourceText, Object foreignKey) {
        this.sourceText = sourceText;
        this.foreignKey = foreignKey;
    }
    
    public void addProp(String name, String value) {
        if (props == null) {
            props = new HashMap<String, String>();
        }
        props.put(name, value);
    }

    @Override
    public int hashCode() {
        if (foreignKey != null) {
            return foreignKey.hashCode();
        }
        final int prime = 31;
        int result = 1;
        result = prime * result + ((props == null) ? 0 : props.hashCode());
        result = prime * result
                + ((sourceText == null) ? 0 : sourceText.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Key other = (Key) obj;
        if (foreignKey != null && other.foreignKey != null) {
            return foreignKey.equals(other.foreignKey);
        }
        if (props == null) {
            if (other.props != null)
                return false;
        } else if (!props.equals(other.props))
            return false;
        if (sourceText == null) {
            if (other.sourceText != null)
                return false;
        } else if (!sourceText.equals(other.sourceText))
            return false;
        return true;
    }
}
