/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.desktopsupport.impl;

import com.apple.eawt.AppEvent;
import com.apple.eawt.AppEventListener;
import com.apple.eawt.AppReOpenedListener;
import com.apple.eawt.Application;
import com.apple.eawt.FullScreenUtilities;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.Window;
import java.io.File;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JMenuBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.madlonkay.desktopsupport.AboutHandler;
import org.madlonkay.desktopsupport.AppForegroundListener;
import org.madlonkay.desktopsupport.AppHiddenListener;
import org.madlonkay.desktopsupport.AppReopenedListener;
import org.madlonkay.desktopsupport.FullScreenListener;
import org.madlonkay.desktopsupport.IDesktopSupport;
import org.madlonkay.desktopsupport.OpenFilesEvent;
import org.madlonkay.desktopsupport.OpenFilesHandler;
import org.madlonkay.desktopsupport.OpenURIHandler;
import org.madlonkay.desktopsupport.PreferencesHandler;
import org.madlonkay.desktopsupport.PrintFilesHandler;
import org.madlonkay.desktopsupport.QuitHandler;
import org.madlonkay.desktopsupport.QuitResponse;
import org.madlonkay.desktopsupport.QuitStrategy;
import org.madlonkay.desktopsupport.ScreenSleepListener;
import org.madlonkay.desktopsupport.SystemEventListener;
import org.madlonkay.desktopsupport.SystemSleepListener;
import org.madlonkay.desktopsupport.UserSessionEvent;
import org.madlonkay.desktopsupport.UserSessionListener;

public class AppleDesktopSupportImpl
implements IDesktopSupport {
    private final Map<SystemEventListener, AppEventListener> listeners = Collections.synchronizedMap(new IdentityHashMap());
    private final Map<FullScreenListener, com.apple.eawt.FullScreenListener> fsListeners = Collections.synchronizedMap(new IdentityHashMap());

    public AppleDesktopSupportImpl() {
        Application.getApplication().getDockIconImage();
    }

    @Override
    public void addAppEventListener(SystemEventListener listener) {
        Application.getApplication().addAppEventListener(this.wrap(listener));
    }

    private AppEventListener wrap(final SystemEventListener listener) {
        if (listener instanceof AppForegroundListener) {
            return this.listeners.computeIfAbsent(listener, k -> new com.apple.eawt.AppForegroundListener(){

                @Override
                public void appRaisedToForeground(AppEvent.AppForegroundEvent e) {
                    ((AppForegroundListener)listener).appRaisedToForeground(e);
                }

                @Override
                public void appMovedToBackground(AppEvent.AppForegroundEvent e) {
                    ((AppForegroundListener)listener).appMovedToBackground(e);
                }
            });
        }
        if (listener instanceof AppHiddenListener) {
            return this.listeners.computeIfAbsent(listener, k -> new com.apple.eawt.AppHiddenListener(){

                @Override
                public void appHidden(AppEvent.AppHiddenEvent e) {
                    ((AppHiddenListener)listener).appHidden(e);
                }

                @Override
                public void appUnhidden(AppEvent.AppHiddenEvent e) {
                    ((AppHiddenListener)listener).appUnhidden(e);
                }
            });
        }
        if (listener instanceof AppReopenedListener) {
            return this.listeners.computeIfAbsent(listener, k -> new AppReOpenedListener(){

                @Override
                public void appReOpened(AppEvent.AppReOpenedEvent e) {
                    ((AppReopenedListener)((Object)listener)).appReopened(e);
                }
            });
        }
        if (listener instanceof ScreenSleepListener) {
            return this.listeners.computeIfAbsent(listener, k -> new com.apple.eawt.ScreenSleepListener(){

                @Override
                public void screenAboutToSleep(AppEvent.ScreenSleepEvent e) {
                    ((ScreenSleepListener)listener).screenAboutToSleep(e);
                }

                @Override
                public void screenAwoke(AppEvent.ScreenSleepEvent e) {
                    ((ScreenSleepListener)listener).screenAwoke(e);
                }
            });
        }
        if (listener instanceof SystemSleepListener) {
            return this.listeners.computeIfAbsent(listener, k -> new com.apple.eawt.SystemSleepListener(){

                @Override
                public void systemAboutToSleep(AppEvent.SystemSleepEvent e) {
                    ((SystemSleepListener)listener).systemAboutToSleep(e);
                }

                @Override
                public void systemAwoke(AppEvent.SystemSleepEvent e) {
                    ((SystemSleepListener)listener).systemAwoke(e);
                }
            });
        }
        if (listener instanceof UserSessionListener) {
            return this.listeners.computeIfAbsent(listener, k -> new com.apple.eawt.UserSessionListener(){

                @Override
                public void userSessionDeactivated(AppEvent.UserSessionEvent e) {
                    ((UserSessionListener)listener).userSessionDeactivated(() -> UserSessionEvent.Reason.UNSPECIFIED);
                }

                @Override
                public void userSessionActivated(AppEvent.UserSessionEvent e) {
                    ((UserSessionListener)listener).userSessionActivated(() -> UserSessionEvent.Reason.UNSPECIFIED);
                }
            });
        }
        throw new RuntimeException("Unknown listener type: " + listener.getClass());
    }

    private com.apple.eawt.FullScreenListener wrap(final FullScreenListener listener) {
        return this.fsListeners.computeIfAbsent(listener, k -> new com.apple.eawt.FullScreenListener(){

            @Override
            public void windowEnteringFullScreen(AppEvent.FullScreenEvent evt) {
                listener.windowEnteringFullScreen(evt::getWindow);
            }

            @Override
            public void windowEnteredFullScreen(AppEvent.FullScreenEvent evt) {
                listener.windowEnteredFullScreen(evt::getWindow);
            }

            @Override
            public void windowExitingFullScreen(AppEvent.FullScreenEvent evt) {
                listener.windowExitingFullScreen(evt::getWindow);
            }

            @Override
            public void windowExitedFullScreen(AppEvent.FullScreenEvent evt) {
                listener.windowExitedFullScreen(evt::getWindow);
            }
        });
    }

    @Override
    public void removeAppEventListener(SystemEventListener listener) {
        AppEventListener wrapped = this.listeners.remove(listener);
        if (wrapped != null) {
            Application.getApplication().removeAppEventListener(wrapped);
        }
    }

    @Override
    public void setAboutHandler(AboutHandler handler) {
        Application.getApplication().setAboutHandler((AppEvent.AboutEvent evt) -> handler.handleAbout(evt));
    }

    @Override
    public void setPreferencesHandler(PreferencesHandler handler) {
        Application.getApplication().setPreferencesHandler((AppEvent.PreferencesEvent evt) -> handler.handlePreferences(evt));
    }

    @Override
    public void setOpenFilesHandler(OpenFilesHandler handler) {
        Application.getApplication().setOpenFileHandler(evt -> handler.openFiles(new OpenFilesEvent(){

            @Override
            public List<File> getFiles() {
                return evt.getFiles();
            }

            @Override
            public String getSearchTerm() {
                return evt.getSearchTerm();
            }
        }));
    }

    @Override
    public void setPrintFilesHandler(PrintFilesHandler handler) {
        Application.getApplication().setPrintFileHandler(evt -> handler.printFiles(evt::getFiles));
    }

    @Override
    public void setOpenURIHandler(OpenURIHandler handler) {
        Application.getApplication().setOpenURIHandler((AppEvent.OpenURIEvent evt) -> handler.openURI(evt::getURI));
    }

    @Override
    public void setQuitHandler(QuitHandler handler) {
        Application.getApplication().setQuitHandler((AppEvent.QuitEvent evt, com.apple.eawt.QuitResponse response) -> handler.handleQuitRequestWith(evt, new QuitResponse(){

            @Override
            public void performQuit() {
                response.performQuit();
            }

            @Override
            public void cancelQuit() {
                response.cancelQuit();
            }
        }));
    }

    @Override
    public void setQuitStrategy(QuitStrategy strategy) {
        Application.getApplication().setQuitStrategy(AppleDesktopSupportImpl.convert(strategy));
    }

    private static com.apple.eawt.QuitStrategy convert(QuitStrategy strategy) {
        switch (strategy) {
            case CLOSE_ALL_WINDOWS: {
                return com.apple.eawt.QuitStrategy.CLOSE_ALL_WINDOWS;
            }
            case NORMAL_EXIT: {
                return com.apple.eawt.QuitStrategy.SYSTEM_EXIT_0;
            }
        }
        throw new RuntimeException("Unknown strategy: " + (Object)((Object)strategy));
    }

    @Override
    public void enableSuddenTermination() {
        Application.getApplication().enableSuddenTermination();
    }

    @Override
    public void disableSuddenTermination() {
        Application.getApplication().disableSuddenTermination();
    }

    @Override
    public void requestForeground(boolean allWindows) {
        Application.getApplication().requestForeground(allWindows);
    }

    @Override
    public void openHelpViewer() {
        Application.getApplication().openHelpViewer();
    }

    @Override
    public void setDefaultMenuBar(JMenuBar menuBar) {
        Application.getApplication().setDefaultMenuBar(menuBar);
    }

    @Override
    public Image getDockIconImage() {
        return Application.getApplication().getDockIconImage();
    }

    @Override
    public void setDockIconImage(Image image) {
        Application.getApplication().setDockIconImage(image);
    }

    @Override
    public void setDockIconBadge(String badge) {
        Application.getApplication().setDockIconBadge(badge);
    }

    @Override
    public PopupMenu getDockMenu() {
        return Application.getApplication().getDockMenu();
    }

    @Override
    public void setDockMenu(PopupMenu menu) {
        Application.getApplication().setDockMenu(menu);
    }

    @Override
    public void requestUserAttention(boolean critical) {
        Application.getApplication().requestUserAttention(critical);
    }

    @Override
    public void requestToggleFullScreen(Window window) {
        Application.getApplication().requestToggleFullScreen(window);
    }

    @Override
    public void setWindowCanFullScreen(Window window, boolean enabled) {
        FullScreenUtilities.setWindowCanFullScreen(window, enabled);
    }

    @Override
    public void addFullScreenListenerTo(Window window, FullScreenListener listener) {
        FullScreenUtilities.addFullScreenListenerTo(window, this.wrap(listener));
    }

    @Override
    public void removeFullScreenListenerFrom(Window window, FullScreenListener listener) {
        com.apple.eawt.FullScreenListener wrapped = this.fsListeners.remove(listener);
        if (wrapped != null) {
            FullScreenUtilities.removeFullScreenListenerFrom(window, wrapped);
        }
    }

    @Override
    public LookAndFeel createLookAndFeel(String name) throws UnsupportedLookAndFeelException {
        Objects.requireNonNull(name);
        if ("GTK look and feel".equals(name)) {
            name = "GTK+";
        }
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!info.getName().equals(name)) continue;
                LookAndFeel laf = (LookAndFeel)Class.forName(info.getClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (laf.isSupportedLookAndFeel()) {
                    return laf;
                }
                break;
            }
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            // empty catch block
        }
        throw new UnsupportedLookAndFeelException(name);
    }
}

