/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl.awt;

import java.awt.AWTException;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.concurrent.Callable;
import org.lwjgl.awthacks.NonClearGraphics;
import org.lwjgl.awthacks.NonClearGraphics2D;
import org.lwjgl.opengl.awt.GLData;
import org.lwjgl.opengl.awt.PlatformGLCanvas;
import org.lwjgl.opengl.awt.PlatformLinuxGLCanvas;
import org.lwjgl.opengl.awt.PlatformWin32GLCanvas;
import org.lwjgl.system.Platform;

public abstract class AWTGLCanvas
extends Canvas {
    private static final long serialVersionUID = 1L;
    protected PlatformGLCanvas platformCanvas = AWTGLCanvas.createPlatformCanvas();
    protected long context;
    protected final GLData data;
    protected final GLData effective = new GLData();
    protected boolean initCalled;

    private static PlatformGLCanvas createPlatformCanvas() {
        switch (Platform.get()) {
            case WINDOWS: {
                return new PlatformWin32GLCanvas();
            }
            case LINUX: {
                return new PlatformLinuxGLCanvas();
            }
        }
        throw new UnsupportedOperationException("Platform " + Platform.get() + " not yet supported");
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.platformCanvas.dispose();
    }

    protected AWTGLCanvas(GLData data) {
        this.data = data;
    }

    protected AWTGLCanvas() {
        this(new GLData());
    }

    protected void beforeRender() {
        if (this.context == 0L) {
            try {
                this.context = this.platformCanvas.create(this, this.data, this.effective);
            }
            catch (AWTException e) {
                throw new RuntimeException("Exception while creating the OpenGL context", e);
            }
        }
        try {
            this.platformCanvas.lock();
        }
        catch (AWTException e) {
            throw new RuntimeException("Failed to lock Canvas", e);
        }
        this.platformCanvas.makeCurrent(this.context);
    }

    protected void afterRender() {
        this.platformCanvas.makeCurrent(0L);
        try {
            this.platformCanvas.unlock();
        }
        catch (AWTException e) {
            throw new RuntimeException("Failed to unlock Canvas", e);
        }
    }

    public <T> T executeInContext(Callable<T> callable) throws Exception {
        this.beforeRender();
        try {
            T t = callable.call();
            return t;
        }
        finally {
            this.afterRender();
        }
    }

    public void runInContext(Runnable runnable) {
        this.beforeRender();
        try {
            runnable.run();
        }
        finally {
            this.afterRender();
        }
    }

    public void render() {
        this.beforeRender();
        try {
            if (!this.initCalled) {
                this.initGL();
                this.initCalled = true;
            }
            this.paintGL();
        }
        finally {
            this.afterRender();
        }
    }

    public abstract void initGL();

    public abstract void paintGL();

    public final void swapBuffers() {
        this.platformCanvas.swapBuffers();
    }

    @Override
    public Graphics getGraphics() {
        Graphics graphics = super.getGraphics();
        return graphics instanceof Graphics2D ? new NonClearGraphics2D((Graphics2D)graphics) : new NonClearGraphics(graphics);
    }
}

