/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.awt;

import java.awt.AWTException;
import java.awt.Canvas;
import java.awt.Graphics;
import org.lwjgl.system.Platform;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.awt.PlatformVKCanvas;
import org.lwjgl.vulkan.awt.VKData;

public abstract class AWTVKCanvas
extends Canvas {
    private static final long serialVersionUID = 1L;
    private static PlatformVKCanvas platformCanvas;
    private final VKData data;
    public long surface;

    protected AWTVKCanvas(VKData data) {
        this.data = data;
    }

    @Override
    public void paint(Graphics g) {
        boolean created = false;
        if (this.surface == 0L) {
            try {
                this.surface = platformCanvas.create(this, this.data);
                created = true;
            }
            catch (AWTException e) {
                throw new RuntimeException("Exception while creating the Vulkan surface", e);
            }
        }
        if (created) {
            this.initVK();
        }
        this.paintVK();
    }

    public boolean getPhysicalDevicePresentationSupport(VkPhysicalDevice physicalDevice, int queueFamily) {
        return platformCanvas.getPhysicalDevicePresentationSupport(physicalDevice, queueFamily);
    }

    public abstract void initVK();

    public abstract void paintVK();

    static {
        String platformClassName;
        switch (Platform.get()) {
            case WINDOWS: {
                platformClassName = "org.lwjgl.vulkan.awt.PlatformWin32VKCanvas";
                break;
            }
            case LINUX: {
                platformClassName = "org.lwjgl.vulkan.awt.PlatformX11VKCanvas";
                break;
            }
            default: {
                throw new AssertionError((Object)"NYI");
            }
        }
        try {
            Class<?> clazz = AWTVKCanvas.class.getClassLoader().loadClass(platformClassName);
            platformCanvas = (PlatformVKCanvas)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)("Platform-specific VKCanvas class not found: " + platformClassName));
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)("Could not instantiate platform-specific VKCanvas class: " + platformClassName));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("Could not instantiate platform-specific VKCanvas class: " + platformClassName));
        }
    }
}

