/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrErrorInfo")
public class OVRErrorInfo
extends Struct<OVRErrorInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESULT;
    public static final int ERRORSTRING;

    protected OVRErrorInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OVRErrorInfo create(long address, @Nullable ByteBuffer container) {
        return new OVRErrorInfo(address, container);
    }

    public OVRErrorInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRErrorInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrResult")
    public int Result() {
        return OVRErrorInfo.nResult(this.address());
    }

    @NativeType(value="char[512]")
    public ByteBuffer ErrorString() {
        return OVRErrorInfo.nErrorString(this.address());
    }

    @NativeType(value="char[512]")
    public String ErrorStringString() {
        return OVRErrorInfo.nErrorStringString(this.address());
    }

    public static OVRErrorInfo malloc() {
        return new OVRErrorInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static OVRErrorInfo calloc() {
        return new OVRErrorInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static OVRErrorInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new OVRErrorInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static OVRErrorInfo create(long address) {
        return new OVRErrorInfo(address, null);
    }

    @Nullable
    public static OVRErrorInfo createSafe(long address) {
        return address == 0L ? null : new OVRErrorInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)OVRErrorInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRErrorInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRErrorInfo mallocStack() {
        return OVRErrorInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRErrorInfo callocStack() {
        return OVRErrorInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRErrorInfo mallocStack(MemoryStack stack) {
        return OVRErrorInfo.malloc(stack);
    }

    @Deprecated
    public static OVRErrorInfo callocStack(MemoryStack stack) {
        return OVRErrorInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRErrorInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRErrorInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRErrorInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRErrorInfo.calloc(capacity, stack);
    }

    public static OVRErrorInfo malloc(MemoryStack stack) {
        return new OVRErrorInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRErrorInfo calloc(MemoryStack stack) {
        return new OVRErrorInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nResult(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESULT);
    }

    public static ByteBuffer nErrorString(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)ERRORSTRING), (int)512);
    }

    public static String nErrorStringString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)ERRORSTRING));
    }

    static {
        Struct.Layout layout = OVRErrorInfo.__struct((Struct.Member[])new Struct.Member[]{OVRErrorInfo.__member((int)4), OVRErrorInfo.__array((int)1, (int)512)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESULT = layout.offsetof(0);
        ERRORSTRING = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRErrorInfo, Buffer>
    implements NativeResource {
        private static final OVRErrorInfo ELEMENT_FACTORY = OVRErrorInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRErrorInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrResult")
        public int Result() {
            return OVRErrorInfo.nResult(this.address());
        }

        @NativeType(value="char[512]")
        public ByteBuffer ErrorString() {
            return OVRErrorInfo.nErrorString(this.address());
        }

        @NativeType(value="char[512]")
        public String ErrorStringString() {
            return OVRErrorInfo.nErrorStringString(this.address());
        }
    }
}

