/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrCameraExtrinsics")
public class OVRCameraExtrinsics
extends Struct<OVRCameraExtrinsics>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LASTCHANGEDTIMESECONDS;
    public static final int CAMERASTATUSFLAGS;
    public static final int ATTACHEDTODEVICE;
    public static final int RELATIVEPOSE;
    public static final int LASTEXPOSURETIMESECONDS;
    public static final int EXPOSURELATENCYSECONDS;
    public static final int ADDITIONALLATENCYSECONDS;

    protected OVRCameraExtrinsics(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OVRCameraExtrinsics create(long address, @Nullable ByteBuffer container) {
        return new OVRCameraExtrinsics(address, container);
    }

    public OVRCameraExtrinsics(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRCameraExtrinsics.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public double LastChangedTimeSeconds() {
        return OVRCameraExtrinsics.nLastChangedTimeSeconds(this.address());
    }

    @NativeType(value="unsigned int")
    public int CameraStatusFlags() {
        return OVRCameraExtrinsics.nCameraStatusFlags(this.address());
    }

    @NativeType(value="ovrTrackedDeviceType")
    public int AttachedToDevice() {
        return OVRCameraExtrinsics.nAttachedToDevice(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef RelativePose() {
        return OVRCameraExtrinsics.nRelativePose(this.address());
    }

    public double LastExposureTimeSeconds() {
        return OVRCameraExtrinsics.nLastExposureTimeSeconds(this.address());
    }

    public double ExposureLatencySeconds() {
        return OVRCameraExtrinsics.nExposureLatencySeconds(this.address());
    }

    public double AdditionalLatencySeconds() {
        return OVRCameraExtrinsics.nAdditionalLatencySeconds(this.address());
    }

    public OVRCameraExtrinsics LastChangedTimeSeconds(double value) {
        OVRCameraExtrinsics.nLastChangedTimeSeconds(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics CameraStatusFlags(@NativeType(value="unsigned int") int value) {
        OVRCameraExtrinsics.nCameraStatusFlags(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics AttachedToDevice(@NativeType(value="ovrTrackedDeviceType") int value) {
        OVRCameraExtrinsics.nAttachedToDevice(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics RelativePose(@NativeType(value="ovrPosef") OVRPosef value) {
        OVRCameraExtrinsics.nRelativePose(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics RelativePose(Consumer<OVRPosef> consumer) {
        consumer.accept(this.RelativePose());
        return this;
    }

    public OVRCameraExtrinsics LastExposureTimeSeconds(double value) {
        OVRCameraExtrinsics.nLastExposureTimeSeconds(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics ExposureLatencySeconds(double value) {
        OVRCameraExtrinsics.nExposureLatencySeconds(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics AdditionalLatencySeconds(double value) {
        OVRCameraExtrinsics.nAdditionalLatencySeconds(this.address(), value);
        return this;
    }

    public OVRCameraExtrinsics set(double LastChangedTimeSeconds, int CameraStatusFlags, int AttachedToDevice, OVRPosef RelativePose, double LastExposureTimeSeconds, double ExposureLatencySeconds, double AdditionalLatencySeconds) {
        this.LastChangedTimeSeconds(LastChangedTimeSeconds);
        this.CameraStatusFlags(CameraStatusFlags);
        this.AttachedToDevice(AttachedToDevice);
        this.RelativePose(RelativePose);
        this.LastExposureTimeSeconds(LastExposureTimeSeconds);
        this.ExposureLatencySeconds(ExposureLatencySeconds);
        this.AdditionalLatencySeconds(AdditionalLatencySeconds);
        return this;
    }

    public OVRCameraExtrinsics set(OVRCameraExtrinsics src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRCameraExtrinsics malloc() {
        return new OVRCameraExtrinsics(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static OVRCameraExtrinsics calloc() {
        return new OVRCameraExtrinsics(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static OVRCameraExtrinsics create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new OVRCameraExtrinsics(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static OVRCameraExtrinsics create(long address) {
        return new OVRCameraExtrinsics(address, null);
    }

    @Nullable
    public static OVRCameraExtrinsics createSafe(long address) {
        return address == 0L ? null : new OVRCameraExtrinsics(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)OVRCameraExtrinsics.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRCameraExtrinsics.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRCameraExtrinsics mallocStack() {
        return OVRCameraExtrinsics.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRCameraExtrinsics callocStack() {
        return OVRCameraExtrinsics.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRCameraExtrinsics mallocStack(MemoryStack stack) {
        return OVRCameraExtrinsics.malloc(stack);
    }

    @Deprecated
    public static OVRCameraExtrinsics callocStack(MemoryStack stack) {
        return OVRCameraExtrinsics.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRCameraExtrinsics.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRCameraExtrinsics.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRCameraExtrinsics.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRCameraExtrinsics.calloc(capacity, stack);
    }

    public static OVRCameraExtrinsics malloc(MemoryStack stack) {
        return new OVRCameraExtrinsics(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRCameraExtrinsics calloc(MemoryStack stack) {
        return new OVRCameraExtrinsics(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nLastChangedTimeSeconds(long struct) {
        return UNSAFE.getDouble(null, struct + (long)LASTCHANGEDTIMESECONDS);
    }

    public static int nCameraStatusFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)CAMERASTATUSFLAGS);
    }

    public static int nAttachedToDevice(long struct) {
        return UNSAFE.getInt(null, struct + (long)ATTACHEDTODEVICE);
    }

    public static OVRPosef nRelativePose(long struct) {
        return OVRPosef.create(struct + (long)RELATIVEPOSE);
    }

    public static double nLastExposureTimeSeconds(long struct) {
        return UNSAFE.getDouble(null, struct + (long)LASTEXPOSURETIMESECONDS);
    }

    public static double nExposureLatencySeconds(long struct) {
        return UNSAFE.getDouble(null, struct + (long)EXPOSURELATENCYSECONDS);
    }

    public static double nAdditionalLatencySeconds(long struct) {
        return UNSAFE.getDouble(null, struct + (long)ADDITIONALLATENCYSECONDS);
    }

    public static void nLastChangedTimeSeconds(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)LASTCHANGEDTIMESECONDS, value);
    }

    public static void nCameraStatusFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CAMERASTATUSFLAGS, value);
    }

    public static void nAttachedToDevice(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ATTACHEDTODEVICE, value);
    }

    public static void nRelativePose(long struct, OVRPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RELATIVEPOSE), (long)OVRPosef.SIZEOF);
    }

    public static void nLastExposureTimeSeconds(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)LASTEXPOSURETIMESECONDS, value);
    }

    public static void nExposureLatencySeconds(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)EXPOSURELATENCYSECONDS, value);
    }

    public static void nAdditionalLatencySeconds(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)ADDITIONALLATENCYSECONDS, value);
    }

    static {
        Struct.Layout layout = OVRCameraExtrinsics.__struct((Struct.Member[])new Struct.Member[]{OVRCameraExtrinsics.__member((int)8), OVRCameraExtrinsics.__member((int)4), OVRCameraExtrinsics.__member((int)4), OVRCameraExtrinsics.__member((int)OVRPosef.SIZEOF, (int)OVRPosef.ALIGNOF), OVRCameraExtrinsics.__member((int)8), OVRCameraExtrinsics.__member((int)8), OVRCameraExtrinsics.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LASTCHANGEDTIMESECONDS = layout.offsetof(0);
        CAMERASTATUSFLAGS = layout.offsetof(1);
        ATTACHEDTODEVICE = layout.offsetof(2);
        RELATIVEPOSE = layout.offsetof(3);
        LASTEXPOSURETIMESECONDS = layout.offsetof(4);
        EXPOSURELATENCYSECONDS = layout.offsetof(5);
        ADDITIONALLATENCYSECONDS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<OVRCameraExtrinsics, Buffer>
    implements NativeResource {
        private static final OVRCameraExtrinsics ELEMENT_FACTORY = OVRCameraExtrinsics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRCameraExtrinsics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double LastChangedTimeSeconds() {
            return OVRCameraExtrinsics.nLastChangedTimeSeconds(this.address());
        }

        @NativeType(value="unsigned int")
        public int CameraStatusFlags() {
            return OVRCameraExtrinsics.nCameraStatusFlags(this.address());
        }

        @NativeType(value="ovrTrackedDeviceType")
        public int AttachedToDevice() {
            return OVRCameraExtrinsics.nAttachedToDevice(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef RelativePose() {
            return OVRCameraExtrinsics.nRelativePose(this.address());
        }

        public double LastExposureTimeSeconds() {
            return OVRCameraExtrinsics.nLastExposureTimeSeconds(this.address());
        }

        public double ExposureLatencySeconds() {
            return OVRCameraExtrinsics.nExposureLatencySeconds(this.address());
        }

        public double AdditionalLatencySeconds() {
            return OVRCameraExtrinsics.nAdditionalLatencySeconds(this.address());
        }

        public Buffer LastChangedTimeSeconds(double value) {
            OVRCameraExtrinsics.nLastChangedTimeSeconds(this.address(), value);
            return this;
        }

        public Buffer CameraStatusFlags(@NativeType(value="unsigned int") int value) {
            OVRCameraExtrinsics.nCameraStatusFlags(this.address(), value);
            return this;
        }

        public Buffer AttachedToDevice(@NativeType(value="ovrTrackedDeviceType") int value) {
            OVRCameraExtrinsics.nAttachedToDevice(this.address(), value);
            return this;
        }

        public Buffer RelativePose(@NativeType(value="ovrPosef") OVRPosef value) {
            OVRCameraExtrinsics.nRelativePose(this.address(), value);
            return this;
        }

        public Buffer RelativePose(Consumer<OVRPosef> consumer) {
            consumer.accept(this.RelativePose());
            return this;
        }

        public Buffer LastExposureTimeSeconds(double value) {
            OVRCameraExtrinsics.nLastExposureTimeSeconds(this.address(), value);
            return this;
        }

        public Buffer ExposureLatencySeconds(double value) {
            OVRCameraExtrinsics.nExposureLatencySeconds(this.address(), value);
            return this;
        }

        public Buffer AdditionalLatencySeconds(double value) {
            OVRCameraExtrinsics.nAdditionalLatencySeconds(this.address(), value);
            return this;
        }
    }
}

