/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrViewScaleDesc")
public class OVRViewScaleDesc
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HMDTOEYEPOSE;
    public static final int HMDSPACETOWORLDSCALEINMETERS;

    public OVRViewScaleDesc(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRViewScaleDesc.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrPosef[ovrEye_Count]")
    public OVRPosef.Buffer HmdToEyePose() {
        return OVRViewScaleDesc.nHmdToEyePose(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef HmdToEyePose(int index) {
        return OVRViewScaleDesc.nHmdToEyePose(this.address(), index);
    }

    public float HmdSpaceToWorldScaleInMeters() {
        return OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address());
    }

    public OVRViewScaleDesc HmdToEyePose(@NativeType(value="ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) {
        OVRViewScaleDesc.nHmdToEyePose(this.address(), value);
        return this;
    }

    public OVRViewScaleDesc HmdToEyePose(int index, @NativeType(value="ovrPosef") OVRPosef value) {
        OVRViewScaleDesc.nHmdToEyePose(this.address(), index, value);
        return this;
    }

    public OVRViewScaleDesc HmdToEyePose(Consumer<OVRPosef.Buffer> consumer) {
        consumer.accept(this.HmdToEyePose());
        return this;
    }

    public OVRViewScaleDesc HmdToEyePose(int index, Consumer<OVRPosef> consumer) {
        consumer.accept(this.HmdToEyePose(index));
        return this;
    }

    public OVRViewScaleDesc HmdSpaceToWorldScaleInMeters(float value) {
        OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address(), value);
        return this;
    }

    public OVRViewScaleDesc set(OVRPosef.Buffer HmdToEyePose, float HmdSpaceToWorldScaleInMeters) {
        this.HmdToEyePose(HmdToEyePose);
        this.HmdSpaceToWorldScaleInMeters(HmdSpaceToWorldScaleInMeters);
        return this;
    }

    public OVRViewScaleDesc set(OVRViewScaleDesc src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRViewScaleDesc malloc() {
        return (OVRViewScaleDesc)OVRViewScaleDesc.wrap(OVRViewScaleDesc.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRViewScaleDesc calloc() {
        return (OVRViewScaleDesc)OVRViewScaleDesc.wrap(OVRViewScaleDesc.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRViewScaleDesc create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRViewScaleDesc)OVRViewScaleDesc.wrap(OVRViewScaleDesc.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRViewScaleDesc create(long address) {
        return (OVRViewScaleDesc)OVRViewScaleDesc.wrap(OVRViewScaleDesc.class, (long)address);
    }

    @Nullable
    public static OVRViewScaleDesc createSafe(long address) {
        return address == 0L ? null : (OVRViewScaleDesc)OVRViewScaleDesc.wrap(OVRViewScaleDesc.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRViewScaleDesc.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRViewScaleDesc.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRViewScaleDesc.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRViewScaleDesc.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRViewScaleDesc.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRViewScaleDesc.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRViewScaleDesc.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static OVRViewScaleDesc mallocStack() {
        return OVRViewScaleDesc.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRViewScaleDesc callocStack() {
        return OVRViewScaleDesc.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRViewScaleDesc mallocStack(MemoryStack stack) {
        return OVRViewScaleDesc.malloc(stack);
    }

    @Deprecated
    public static OVRViewScaleDesc callocStack(MemoryStack stack) {
        return OVRViewScaleDesc.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRViewScaleDesc.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRViewScaleDesc.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRViewScaleDesc.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRViewScaleDesc.calloc(capacity, stack);
    }

    public static OVRViewScaleDesc malloc(MemoryStack stack) {
        return (OVRViewScaleDesc)OVRViewScaleDesc.wrap(OVRViewScaleDesc.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRViewScaleDesc calloc(MemoryStack stack) {
        return (OVRViewScaleDesc)OVRViewScaleDesc.wrap(OVRViewScaleDesc.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRViewScaleDesc.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRViewScaleDesc.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static OVRPosef.Buffer nHmdToEyePose(long struct) {
        return OVRPosef.create(struct + (long)HMDTOEYEPOSE, 2);
    }

    public static OVRPosef nHmdToEyePose(long struct, int index) {
        return OVRPosef.create(struct + (long)HMDTOEYEPOSE + Checks.check((int)index, (int)2) * (long)OVRPosef.SIZEOF);
    }

    public static float nHmdSpaceToWorldScaleInMeters(long struct) {
        return UNSAFE.getFloat(null, struct + (long)HMDSPACETOWORLDSCALEINMETERS);
    }

    public static void nHmdToEyePose(long struct, OVRPosef.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HMDTOEYEPOSE), (long)(value.remaining() * OVRPosef.SIZEOF));
    }

    public static void nHmdToEyePose(long struct, int index, OVRPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HMDTOEYEPOSE + Checks.check((int)index, (int)2) * (long)OVRPosef.SIZEOF), (long)OVRPosef.SIZEOF);
    }

    public static void nHmdSpaceToWorldScaleInMeters(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)HMDSPACETOWORLDSCALEINMETERS, value);
    }

    static {
        Struct.Layout layout = OVRViewScaleDesc.__struct((Struct.Member[])new Struct.Member[]{OVRViewScaleDesc.__array((int)OVRPosef.SIZEOF, (int)OVRPosef.ALIGNOF, (int)2), OVRViewScaleDesc.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HMDTOEYEPOSE = layout.offsetof(0);
        HMDSPACETOWORLDSCALEINMETERS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRViewScaleDesc, Buffer>
    implements NativeResource {
        private static final OVRViewScaleDesc ELEMENT_FACTORY = OVRViewScaleDesc.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRViewScaleDesc getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrPosef[ovrEye_Count]")
        public OVRPosef.Buffer HmdToEyePose() {
            return OVRViewScaleDesc.nHmdToEyePose(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef HmdToEyePose(int index) {
            return OVRViewScaleDesc.nHmdToEyePose(this.address(), index);
        }

        public float HmdSpaceToWorldScaleInMeters() {
            return OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address());
        }

        public Buffer HmdToEyePose(@NativeType(value="ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) {
            OVRViewScaleDesc.nHmdToEyePose(this.address(), value);
            return this;
        }

        public Buffer HmdToEyePose(int index, @NativeType(value="ovrPosef") OVRPosef value) {
            OVRViewScaleDesc.nHmdToEyePose(this.address(), index, value);
            return this;
        }

        public Buffer HmdToEyePose(Consumer<OVRPosef.Buffer> consumer) {
            consumer.accept(this.HmdToEyePose());
            return this;
        }

        public Buffer HmdToEyePose(int index, Consumer<OVRPosef> consumer) {
            consumer.accept(this.HmdToEyePose(index));
            return this;
        }

        public Buffer HmdSpaceToWorldScaleInMeters(float value) {
            OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address(), value);
            return this;
        }
    }
}

