/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrMatrix4f")
public class OVRMatrix4f
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M;

    public OVRMatrix4f(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRMatrix4f.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[16]")
    public FloatBuffer M() {
        return OVRMatrix4f.nM(this.address());
    }

    public float M(int index) {
        return OVRMatrix4f.nM(this.address(), index);
    }

    public OVRMatrix4f M(@NativeType(value="float[16]") FloatBuffer value) {
        OVRMatrix4f.nM(this.address(), value);
        return this;
    }

    public OVRMatrix4f M(int index, float value) {
        OVRMatrix4f.nM(this.address(), index, value);
        return this;
    }

    public OVRMatrix4f set(OVRMatrix4f src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRMatrix4f malloc() {
        return (OVRMatrix4f)OVRMatrix4f.wrap(OVRMatrix4f.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRMatrix4f calloc() {
        return (OVRMatrix4f)OVRMatrix4f.wrap(OVRMatrix4f.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRMatrix4f create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRMatrix4f)OVRMatrix4f.wrap(OVRMatrix4f.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRMatrix4f create(long address) {
        return (OVRMatrix4f)OVRMatrix4f.wrap(OVRMatrix4f.class, (long)address);
    }

    @Nullable
    public static OVRMatrix4f createSafe(long address) {
        return address == 0L ? null : (OVRMatrix4f)OVRMatrix4f.wrap(OVRMatrix4f.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRMatrix4f.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRMatrix4f.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRMatrix4f.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRMatrix4f.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRMatrix4f.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRMatrix4f.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRMatrix4f.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static OVRMatrix4f mallocStack() {
        return OVRMatrix4f.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRMatrix4f callocStack() {
        return OVRMatrix4f.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRMatrix4f mallocStack(MemoryStack stack) {
        return OVRMatrix4f.malloc(stack);
    }

    @Deprecated
    public static OVRMatrix4f callocStack(MemoryStack stack) {
        return OVRMatrix4f.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRMatrix4f.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRMatrix4f.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRMatrix4f.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRMatrix4f.calloc(capacity, stack);
    }

    public static OVRMatrix4f malloc(MemoryStack stack) {
        return (OVRMatrix4f)OVRMatrix4f.wrap(OVRMatrix4f.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRMatrix4f calloc(MemoryStack stack) {
        return (OVRMatrix4f)OVRMatrix4f.wrap(OVRMatrix4f.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRMatrix4f.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRMatrix4f.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static FloatBuffer nM(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)M), (int)16);
    }

    public static float nM(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)M + Checks.check((int)index, (int)16) * 4L);
    }

    public static void nM(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)16);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((FloatBuffer)value), (long)(struct + (long)M), (long)(value.remaining() * 4));
    }

    public static void nM(long struct, int index, float value) {
        UNSAFE.putFloat(null, struct + (long)M + Checks.check((int)index, (int)16) * 4L, value);
    }

    static {
        Struct.Layout layout = OVRMatrix4f.__struct((Struct.Member[])new Struct.Member[]{OVRMatrix4f.__array((int)4, (int)16)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<OVRMatrix4f, Buffer>
    implements NativeResource {
        private static final OVRMatrix4f ELEMENT_FACTORY = OVRMatrix4f.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRMatrix4f getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float[16]")
        public FloatBuffer M() {
            return OVRMatrix4f.nM(this.address());
        }

        public float M(int index) {
            return OVRMatrix4f.nM(this.address(), index);
        }

        public Buffer M(@NativeType(value="float[16]") FloatBuffer value) {
            OVRMatrix4f.nM(this.address(), value);
            return this;
        }

        public Buffer M(int index, float value) {
            OVRMatrix4f.nM(this.address(), index, value);
            return this;
        }
    }
}

