/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrVector2f")
public class OVRVector2f
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    public OVRVector2f(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRVector2f.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return OVRVector2f.nx(this.address());
    }

    public float y() {
        return OVRVector2f.ny(this.address());
    }

    public OVRVector2f x(float value) {
        OVRVector2f.nx(this.address(), value);
        return this;
    }

    public OVRVector2f y(float value) {
        OVRVector2f.ny(this.address(), value);
        return this;
    }

    public OVRVector2f set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public OVRVector2f set(OVRVector2f src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRVector2f malloc() {
        return (OVRVector2f)OVRVector2f.wrap(OVRVector2f.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRVector2f calloc() {
        return (OVRVector2f)OVRVector2f.wrap(OVRVector2f.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRVector2f create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRVector2f)OVRVector2f.wrap(OVRVector2f.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRVector2f create(long address) {
        return (OVRVector2f)OVRVector2f.wrap(OVRVector2f.class, (long)address);
    }

    @Nullable
    public static OVRVector2f createSafe(long address) {
        return address == 0L ? null : (OVRVector2f)OVRVector2f.wrap(OVRVector2f.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRVector2f.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRVector2f.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRVector2f.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRVector2f.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRVector2f.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRVector2f.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRVector2f.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static OVRVector2f mallocStack() {
        return OVRVector2f.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRVector2f callocStack() {
        return OVRVector2f.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRVector2f mallocStack(MemoryStack stack) {
        return OVRVector2f.malloc(stack);
    }

    @Deprecated
    public static OVRVector2f callocStack(MemoryStack stack) {
        return OVRVector2f.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRVector2f.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRVector2f.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRVector2f.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRVector2f.calloc(capacity, stack);
    }

    public static OVRVector2f malloc(MemoryStack stack) {
        return (OVRVector2f)OVRVector2f.wrap(OVRVector2f.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRVector2f calloc(MemoryStack stack) {
        return (OVRVector2f)OVRVector2f.wrap(OVRVector2f.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRVector2f.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRVector2f.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static void nx(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = OVRVector2f.__struct((Struct.Member[])new Struct.Member[]{OVRVector2f.__member((int)4), OVRVector2f.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRVector2f, Buffer>
    implements NativeResource {
        private static final OVRVector2f ELEMENT_FACTORY = OVRVector2f.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRVector2f getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return OVRVector2f.nx(this.address());
        }

        public float y() {
            return OVRVector2f.ny(this.address());
        }

        public Buffer x(float value) {
            OVRVector2f.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            OVRVector2f.ny(this.address(), value);
            return this;
        }
    }
}

