/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrSizei")
public class OVRSizei
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int W;
    public static final int H;

    public OVRSizei(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRSizei.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int w() {
        return OVRSizei.nw(this.address());
    }

    public int h() {
        return OVRSizei.nh(this.address());
    }

    public OVRSizei w(int value) {
        OVRSizei.nw(this.address(), value);
        return this;
    }

    public OVRSizei h(int value) {
        OVRSizei.nh(this.address(), value);
        return this;
    }

    public OVRSizei set(int w, int h) {
        this.w(w);
        this.h(h);
        return this;
    }

    public OVRSizei set(OVRSizei src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRSizei malloc() {
        return (OVRSizei)OVRSizei.wrap(OVRSizei.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRSizei calloc() {
        return (OVRSizei)OVRSizei.wrap(OVRSizei.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRSizei create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRSizei)OVRSizei.wrap(OVRSizei.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRSizei create(long address) {
        return (OVRSizei)OVRSizei.wrap(OVRSizei.class, (long)address);
    }

    @Nullable
    public static OVRSizei createSafe(long address) {
        return address == 0L ? null : (OVRSizei)OVRSizei.wrap(OVRSizei.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRSizei.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRSizei.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRSizei.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRSizei.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRSizei.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRSizei.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRSizei.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static OVRSizei mallocStack() {
        return OVRSizei.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRSizei callocStack() {
        return OVRSizei.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRSizei mallocStack(MemoryStack stack) {
        return OVRSizei.malloc(stack);
    }

    @Deprecated
    public static OVRSizei callocStack(MemoryStack stack) {
        return OVRSizei.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRSizei.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRSizei.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRSizei.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRSizei.calloc(capacity, stack);
    }

    public static OVRSizei malloc(MemoryStack stack) {
        return (OVRSizei)OVRSizei.wrap(OVRSizei.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRSizei calloc(MemoryStack stack) {
        return (OVRSizei)OVRSizei.wrap(OVRSizei.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRSizei.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRSizei.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nw(long struct) {
        return UNSAFE.getInt(null, struct + (long)W);
    }

    public static int nh(long struct) {
        return UNSAFE.getInt(null, struct + (long)H);
    }

    public static void nw(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)W, value);
    }

    public static void nh(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)H, value);
    }

    static {
        Struct.Layout layout = OVRSizei.__struct((Struct.Member[])new Struct.Member[]{OVRSizei.__member((int)4), OVRSizei.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        W = layout.offsetof(0);
        H = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRSizei, Buffer>
    implements NativeResource {
        private static final OVRSizei ELEMENT_FACTORY = OVRSizei.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRSizei getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int w() {
            return OVRSizei.nw(this.address());
        }

        public int h() {
            return OVRSizei.nh(this.address());
        }

        public Buffer w(int value) {
            OVRSizei.nw(this.address(), value);
            return this;
        }

        public Buffer h(int value) {
            OVRSizei.nh(this.address(), value);
            return this;
        }
    }
}

