/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrQuatf")
public class OVRQuatf
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;
    public static final int W;

    public OVRQuatf(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRQuatf.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return OVRQuatf.nx(this.address());
    }

    public float y() {
        return OVRQuatf.ny(this.address());
    }

    public float z() {
        return OVRQuatf.nz(this.address());
    }

    public float w() {
        return OVRQuatf.nw(this.address());
    }

    public OVRQuatf x(float value) {
        OVRQuatf.nx(this.address(), value);
        return this;
    }

    public OVRQuatf y(float value) {
        OVRQuatf.ny(this.address(), value);
        return this;
    }

    public OVRQuatf z(float value) {
        OVRQuatf.nz(this.address(), value);
        return this;
    }

    public OVRQuatf w(float value) {
        OVRQuatf.nw(this.address(), value);
        return this;
    }

    public OVRQuatf set(float x, float y, float z, float w) {
        this.x(x);
        this.y(y);
        this.z(z);
        this.w(w);
        return this;
    }

    public OVRQuatf set(OVRQuatf src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRQuatf malloc() {
        return (OVRQuatf)OVRQuatf.wrap(OVRQuatf.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRQuatf calloc() {
        return (OVRQuatf)OVRQuatf.wrap(OVRQuatf.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRQuatf create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRQuatf)OVRQuatf.wrap(OVRQuatf.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRQuatf create(long address) {
        return (OVRQuatf)OVRQuatf.wrap(OVRQuatf.class, (long)address);
    }

    @Nullable
    public static OVRQuatf createSafe(long address) {
        return address == 0L ? null : (OVRQuatf)OVRQuatf.wrap(OVRQuatf.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRQuatf.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRQuatf.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRQuatf.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRQuatf.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRQuatf.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRQuatf.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRQuatf.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static OVRQuatf mallocStack() {
        return OVRQuatf.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRQuatf callocStack() {
        return OVRQuatf.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRQuatf mallocStack(MemoryStack stack) {
        return OVRQuatf.malloc(stack);
    }

    @Deprecated
    public static OVRQuatf callocStack(MemoryStack stack) {
        return OVRQuatf.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRQuatf.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRQuatf.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRQuatf.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRQuatf.calloc(capacity, stack);
    }

    public static OVRQuatf malloc(MemoryStack stack) {
        return (OVRQuatf)OVRQuatf.wrap(OVRQuatf.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRQuatf calloc(MemoryStack stack) {
        return (OVRQuatf)OVRQuatf.wrap(OVRQuatf.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRQuatf.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRQuatf.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static float nz(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Z);
    }

    public static float nw(long struct) {
        return UNSAFE.getFloat(null, struct + (long)W);
    }

    public static void nx(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Z, value);
    }

    public static void nw(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)W, value);
    }

    static {
        Struct.Layout layout = OVRQuatf.__struct((Struct.Member[])new Struct.Member[]{OVRQuatf.__member((int)4), OVRQuatf.__member((int)4), OVRQuatf.__member((int)4), OVRQuatf.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
        W = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OVRQuatf, Buffer>
    implements NativeResource {
        private static final OVRQuatf ELEMENT_FACTORY = OVRQuatf.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRQuatf getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return OVRQuatf.nx(this.address());
        }

        public float y() {
            return OVRQuatf.ny(this.address());
        }

        public float z() {
            return OVRQuatf.nz(this.address());
        }

        public float w() {
            return OVRQuatf.nw(this.address());
        }

        public Buffer x(float value) {
            OVRQuatf.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            OVRQuatf.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            OVRQuatf.nz(this.address(), value);
            return this;
        }

        public Buffer w(float value) {
            OVRQuatf.nw(this.address(), value);
            return this;
        }
    }
}

