/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrFovPort")
public class OVRFovPort
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int UPTAN;
    public static final int DOWNTAN;
    public static final int LEFTTAN;
    public static final int RIGHTTAN;

    public OVRFovPort(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRFovPort.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float UpTan() {
        return OVRFovPort.nUpTan(this.address());
    }

    public float DownTan() {
        return OVRFovPort.nDownTan(this.address());
    }

    public float LeftTan() {
        return OVRFovPort.nLeftTan(this.address());
    }

    public float RightTan() {
        return OVRFovPort.nRightTan(this.address());
    }

    public OVRFovPort UpTan(float value) {
        OVRFovPort.nUpTan(this.address(), value);
        return this;
    }

    public OVRFovPort DownTan(float value) {
        OVRFovPort.nDownTan(this.address(), value);
        return this;
    }

    public OVRFovPort LeftTan(float value) {
        OVRFovPort.nLeftTan(this.address(), value);
        return this;
    }

    public OVRFovPort RightTan(float value) {
        OVRFovPort.nRightTan(this.address(), value);
        return this;
    }

    public OVRFovPort set(float UpTan, float DownTan, float LeftTan, float RightTan) {
        this.UpTan(UpTan);
        this.DownTan(DownTan);
        this.LeftTan(LeftTan);
        this.RightTan(RightTan);
        return this;
    }

    public OVRFovPort set(OVRFovPort src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRFovPort malloc() {
        return (OVRFovPort)OVRFovPort.wrap(OVRFovPort.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRFovPort calloc() {
        return (OVRFovPort)OVRFovPort.wrap(OVRFovPort.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRFovPort create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRFovPort)OVRFovPort.wrap(OVRFovPort.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRFovPort create(long address) {
        return (OVRFovPort)OVRFovPort.wrap(OVRFovPort.class, (long)address);
    }

    @Nullable
    public static OVRFovPort createSafe(long address) {
        return address == 0L ? null : (OVRFovPort)OVRFovPort.wrap(OVRFovPort.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRFovPort.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRFovPort.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRFovPort.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRFovPort.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRFovPort.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRFovPort.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRFovPort.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static OVRFovPort mallocStack() {
        return OVRFovPort.mallocStack(MemoryStack.stackGet());
    }

    public static OVRFovPort callocStack() {
        return OVRFovPort.callocStack(MemoryStack.stackGet());
    }

    public static OVRFovPort mallocStack(MemoryStack stack) {
        return (OVRFovPort)OVRFovPort.wrap(OVRFovPort.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRFovPort callocStack(MemoryStack stack) {
        return (OVRFovPort)OVRFovPort.wrap(OVRFovPort.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRFovPort.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRFovPort.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)OVRFovPort.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)OVRFovPort.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float nUpTan(long struct) {
        return UNSAFE.getFloat(null, struct + (long)UPTAN);
    }

    public static float nDownTan(long struct) {
        return UNSAFE.getFloat(null, struct + (long)DOWNTAN);
    }

    public static float nLeftTan(long struct) {
        return UNSAFE.getFloat(null, struct + (long)LEFTTAN);
    }

    public static float nRightTan(long struct) {
        return UNSAFE.getFloat(null, struct + (long)RIGHTTAN);
    }

    public static void nUpTan(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)UPTAN, value);
    }

    public static void nDownTan(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)DOWNTAN, value);
    }

    public static void nLeftTan(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)LEFTTAN, value);
    }

    public static void nRightTan(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)RIGHTTAN, value);
    }

    static {
        Struct.Layout layout = OVRFovPort.__struct((Struct.Member[])new Struct.Member[]{OVRFovPort.__member((int)4), OVRFovPort.__member((int)4), OVRFovPort.__member((int)4), OVRFovPort.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        UPTAN = layout.offsetof(0);
        DOWNTAN = layout.offsetof(1);
        LEFTTAN = layout.offsetof(2);
        RIGHTTAN = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OVRFovPort, Buffer>
    implements NativeResource {
        private static final OVRFovPort ELEMENT_FACTORY = OVRFovPort.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRFovPort getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float UpTan() {
            return OVRFovPort.nUpTan(this.address());
        }

        public float DownTan() {
            return OVRFovPort.nDownTan(this.address());
        }

        public float LeftTan() {
            return OVRFovPort.nLeftTan(this.address());
        }

        public float RightTan() {
            return OVRFovPort.nRightTan(this.address());
        }

        public Buffer UpTan(float value) {
            OVRFovPort.nUpTan(this.address(), value);
            return this;
        }

        public Buffer DownTan(float value) {
            OVRFovPort.nDownTan(this.address(), value);
            return this;
        }

        public Buffer LeftTan(float value) {
            OVRFovPort.nLeftTan(this.address(), value);
            return this;
        }

        public Buffer RightTan(float value) {
            OVRFovPort.nRightTan(this.address(), value);
            return this;
        }
    }
}

