/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRMatrix4f;
import org.lwjgl.ovr.OVRSizei;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrCameraIntrinsics")
public class OVRCameraIntrinsics
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LASTCHANGEDTIME;
    public static final int FOVPORT;
    public static final int VIRTUALNEARPLANEDISTANCEMETERS;
    public static final int VIRTUALFARPLANEDISTANCEMETERS;
    public static final int IMAGESENSORPIXELRESOLUTION;
    public static final int LENSDISTORTIONMATRIX;
    public static final int EXPOSUREPERIODSECONDS;
    public static final int EXPOSUREDURATIONSECONDS;

    public OVRCameraIntrinsics(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRCameraIntrinsics.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public double LastChangedTime() {
        return OVRCameraIntrinsics.nLastChangedTime(this.address());
    }

    @NativeType(value="ovrFovPort")
    public OVRFovPort FOVPort() {
        return OVRCameraIntrinsics.nFOVPort(this.address());
    }

    public float VirtualNearPlaneDistanceMeters() {
        return OVRCameraIntrinsics.nVirtualNearPlaneDistanceMeters(this.address());
    }

    public float VirtualFarPlaneDistanceMeters() {
        return OVRCameraIntrinsics.nVirtualFarPlaneDistanceMeters(this.address());
    }

    @NativeType(value="ovrSizei")
    public OVRSizei ImageSensorPixelResolution() {
        return OVRCameraIntrinsics.nImageSensorPixelResolution(this.address());
    }

    @NativeType(value="ovrMatrix4f")
    public OVRMatrix4f LensDistortionMatrix() {
        return OVRCameraIntrinsics.nLensDistortionMatrix(this.address());
    }

    public double ExposurePeriodSeconds() {
        return OVRCameraIntrinsics.nExposurePeriodSeconds(this.address());
    }

    public double ExposureDurationSeconds() {
        return OVRCameraIntrinsics.nExposureDurationSeconds(this.address());
    }

    public OVRCameraIntrinsics LastChangedTime(double value) {
        OVRCameraIntrinsics.nLastChangedTime(this.address(), value);
        return this;
    }

    public OVRCameraIntrinsics FOVPort(@NativeType(value="ovrFovPort") OVRFovPort value) {
        OVRCameraIntrinsics.nFOVPort(this.address(), value);
        return this;
    }

    public OVRCameraIntrinsics FOVPort(Consumer<OVRFovPort> consumer) {
        consumer.accept(this.FOVPort());
        return this;
    }

    public OVRCameraIntrinsics VirtualNearPlaneDistanceMeters(float value) {
        OVRCameraIntrinsics.nVirtualNearPlaneDistanceMeters(this.address(), value);
        return this;
    }

    public OVRCameraIntrinsics VirtualFarPlaneDistanceMeters(float value) {
        OVRCameraIntrinsics.nVirtualFarPlaneDistanceMeters(this.address(), value);
        return this;
    }

    public OVRCameraIntrinsics ImageSensorPixelResolution(@NativeType(value="ovrSizei") OVRSizei value) {
        OVRCameraIntrinsics.nImageSensorPixelResolution(this.address(), value);
        return this;
    }

    public OVRCameraIntrinsics ImageSensorPixelResolution(Consumer<OVRSizei> consumer) {
        consumer.accept(this.ImageSensorPixelResolution());
        return this;
    }

    public OVRCameraIntrinsics LensDistortionMatrix(@NativeType(value="ovrMatrix4f") OVRMatrix4f value) {
        OVRCameraIntrinsics.nLensDistortionMatrix(this.address(), value);
        return this;
    }

    public OVRCameraIntrinsics LensDistortionMatrix(Consumer<OVRMatrix4f> consumer) {
        consumer.accept(this.LensDistortionMatrix());
        return this;
    }

    public OVRCameraIntrinsics ExposurePeriodSeconds(double value) {
        OVRCameraIntrinsics.nExposurePeriodSeconds(this.address(), value);
        return this;
    }

    public OVRCameraIntrinsics ExposureDurationSeconds(double value) {
        OVRCameraIntrinsics.nExposureDurationSeconds(this.address(), value);
        return this;
    }

    public OVRCameraIntrinsics set(double LastChangedTime, OVRFovPort FOVPort, float VirtualNearPlaneDistanceMeters, float VirtualFarPlaneDistanceMeters, OVRSizei ImageSensorPixelResolution, OVRMatrix4f LensDistortionMatrix, double ExposurePeriodSeconds, double ExposureDurationSeconds) {
        this.LastChangedTime(LastChangedTime);
        this.FOVPort(FOVPort);
        this.VirtualNearPlaneDistanceMeters(VirtualNearPlaneDistanceMeters);
        this.VirtualFarPlaneDistanceMeters(VirtualFarPlaneDistanceMeters);
        this.ImageSensorPixelResolution(ImageSensorPixelResolution);
        this.LensDistortionMatrix(LensDistortionMatrix);
        this.ExposurePeriodSeconds(ExposurePeriodSeconds);
        this.ExposureDurationSeconds(ExposureDurationSeconds);
        return this;
    }

    public OVRCameraIntrinsics set(OVRCameraIntrinsics src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRCameraIntrinsics malloc() {
        return (OVRCameraIntrinsics)OVRCameraIntrinsics.wrap(OVRCameraIntrinsics.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRCameraIntrinsics calloc() {
        return (OVRCameraIntrinsics)OVRCameraIntrinsics.wrap(OVRCameraIntrinsics.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRCameraIntrinsics create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRCameraIntrinsics)OVRCameraIntrinsics.wrap(OVRCameraIntrinsics.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRCameraIntrinsics create(long address) {
        return (OVRCameraIntrinsics)OVRCameraIntrinsics.wrap(OVRCameraIntrinsics.class, (long)address);
    }

    @Nullable
    public static OVRCameraIntrinsics createSafe(long address) {
        return address == 0L ? null : (OVRCameraIntrinsics)OVRCameraIntrinsics.wrap(OVRCameraIntrinsics.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRCameraIntrinsics.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRCameraIntrinsics.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRCameraIntrinsics.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRCameraIntrinsics.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRCameraIntrinsics.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRCameraIntrinsics.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRCameraIntrinsics.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static OVRCameraIntrinsics mallocStack() {
        return OVRCameraIntrinsics.mallocStack(MemoryStack.stackGet());
    }

    public static OVRCameraIntrinsics callocStack() {
        return OVRCameraIntrinsics.callocStack(MemoryStack.stackGet());
    }

    public static OVRCameraIntrinsics mallocStack(MemoryStack stack) {
        return (OVRCameraIntrinsics)OVRCameraIntrinsics.wrap(OVRCameraIntrinsics.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRCameraIntrinsics callocStack(MemoryStack stack) {
        return (OVRCameraIntrinsics)OVRCameraIntrinsics.wrap(OVRCameraIntrinsics.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRCameraIntrinsics.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRCameraIntrinsics.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)OVRCameraIntrinsics.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)OVRCameraIntrinsics.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static double nLastChangedTime(long struct) {
        return UNSAFE.getDouble(null, struct + (long)LASTCHANGEDTIME);
    }

    public static OVRFovPort nFOVPort(long struct) {
        return OVRFovPort.create(struct + (long)FOVPORT);
    }

    public static float nVirtualNearPlaneDistanceMeters(long struct) {
        return UNSAFE.getFloat(null, struct + (long)VIRTUALNEARPLANEDISTANCEMETERS);
    }

    public static float nVirtualFarPlaneDistanceMeters(long struct) {
        return UNSAFE.getFloat(null, struct + (long)VIRTUALFARPLANEDISTANCEMETERS);
    }

    public static OVRSizei nImageSensorPixelResolution(long struct) {
        return OVRSizei.create(struct + (long)IMAGESENSORPIXELRESOLUTION);
    }

    public static OVRMatrix4f nLensDistortionMatrix(long struct) {
        return OVRMatrix4f.create(struct + (long)LENSDISTORTIONMATRIX);
    }

    public static double nExposurePeriodSeconds(long struct) {
        return UNSAFE.getDouble(null, struct + (long)EXPOSUREPERIODSECONDS);
    }

    public static double nExposureDurationSeconds(long struct) {
        return UNSAFE.getDouble(null, struct + (long)EXPOSUREDURATIONSECONDS);
    }

    public static void nLastChangedTime(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)LASTCHANGEDTIME, value);
    }

    public static void nFOVPort(long struct, OVRFovPort value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FOVPORT), (long)OVRFovPort.SIZEOF);
    }

    public static void nVirtualNearPlaneDistanceMeters(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)VIRTUALNEARPLANEDISTANCEMETERS, value);
    }

    public static void nVirtualFarPlaneDistanceMeters(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)VIRTUALFARPLANEDISTANCEMETERS, value);
    }

    public static void nImageSensorPixelResolution(long struct, OVRSizei value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)IMAGESENSORPIXELRESOLUTION), (long)OVRSizei.SIZEOF);
    }

    public static void nLensDistortionMatrix(long struct, OVRMatrix4f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)LENSDISTORTIONMATRIX), (long)OVRMatrix4f.SIZEOF);
    }

    public static void nExposurePeriodSeconds(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)EXPOSUREPERIODSECONDS, value);
    }

    public static void nExposureDurationSeconds(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)EXPOSUREDURATIONSECONDS, value);
    }

    static {
        Struct.Layout layout = OVRCameraIntrinsics.__struct((Struct.Member[])new Struct.Member[]{OVRCameraIntrinsics.__member((int)8), OVRCameraIntrinsics.__member((int)OVRFovPort.SIZEOF, (int)OVRFovPort.ALIGNOF), OVRCameraIntrinsics.__member((int)4), OVRCameraIntrinsics.__member((int)4), OVRCameraIntrinsics.__member((int)OVRSizei.SIZEOF, (int)OVRSizei.ALIGNOF), OVRCameraIntrinsics.__member((int)OVRMatrix4f.SIZEOF, (int)OVRMatrix4f.ALIGNOF), OVRCameraIntrinsics.__member((int)8), OVRCameraIntrinsics.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LASTCHANGEDTIME = layout.offsetof(0);
        FOVPORT = layout.offsetof(1);
        VIRTUALNEARPLANEDISTANCEMETERS = layout.offsetof(2);
        VIRTUALFARPLANEDISTANCEMETERS = layout.offsetof(3);
        IMAGESENSORPIXELRESOLUTION = layout.offsetof(4);
        LENSDISTORTIONMATRIX = layout.offsetof(5);
        EXPOSUREPERIODSECONDS = layout.offsetof(6);
        EXPOSUREDURATIONSECONDS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<OVRCameraIntrinsics, Buffer>
    implements NativeResource {
        private static final OVRCameraIntrinsics ELEMENT_FACTORY = OVRCameraIntrinsics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRCameraIntrinsics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double LastChangedTime() {
            return OVRCameraIntrinsics.nLastChangedTime(this.address());
        }

        @NativeType(value="ovrFovPort")
        public OVRFovPort FOVPort() {
            return OVRCameraIntrinsics.nFOVPort(this.address());
        }

        public float VirtualNearPlaneDistanceMeters() {
            return OVRCameraIntrinsics.nVirtualNearPlaneDistanceMeters(this.address());
        }

        public float VirtualFarPlaneDistanceMeters() {
            return OVRCameraIntrinsics.nVirtualFarPlaneDistanceMeters(this.address());
        }

        @NativeType(value="ovrSizei")
        public OVRSizei ImageSensorPixelResolution() {
            return OVRCameraIntrinsics.nImageSensorPixelResolution(this.address());
        }

        @NativeType(value="ovrMatrix4f")
        public OVRMatrix4f LensDistortionMatrix() {
            return OVRCameraIntrinsics.nLensDistortionMatrix(this.address());
        }

        public double ExposurePeriodSeconds() {
            return OVRCameraIntrinsics.nExposurePeriodSeconds(this.address());
        }

        public double ExposureDurationSeconds() {
            return OVRCameraIntrinsics.nExposureDurationSeconds(this.address());
        }

        public Buffer LastChangedTime(double value) {
            OVRCameraIntrinsics.nLastChangedTime(this.address(), value);
            return this;
        }

        public Buffer FOVPort(@NativeType(value="ovrFovPort") OVRFovPort value) {
            OVRCameraIntrinsics.nFOVPort(this.address(), value);
            return this;
        }

        public Buffer FOVPort(Consumer<OVRFovPort> consumer) {
            consumer.accept(this.FOVPort());
            return this;
        }

        public Buffer VirtualNearPlaneDistanceMeters(float value) {
            OVRCameraIntrinsics.nVirtualNearPlaneDistanceMeters(this.address(), value);
            return this;
        }

        public Buffer VirtualFarPlaneDistanceMeters(float value) {
            OVRCameraIntrinsics.nVirtualFarPlaneDistanceMeters(this.address(), value);
            return this;
        }

        public Buffer ImageSensorPixelResolution(@NativeType(value="ovrSizei") OVRSizei value) {
            OVRCameraIntrinsics.nImageSensorPixelResolution(this.address(), value);
            return this;
        }

        public Buffer ImageSensorPixelResolution(Consumer<OVRSizei> consumer) {
            consumer.accept(this.ImageSensorPixelResolution());
            return this;
        }

        public Buffer LensDistortionMatrix(@NativeType(value="ovrMatrix4f") OVRMatrix4f value) {
            OVRCameraIntrinsics.nLensDistortionMatrix(this.address(), value);
            return this;
        }

        public Buffer LensDistortionMatrix(Consumer<OVRMatrix4f> consumer) {
            consumer.accept(this.LensDistortionMatrix());
            return this;
        }

        public Buffer ExposurePeriodSeconds(double value) {
            OVRCameraIntrinsics.nExposurePeriodSeconds(this.address(), value);
            return this;
        }

        public Buffer ExposureDurationSeconds(double value) {
            OVRCameraIntrinsics.nExposureDurationSeconds(this.address(), value);
            return this;
        }
    }
}

