/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRVector2f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrViewportStencilMeshBuffer")
public class OVRViewportStencilMeshBuffer
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOCVERTEXCOUNT;
    public static final int USEDVERTEXCOUNT;
    public static final int VERTEXBUFFER;
    public static final int ALLOCINDEXCOUNT;
    public static final int USEDINDEXCOUNT;
    public static final int INDEXBUFFER;

    OVRViewportStencilMeshBuffer(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRViewportStencilMeshBuffer(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRViewportStencilMeshBuffer.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int AllocVertexCount() {
        return OVRViewportStencilMeshBuffer.nAllocVertexCount(this.address());
    }

    public int UsedVertexCount() {
        return OVRViewportStencilMeshBuffer.nUsedVertexCount(this.address());
    }

    @NativeType(value="ovrVector2f *")
    public OVRVector2f.Buffer VertexBuffer() {
        return OVRViewportStencilMeshBuffer.nVertexBuffer(this.address());
    }

    public int AllocIndexCount() {
        return OVRViewportStencilMeshBuffer.nAllocIndexCount(this.address());
    }

    public int UsedIndexCount() {
        return OVRViewportStencilMeshBuffer.nUsedIndexCount(this.address());
    }

    @NativeType(value="uint16_t *")
    public ShortBuffer IndexBuffer() {
        return OVRViewportStencilMeshBuffer.nIndexBuffer(this.address());
    }

    public OVRViewportStencilMeshBuffer UsedVertexCount(int value) {
        OVRViewportStencilMeshBuffer.nUsedVertexCount(this.address(), value);
        return this;
    }

    public OVRViewportStencilMeshBuffer VertexBuffer(@NativeType(value="ovrVector2f *") OVRVector2f.Buffer value) {
        OVRViewportStencilMeshBuffer.nVertexBuffer(this.address(), value);
        return this;
    }

    public OVRViewportStencilMeshBuffer UsedIndexCount(int value) {
        OVRViewportStencilMeshBuffer.nUsedIndexCount(this.address(), value);
        return this;
    }

    public OVRViewportStencilMeshBuffer IndexBuffer(@NativeType(value="uint16_t *") ShortBuffer value) {
        OVRViewportStencilMeshBuffer.nIndexBuffer(this.address(), value);
        return this;
    }

    public OVRViewportStencilMeshBuffer set(int UsedVertexCount, OVRVector2f.Buffer VertexBuffer, int UsedIndexCount, ShortBuffer IndexBuffer) {
        this.UsedVertexCount(UsedVertexCount);
        this.VertexBuffer(VertexBuffer);
        this.UsedIndexCount(UsedIndexCount);
        this.IndexBuffer(IndexBuffer);
        return this;
    }

    public OVRViewportStencilMeshBuffer set(OVRViewportStencilMeshBuffer src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRViewportStencilMeshBuffer malloc() {
        return OVRViewportStencilMeshBuffer.create(MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRViewportStencilMeshBuffer calloc() {
        return OVRViewportStencilMeshBuffer.create(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRViewportStencilMeshBuffer create() {
        return new OVRViewportStencilMeshBuffer(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRViewportStencilMeshBuffer create(long address) {
        return new OVRViewportStencilMeshBuffer(address, null);
    }

    @Nullable
    public static OVRViewportStencilMeshBuffer createSafe(long address) {
        return address == 0L ? null : OVRViewportStencilMeshBuffer.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRViewportStencilMeshBuffer.create(OVRViewportStencilMeshBuffer.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRViewportStencilMeshBuffer.create(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRViewportStencilMeshBuffer.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRViewportStencilMeshBuffer.create(address, capacity);
    }

    public static OVRViewportStencilMeshBuffer mallocStack() {
        return OVRViewportStencilMeshBuffer.mallocStack(MemoryStack.stackGet());
    }

    public static OVRViewportStencilMeshBuffer callocStack() {
        return OVRViewportStencilMeshBuffer.callocStack(MemoryStack.stackGet());
    }

    public static OVRViewportStencilMeshBuffer mallocStack(MemoryStack stack) {
        return OVRViewportStencilMeshBuffer.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRViewportStencilMeshBuffer callocStack(MemoryStack stack) {
        return OVRViewportStencilMeshBuffer.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRViewportStencilMeshBuffer.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRViewportStencilMeshBuffer.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRViewportStencilMeshBuffer.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRViewportStencilMeshBuffer.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nAllocVertexCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ALLOCVERTEXCOUNT));
    }

    public static int nUsedVertexCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)USEDVERTEXCOUNT));
    }

    public static OVRVector2f.Buffer nVertexBuffer(long struct) {
        return OVRVector2f.create(MemoryUtil.memGetAddress((long)(struct + (long)VERTEXBUFFER)), OVRViewportStencilMeshBuffer.nAllocVertexCount(struct));
    }

    public static int nAllocIndexCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ALLOCINDEXCOUNT));
    }

    public static int nUsedIndexCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)USEDINDEXCOUNT));
    }

    public static ShortBuffer nIndexBuffer(long struct) {
        return MemoryUtil.memShortBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)INDEXBUFFER)), (int)OVRViewportStencilMeshBuffer.nAllocIndexCount(struct));
    }

    public static void nAllocVertexCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ALLOCVERTEXCOUNT), (int)value);
    }

    public static void nUsedVertexCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)USEDVERTEXCOUNT), (int)value);
    }

    public static void nVertexBuffer(long struct, OVRVector2f.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VERTEXBUFFER), (long)value.address());
        OVRViewportStencilMeshBuffer.nAllocVertexCount(struct, value.remaining());
    }

    public static void nAllocIndexCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ALLOCINDEXCOUNT), (int)value);
    }

    public static void nUsedIndexCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)USEDINDEXCOUNT), (int)value);
    }

    public static void nIndexBuffer(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)INDEXBUFFER), (long)MemoryUtil.memAddress((ShortBuffer)value));
        OVRViewportStencilMeshBuffer.nAllocIndexCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)VERTEXBUFFER)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)INDEXBUFFER)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            OVRViewportStencilMeshBuffer.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = OVRViewportStencilMeshBuffer.__struct((Struct.Member[])new Struct.Member[]{OVRViewportStencilMeshBuffer.__member((int)4), OVRViewportStencilMeshBuffer.__member((int)4), OVRViewportStencilMeshBuffer.__member((int)POINTER_SIZE), OVRViewportStencilMeshBuffer.__member((int)4), OVRViewportStencilMeshBuffer.__member((int)4), OVRViewportStencilMeshBuffer.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ALLOCVERTEXCOUNT = layout.offsetof(0);
        USEDVERTEXCOUNT = layout.offsetof(1);
        VERTEXBUFFER = layout.offsetof(2);
        ALLOCINDEXCOUNT = layout.offsetof(3);
        USEDINDEXCOUNT = layout.offsetof(4);
        INDEXBUFFER = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<OVRViewportStencilMeshBuffer, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRViewportStencilMeshBuffer newInstance(long address) {
            return new OVRViewportStencilMeshBuffer(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        public int AllocVertexCount() {
            return OVRViewportStencilMeshBuffer.nAllocVertexCount(this.address());
        }

        public int UsedVertexCount() {
            return OVRViewportStencilMeshBuffer.nUsedVertexCount(this.address());
        }

        @NativeType(value="ovrVector2f *")
        public OVRVector2f.Buffer VertexBuffer() {
            return OVRViewportStencilMeshBuffer.nVertexBuffer(this.address());
        }

        public int AllocIndexCount() {
            return OVRViewportStencilMeshBuffer.nAllocIndexCount(this.address());
        }

        public int UsedIndexCount() {
            return OVRViewportStencilMeshBuffer.nUsedIndexCount(this.address());
        }

        @NativeType(value="uint16_t *")
        public ShortBuffer IndexBuffer() {
            return OVRViewportStencilMeshBuffer.nIndexBuffer(this.address());
        }

        public Buffer UsedVertexCount(int value) {
            OVRViewportStencilMeshBuffer.nUsedVertexCount(this.address(), value);
            return this;
        }

        public Buffer VertexBuffer(@NativeType(value="ovrVector2f *") OVRVector2f.Buffer value) {
            OVRViewportStencilMeshBuffer.nVertexBuffer(this.address(), value);
            return this;
        }

        public Buffer UsedIndexCount(int value) {
            OVRViewportStencilMeshBuffer.nUsedIndexCount(this.address(), value);
            return this;
        }

        public Buffer IndexBuffer(@NativeType(value="uint16_t *") ShortBuffer value) {
            OVRViewportStencilMeshBuffer.nIndexBuffer(this.address(), value);
            return this;
        }
    }
}

