/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRQuatf;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrViewportStencilDesc")
public class OVRViewportStencilDesc
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STENCILTYPE;
    public static final int EYE;
    public static final int FOVPORT;
    public static final int HMDTOEYEROTATION;

    OVRViewportStencilDesc(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRViewportStencilDesc(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRViewportStencilDesc.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrViewportStencilType")
    public int StencilType() {
        return OVRViewportStencilDesc.nStencilType(this.address());
    }

    @NativeType(value="ovrEyeType")
    public int Eye() {
        return OVRViewportStencilDesc.nEye(this.address());
    }

    @NativeType(value="ovrFovPort")
    public OVRFovPort FovPort() {
        return OVRViewportStencilDesc.nFovPort(this.address());
    }

    public OVRViewportStencilDesc FovPort(Consumer<OVRFovPort> consumer) {
        consumer.accept(this.FovPort());
        return this;
    }

    @NativeType(value="ovrQuatf")
    public OVRQuatf HmdToEyeRotation() {
        return OVRViewportStencilDesc.nHmdToEyeRotation(this.address());
    }

    public OVRViewportStencilDesc HmdToEyeRotation(Consumer<OVRQuatf> consumer) {
        consumer.accept(this.HmdToEyeRotation());
        return this;
    }

    public OVRViewportStencilDesc StencilType(@NativeType(value="ovrViewportStencilType") int value) {
        OVRViewportStencilDesc.nStencilType(this.address(), value);
        return this;
    }

    public OVRViewportStencilDesc Eye(@NativeType(value="ovrEyeType") int value) {
        OVRViewportStencilDesc.nEye(this.address(), value);
        return this;
    }

    public OVRViewportStencilDesc FovPort(@NativeType(value="ovrFovPort") OVRFovPort value) {
        OVRViewportStencilDesc.nFovPort(this.address(), value);
        return this;
    }

    public OVRViewportStencilDesc HmdToEyeRotation(@NativeType(value="ovrQuatf") OVRQuatf value) {
        OVRViewportStencilDesc.nHmdToEyeRotation(this.address(), value);
        return this;
    }

    public OVRViewportStencilDesc set(int StencilType, int Eye, OVRFovPort FovPort, OVRQuatf HmdToEyeRotation) {
        this.StencilType(StencilType);
        this.Eye(Eye);
        this.FovPort(FovPort);
        this.HmdToEyeRotation(HmdToEyeRotation);
        return this;
    }

    public OVRViewportStencilDesc set(OVRViewportStencilDesc src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRViewportStencilDesc malloc() {
        return OVRViewportStencilDesc.create(MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRViewportStencilDesc calloc() {
        return OVRViewportStencilDesc.create(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRViewportStencilDesc create() {
        return new OVRViewportStencilDesc(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRViewportStencilDesc create(long address) {
        return new OVRViewportStencilDesc(address, null);
    }

    @Nullable
    public static OVRViewportStencilDesc createSafe(long address) {
        return address == 0L ? null : OVRViewportStencilDesc.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRViewportStencilDesc.create(OVRViewportStencilDesc.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRViewportStencilDesc.create(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRViewportStencilDesc.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRViewportStencilDesc.create(address, capacity);
    }

    public static OVRViewportStencilDesc mallocStack() {
        return OVRViewportStencilDesc.mallocStack(MemoryStack.stackGet());
    }

    public static OVRViewportStencilDesc callocStack() {
        return OVRViewportStencilDesc.callocStack(MemoryStack.stackGet());
    }

    public static OVRViewportStencilDesc mallocStack(MemoryStack stack) {
        return OVRViewportStencilDesc.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRViewportStencilDesc callocStack(MemoryStack stack) {
        return OVRViewportStencilDesc.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRViewportStencilDesc.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRViewportStencilDesc.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRViewportStencilDesc.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRViewportStencilDesc.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nStencilType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STENCILTYPE));
    }

    public static int nEye(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)EYE));
    }

    public static OVRFovPort nFovPort(long struct) {
        return OVRFovPort.create(struct + (long)FOVPORT);
    }

    public static OVRQuatf nHmdToEyeRotation(long struct) {
        return OVRQuatf.create(struct + (long)HMDTOEYEROTATION);
    }

    public static void nStencilType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STENCILTYPE), (int)value);
    }

    public static void nEye(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)EYE), (int)value);
    }

    public static void nFovPort(long struct, OVRFovPort value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FOVPORT), (long)OVRFovPort.SIZEOF);
    }

    public static void nHmdToEyeRotation(long struct, OVRQuatf value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HMDTOEYEROTATION), (long)OVRQuatf.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRViewportStencilDesc.__struct((Struct.Member[])new Struct.Member[]{OVRViewportStencilDesc.__member((int)4), OVRViewportStencilDesc.__member((int)4), OVRViewportStencilDesc.__member((int)OVRFovPort.SIZEOF, (int)OVRFovPort.ALIGNOF), OVRViewportStencilDesc.__member((int)OVRQuatf.SIZEOF, (int)OVRQuatf.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STENCILTYPE = layout.offsetof(0);
        EYE = layout.offsetof(1);
        FOVPORT = layout.offsetof(2);
        HMDTOEYEROTATION = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OVRViewportStencilDesc, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRViewportStencilDesc newInstance(long address) {
            return new OVRViewportStencilDesc(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrViewportStencilType")
        public int StencilType() {
            return OVRViewportStencilDesc.nStencilType(this.address());
        }

        @NativeType(value="ovrEyeType")
        public int Eye() {
            return OVRViewportStencilDesc.nEye(this.address());
        }

        @NativeType(value="ovrFovPort")
        public OVRFovPort FovPort() {
            return OVRViewportStencilDesc.nFovPort(this.address());
        }

        public Buffer FovPort(Consumer<OVRFovPort> consumer) {
            consumer.accept(this.FovPort());
            return this;
        }

        @NativeType(value="ovrQuatf")
        public OVRQuatf HmdToEyeRotation() {
            return OVRViewportStencilDesc.nHmdToEyeRotation(this.address());
        }

        public Buffer HmdToEyeRotation(Consumer<OVRQuatf> consumer) {
            consumer.accept(this.HmdToEyeRotation());
            return this;
        }

        public Buffer StencilType(@NativeType(value="ovrViewportStencilType") int value) {
            OVRViewportStencilDesc.nStencilType(this.address(), value);
            return this;
        }

        public Buffer Eye(@NativeType(value="ovrEyeType") int value) {
            OVRViewportStencilDesc.nEye(this.address(), value);
            return this;
        }

        public Buffer FovPort(@NativeType(value="ovrFovPort") OVRFovPort value) {
            OVRViewportStencilDesc.nFovPort(this.address(), value);
            return this;
        }

        public Buffer HmdToEyeRotation(@NativeType(value="ovrQuatf") OVRQuatf value) {
            OVRViewportStencilDesc.nHmdToEyeRotation(this.address(), value);
            return this;
        }
    }
}

