/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRPoseStatef;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrTrackingState")
public class OVRTrackingState
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADPOSE;
    public static final int STATUSFLAGS;
    public static final int HANDPOSES;
    public static final int HANDSTATUSFLAGS;
    public static final int CALIBRATEDORIGIN;

    OVRTrackingState(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRTrackingState(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRTrackingState.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrPoseStatef")
    public OVRPoseStatef HeadPose() {
        return OVRTrackingState.nHeadPose(this.address());
    }

    @NativeType(value="unsigned int")
    public int StatusFlags() {
        return OVRTrackingState.nStatusFlags(this.address());
    }

    @NativeType(value="ovrPoseStatef[2]")
    public OVRPoseStatef.Buffer HandPoses() {
        return OVRTrackingState.nHandPoses(this.address());
    }

    @NativeType(value="ovrPoseStatef")
    public OVRPoseStatef HandPoses(int index) {
        return OVRTrackingState.nHandPoses(this.address(), index);
    }

    @NativeType(value="unsigned int[2]")
    public IntBuffer HandStatusFlags() {
        return OVRTrackingState.nHandStatusFlags(this.address());
    }

    @NativeType(value="unsigned int")
    public int HandStatusFlags(int index) {
        return OVRTrackingState.nHandStatusFlags(this.address(), index);
    }

    @NativeType(value="ovrPosef")
    public OVRPosef CalibratedOrigin() {
        return OVRTrackingState.nCalibratedOrigin(this.address());
    }

    public OVRTrackingState CalibratedOrigin(Consumer<OVRPosef> consumer) {
        consumer.accept(this.CalibratedOrigin());
        return this;
    }

    public static OVRTrackingState malloc() {
        return OVRTrackingState.create(MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRTrackingState calloc() {
        return OVRTrackingState.create(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRTrackingState create() {
        return new OVRTrackingState(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRTrackingState create(long address) {
        return new OVRTrackingState(address, null);
    }

    @Nullable
    public static OVRTrackingState createSafe(long address) {
        return address == 0L ? null : OVRTrackingState.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRTrackingState.create(OVRTrackingState.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRTrackingState.create(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRTrackingState.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRTrackingState.create(address, capacity);
    }

    public static OVRTrackingState mallocStack() {
        return OVRTrackingState.mallocStack(MemoryStack.stackGet());
    }

    public static OVRTrackingState callocStack() {
        return OVRTrackingState.callocStack(MemoryStack.stackGet());
    }

    public static OVRTrackingState mallocStack(MemoryStack stack) {
        return OVRTrackingState.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRTrackingState callocStack(MemoryStack stack) {
        return OVRTrackingState.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRTrackingState.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRTrackingState.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRTrackingState.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRTrackingState.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRPoseStatef nHeadPose(long struct) {
        return OVRPoseStatef.create(struct + (long)HEADPOSE);
    }

    public static int nStatusFlags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STATUSFLAGS));
    }

    public static OVRPoseStatef.Buffer nHandPoses(long struct) {
        return OVRPoseStatef.create(struct + (long)HANDPOSES, 2);
    }

    public static OVRPoseStatef nHandPoses(long struct, int index) {
        return OVRPoseStatef.create(struct + (long)HANDPOSES + Checks.check((int)index, (int)2) * (long)OVRPoseStatef.SIZEOF);
    }

    public static IntBuffer nHandStatusFlags(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)HANDSTATUSFLAGS), (int)2);
    }

    public static int nHandStatusFlags(long struct, int index) {
        return MemoryUtil.memGetInt((long)(struct + (long)HANDSTATUSFLAGS + Checks.check((int)index, (int)2) * 4L));
    }

    public static OVRPosef nCalibratedOrigin(long struct) {
        return OVRPosef.create(struct + (long)CALIBRATEDORIGIN);
    }

    static {
        Struct.Layout layout = OVRTrackingState.__struct((Struct.Member[])new Struct.Member[]{OVRTrackingState.__member((int)OVRPoseStatef.SIZEOF, (int)OVRPoseStatef.ALIGNOF), OVRTrackingState.__member((int)4), OVRTrackingState.__array((int)OVRPoseStatef.SIZEOF, (int)OVRPoseStatef.ALIGNOF, (int)2), OVRTrackingState.__array((int)4, (int)2), OVRTrackingState.__member((int)OVRPosef.SIZEOF, (int)OVRPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADPOSE = layout.offsetof(0);
        STATUSFLAGS = layout.offsetof(1);
        HANDPOSES = layout.offsetof(2);
        HANDSTATUSFLAGS = layout.offsetof(3);
        CALIBRATEDORIGIN = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<OVRTrackingState, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRTrackingState newInstance(long address) {
            return new OVRTrackingState(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrPoseStatef")
        public OVRPoseStatef HeadPose() {
            return OVRTrackingState.nHeadPose(this.address());
        }

        @NativeType(value="unsigned int")
        public int StatusFlags() {
            return OVRTrackingState.nStatusFlags(this.address());
        }

        @NativeType(value="ovrPoseStatef[2]")
        public OVRPoseStatef.Buffer HandPoses() {
            return OVRTrackingState.nHandPoses(this.address());
        }

        @NativeType(value="ovrPoseStatef")
        public OVRPoseStatef HandPoses(int index) {
            return OVRTrackingState.nHandPoses(this.address(), index);
        }

        @NativeType(value="unsigned int[2]")
        public IntBuffer HandStatusFlags() {
            return OVRTrackingState.nHandStatusFlags(this.address());
        }

        @NativeType(value="unsigned int")
        public int HandStatusFlags(int index) {
            return OVRTrackingState.nHandStatusFlags(this.address(), index);
        }

        @NativeType(value="ovrPosef")
        public OVRPosef CalibratedOrigin() {
            return OVRTrackingState.nCalibratedOrigin(this.address());
        }

        public Buffer CalibratedOrigin(Consumer<OVRPosef> consumer) {
            consumer.accept(this.CalibratedOrigin());
            return this;
        }
    }
}

