/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrTrackerPose")
public class OVRTrackerPose
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TRACKERFLAGS;
    public static final int POSE;
    public static final int LEVELEDPOSE;

    OVRTrackerPose(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRTrackerPose(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRTrackerPose.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int TrackerFlags() {
        return OVRTrackerPose.nTrackerFlags(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef Pose() {
        return OVRTrackerPose.nPose(this.address());
    }

    public OVRTrackerPose Pose(Consumer<OVRPosef> consumer) {
        consumer.accept(this.Pose());
        return this;
    }

    @NativeType(value="ovrPosef")
    public OVRPosef LeveledPose() {
        return OVRTrackerPose.nLeveledPose(this.address());
    }

    public OVRTrackerPose LeveledPose(Consumer<OVRPosef> consumer) {
        consumer.accept(this.LeveledPose());
        return this;
    }

    public static OVRTrackerPose malloc() {
        return OVRTrackerPose.create(MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRTrackerPose calloc() {
        return OVRTrackerPose.create(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRTrackerPose create() {
        return new OVRTrackerPose(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRTrackerPose create(long address) {
        return new OVRTrackerPose(address, null);
    }

    @Nullable
    public static OVRTrackerPose createSafe(long address) {
        return address == 0L ? null : OVRTrackerPose.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRTrackerPose.create(OVRTrackerPose.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRTrackerPose.create(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRTrackerPose.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRTrackerPose.create(address, capacity);
    }

    public static OVRTrackerPose mallocStack() {
        return OVRTrackerPose.mallocStack(MemoryStack.stackGet());
    }

    public static OVRTrackerPose callocStack() {
        return OVRTrackerPose.callocStack(MemoryStack.stackGet());
    }

    public static OVRTrackerPose mallocStack(MemoryStack stack) {
        return OVRTrackerPose.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRTrackerPose callocStack(MemoryStack stack) {
        return OVRTrackerPose.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRTrackerPose.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRTrackerPose.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRTrackerPose.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRTrackerPose.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nTrackerFlags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TRACKERFLAGS));
    }

    public static OVRPosef nPose(long struct) {
        return OVRPosef.create(struct + (long)POSE);
    }

    public static OVRPosef nLeveledPose(long struct) {
        return OVRPosef.create(struct + (long)LEVELEDPOSE);
    }

    static {
        Struct.Layout layout = OVRTrackerPose.__struct((Struct.Member[])new Struct.Member[]{OVRTrackerPose.__member((int)4), OVRTrackerPose.__member((int)OVRPosef.SIZEOF, (int)OVRPosef.ALIGNOF), OVRTrackerPose.__member((int)OVRPosef.SIZEOF, (int)OVRPosef.ALIGNOF), OVRTrackerPose.__padding((int)4, (boolean)true)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TRACKERFLAGS = layout.offsetof(0);
        POSE = layout.offsetof(1);
        LEVELEDPOSE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRTrackerPose, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRTrackerPose newInstance(long address) {
            return new OVRTrackerPose(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="unsigned int")
        public int TrackerFlags() {
            return OVRTrackerPose.nTrackerFlags(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef Pose() {
            return OVRTrackerPose.nPose(this.address());
        }

        public Buffer Pose(Consumer<OVRPosef> consumer) {
            consumer.accept(this.Pose());
            return this;
        }

        @NativeType(value="ovrPosef")
        public OVRPosef LeveledPose() {
            return OVRTrackerPose.nLeveledPose(this.address());
        }

        public Buffer LeveledPose(Consumer<OVRPosef> consumer) {
            consumer.accept(this.LeveledPose());
            return this;
        }
    }
}

