/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrTouchHapticsDesc")
public class OVRTouchHapticsDesc
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLERATEHZ;
    public static final int SAMPLESIZEINBYTES;
    public static final int QUEUEMINSIZETOAVOIDSTARVATION;
    public static final int SUBMITMINSAMPLES;
    public static final int SUBMITMAXSAMPLES;
    public static final int SUBMITOPTIMALSAMPLES;

    OVRTouchHapticsDesc(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRTouchHapticsDesc(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRTouchHapticsDesc.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int SampleRateHz() {
        return OVRTouchHapticsDesc.nSampleRateHz(this.address());
    }

    public int SampleSizeInBytes() {
        return OVRTouchHapticsDesc.nSampleSizeInBytes(this.address());
    }

    public int QueueMinSizeToAvoidStarvation() {
        return OVRTouchHapticsDesc.nQueueMinSizeToAvoidStarvation(this.address());
    }

    public int SubmitMinSamples() {
        return OVRTouchHapticsDesc.nSubmitMinSamples(this.address());
    }

    public int SubmitMaxSamples() {
        return OVRTouchHapticsDesc.nSubmitMaxSamples(this.address());
    }

    public int SubmitOptimalSamples() {
        return OVRTouchHapticsDesc.nSubmitOptimalSamples(this.address());
    }

    public static OVRTouchHapticsDesc malloc() {
        return OVRTouchHapticsDesc.create(MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRTouchHapticsDesc calloc() {
        return OVRTouchHapticsDesc.create(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRTouchHapticsDesc create() {
        return new OVRTouchHapticsDesc(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRTouchHapticsDesc create(long address) {
        return new OVRTouchHapticsDesc(address, null);
    }

    @Nullable
    public static OVRTouchHapticsDesc createSafe(long address) {
        return address == 0L ? null : OVRTouchHapticsDesc.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRTouchHapticsDesc.create(OVRTouchHapticsDesc.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRTouchHapticsDesc.create(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRTouchHapticsDesc.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRTouchHapticsDesc.create(address, capacity);
    }

    public static OVRTouchHapticsDesc mallocStack() {
        return OVRTouchHapticsDesc.mallocStack(MemoryStack.stackGet());
    }

    public static OVRTouchHapticsDesc callocStack() {
        return OVRTouchHapticsDesc.callocStack(MemoryStack.stackGet());
    }

    public static OVRTouchHapticsDesc mallocStack(MemoryStack stack) {
        return OVRTouchHapticsDesc.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRTouchHapticsDesc callocStack(MemoryStack stack) {
        return OVRTouchHapticsDesc.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRTouchHapticsDesc.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRTouchHapticsDesc.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRTouchHapticsDesc.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRTouchHapticsDesc.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nSampleRateHz(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SAMPLERATEHZ));
    }

    public static int nSampleSizeInBytes(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SAMPLESIZEINBYTES));
    }

    public static int nQueueMinSizeToAvoidStarvation(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)QUEUEMINSIZETOAVOIDSTARVATION));
    }

    public static int nSubmitMinSamples(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SUBMITMINSAMPLES));
    }

    public static int nSubmitMaxSamples(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SUBMITMAXSAMPLES));
    }

    public static int nSubmitOptimalSamples(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SUBMITOPTIMALSAMPLES));
    }

    static {
        Struct.Layout layout = OVRTouchHapticsDesc.__struct((Struct.Member[])new Struct.Member[]{OVRTouchHapticsDesc.__member((int)4), OVRTouchHapticsDesc.__member((int)4), OVRTouchHapticsDesc.__member((int)4), OVRTouchHapticsDesc.__member((int)4), OVRTouchHapticsDesc.__member((int)4), OVRTouchHapticsDesc.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLERATEHZ = layout.offsetof(0);
        SAMPLESIZEINBYTES = layout.offsetof(1);
        QUEUEMINSIZETOAVOIDSTARVATION = layout.offsetof(2);
        SUBMITMINSAMPLES = layout.offsetof(3);
        SUBMITMAXSAMPLES = layout.offsetof(4);
        SUBMITOPTIMALSAMPLES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<OVRTouchHapticsDesc, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRTouchHapticsDesc newInstance(long address) {
            return new OVRTouchHapticsDesc(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        public int SampleRateHz() {
            return OVRTouchHapticsDesc.nSampleRateHz(this.address());
        }

        public int SampleSizeInBytes() {
            return OVRTouchHapticsDesc.nSampleSizeInBytes(this.address());
        }

        public int QueueMinSizeToAvoidStarvation() {
            return OVRTouchHapticsDesc.nQueueMinSizeToAvoidStarvation(this.address());
        }

        public int SubmitMinSamples() {
            return OVRTouchHapticsDesc.nSubmitMinSamples(this.address());
        }

        public int SubmitMaxSamples() {
            return OVRTouchHapticsDesc.nSubmitMaxSamples(this.address());
        }

        public int SubmitOptimalSamples() {
            return OVRTouchHapticsDesc.nSubmitOptimalSamples(this.address());
        }
    }
}

