/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRQuatf;
import org.lwjgl.ovr.OVRVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrPosef")
public class OVRPosef
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ORIENTATION;
    public static final int POSITION;

    OVRPosef(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRPosef(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRPosef.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrQuatf")
    public OVRQuatf Orientation() {
        return OVRPosef.nOrientation(this.address());
    }

    public OVRPosef Orientation(Consumer<OVRQuatf> consumer) {
        consumer.accept(this.Orientation());
        return this;
    }

    @NativeType(value="ovrVector3f")
    public OVRVector3f Position() {
        return OVRPosef.nPosition(this.address());
    }

    public OVRPosef Position(Consumer<OVRVector3f> consumer) {
        consumer.accept(this.Position());
        return this;
    }

    public OVRPosef Orientation(@NativeType(value="ovrQuatf") OVRQuatf value) {
        OVRPosef.nOrientation(this.address(), value);
        return this;
    }

    public OVRPosef Position(@NativeType(value="ovrVector3f") OVRVector3f value) {
        OVRPosef.nPosition(this.address(), value);
        return this;
    }

    public OVRPosef set(OVRQuatf Orientation, OVRVector3f Position) {
        this.Orientation(Orientation);
        this.Position(Position);
        return this;
    }

    public OVRPosef set(OVRPosef src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRPosef malloc() {
        return OVRPosef.create(MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRPosef calloc() {
        return OVRPosef.create(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRPosef create() {
        return new OVRPosef(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRPosef create(long address) {
        return new OVRPosef(address, null);
    }

    @Nullable
    public static OVRPosef createSafe(long address) {
        return address == 0L ? null : OVRPosef.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRPosef.create(OVRPosef.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRPosef.create(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRPosef.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRPosef.create(address, capacity);
    }

    public static OVRPosef mallocStack() {
        return OVRPosef.mallocStack(MemoryStack.stackGet());
    }

    public static OVRPosef callocStack() {
        return OVRPosef.callocStack(MemoryStack.stackGet());
    }

    public static OVRPosef mallocStack(MemoryStack stack) {
        return OVRPosef.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRPosef callocStack(MemoryStack stack) {
        return OVRPosef.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRPosef.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRPosef.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRPosef.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRPosef.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRQuatf nOrientation(long struct) {
        return OVRQuatf.create(struct + (long)ORIENTATION);
    }

    public static OVRVector3f nPosition(long struct) {
        return OVRVector3f.create(struct + (long)POSITION);
    }

    public static void nOrientation(long struct, OVRQuatf value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ORIENTATION), (long)OVRQuatf.SIZEOF);
    }

    public static void nPosition(long struct, OVRVector3f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSITION), (long)OVRVector3f.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRPosef.__struct((Struct.Member[])new Struct.Member[]{OVRPosef.__member((int)OVRQuatf.SIZEOF, (int)OVRQuatf.ALIGNOF), OVRPosef.__member((int)OVRVector3f.SIZEOF, (int)OVRVector3f.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ORIENTATION = layout.offsetof(0);
        POSITION = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRPosef, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRPosef newInstance(long address) {
            return new OVRPosef(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrQuatf")
        public OVRQuatf Orientation() {
            return OVRPosef.nOrientation(this.address());
        }

        public Buffer Orientation(Consumer<OVRQuatf> consumer) {
            consumer.accept(this.Orientation());
            return this;
        }

        @NativeType(value="ovrVector3f")
        public OVRVector3f Position() {
            return OVRPosef.nPosition(this.address());
        }

        public Buffer Position(Consumer<OVRVector3f> consumer) {
            consumer.accept(this.Position());
            return this;
        }

        public Buffer Orientation(@NativeType(value="ovrQuatf") OVRQuatf value) {
            OVRPosef.nOrientation(this.address(), value);
            return this;
        }

        public Buffer Position(@NativeType(value="ovrVector3f") OVRVector3f value) {
            OVRPosef.nPosition(this.address(), value);
            return this;
        }
    }
}

