/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRPerfStatsPerCompositorFrame;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrPerfStats")
public class OVRPerfStats
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FRAMESTATS;
    public static final int FRAMESTATSCOUNT;
    public static final int ANYFRAMESTATSDROPPED;
    public static final int ADAPTIVEGPUPERFORMANCESCALE;
    public static final int ASWISAVAILABLE;
    public static final int VISIBLEPROCESSID;

    OVRPerfStats(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRPerfStats(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRPerfStats.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrPerfStatsPerCompositorFrame[ovrMaxProvidedFrameStats]")
    public OVRPerfStatsPerCompositorFrame.Buffer FrameStats() {
        return OVRPerfStats.nFrameStats(this.address());
    }

    @NativeType(value="ovrPerfStatsPerCompositorFrame")
    public OVRPerfStatsPerCompositorFrame FrameStats(int index) {
        return OVRPerfStats.nFrameStats(this.address(), index);
    }

    public int FrameStatsCount() {
        return OVRPerfStats.nFrameStatsCount(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean AnyFrameStatsDropped() {
        return OVRPerfStats.nAnyFrameStatsDropped(this.address());
    }

    public float AdaptiveGpuPerformanceScale() {
        return OVRPerfStats.nAdaptiveGpuPerformanceScale(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean AswIsAvailable() {
        return OVRPerfStats.nAswIsAvailable(this.address());
    }

    @NativeType(value="ovrProcessId")
    public int VisibleProcessId() {
        return OVRPerfStats.nVisibleProcessId(this.address());
    }

    public static OVRPerfStats malloc() {
        return OVRPerfStats.create(MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRPerfStats calloc() {
        return OVRPerfStats.create(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRPerfStats create() {
        return new OVRPerfStats(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRPerfStats create(long address) {
        return new OVRPerfStats(address, null);
    }

    @Nullable
    public static OVRPerfStats createSafe(long address) {
        return address == 0L ? null : OVRPerfStats.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRPerfStats.create(OVRPerfStats.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRPerfStats.create(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRPerfStats.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRPerfStats.create(address, capacity);
    }

    public static OVRPerfStats mallocStack() {
        return OVRPerfStats.mallocStack(MemoryStack.stackGet());
    }

    public static OVRPerfStats callocStack() {
        return OVRPerfStats.callocStack(MemoryStack.stackGet());
    }

    public static OVRPerfStats mallocStack(MemoryStack stack) {
        return OVRPerfStats.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRPerfStats callocStack(MemoryStack stack) {
        return OVRPerfStats.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRPerfStats.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRPerfStats.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRPerfStats.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRPerfStats.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRPerfStatsPerCompositorFrame.Buffer nFrameStats(long struct) {
        return OVRPerfStatsPerCompositorFrame.create(struct + (long)FRAMESTATS, OVRPerfStats.nFrameStatsCount(struct));
    }

    public static OVRPerfStatsPerCompositorFrame nFrameStats(long struct, int index) {
        return OVRPerfStatsPerCompositorFrame.create(struct + (long)FRAMESTATS + Checks.check((int)index, (int)OVRPerfStats.nFrameStatsCount(struct)) * (long)OVRPerfStatsPerCompositorFrame.SIZEOF);
    }

    public static int nFrameStatsCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FRAMESTATSCOUNT));
    }

    public static boolean nAnyFrameStatsDropped(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)ANYFRAMESTATSDROPPED)) != 0;
    }

    public static float nAdaptiveGpuPerformanceScale(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)ADAPTIVEGPUPERFORMANCESCALE));
    }

    public static boolean nAswIsAvailable(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)ASWISAVAILABLE)) != 0;
    }

    public static int nVisibleProcessId(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)VISIBLEPROCESSID));
    }

    static {
        Struct.Layout layout = OVRPerfStats.__struct((Struct.Member[])new Struct.Member[]{OVRPerfStats.__array((int)OVRPerfStatsPerCompositorFrame.SIZEOF, (int)OVRPerfStatsPerCompositorFrame.ALIGNOF, (int)5), OVRPerfStats.__member((int)4), OVRPerfStats.__member((int)1), OVRPerfStats.__member((int)4), OVRPerfStats.__member((int)1), OVRPerfStats.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FRAMESTATS = layout.offsetof(0);
        FRAMESTATSCOUNT = layout.offsetof(1);
        ANYFRAMESTATSDROPPED = layout.offsetof(2);
        ADAPTIVEGPUPERFORMANCESCALE = layout.offsetof(3);
        ASWISAVAILABLE = layout.offsetof(4);
        VISIBLEPROCESSID = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<OVRPerfStats, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRPerfStats newInstance(long address) {
            return new OVRPerfStats(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrPerfStatsPerCompositorFrame[ovrMaxProvidedFrameStats]")
        public OVRPerfStatsPerCompositorFrame.Buffer FrameStats() {
            return OVRPerfStats.nFrameStats(this.address());
        }

        @NativeType(value="ovrPerfStatsPerCompositorFrame")
        public OVRPerfStatsPerCompositorFrame FrameStats(int index) {
            return OVRPerfStats.nFrameStats(this.address(), index);
        }

        public int FrameStatsCount() {
            return OVRPerfStats.nFrameStatsCount(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean AnyFrameStatsDropped() {
            return OVRPerfStats.nAnyFrameStatsDropped(this.address());
        }

        public float AdaptiveGpuPerformanceScale() {
            return OVRPerfStats.nAdaptiveGpuPerformanceScale(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean AswIsAvailable() {
            return OVRPerfStats.nAswIsAvailable(this.address());
        }

        @NativeType(value="ovrProcessId")
        public int VisibleProcessId() {
            return OVRPerfStats.nVisibleProcessId(this.address());
        }
    }
}

