/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRLayerCube;
import org.lwjgl.ovr.OVRLayerCylinder;
import org.lwjgl.ovr.OVRLayerEyeFov;
import org.lwjgl.ovr.OVRLayerEyeFovDepth;
import org.lwjgl.ovr.OVRLayerEyeFovMultires;
import org.lwjgl.ovr.OVRLayerEyeMatrix;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRLayerQuad;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="union ovrLayer_Union")
public class OVRLayerUnion
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADER;
    public static final int EYEFOV;
    public static final int EYEFOVDEPTH;
    public static final int EYEMATRIX;
    public static final int MULTIRES;
    public static final int CYLINDER;
    public static final int CUBE;
    public static final int QUAD;

    OVRLayerUnion(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRLayerUnion(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRLayerUnion.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrLayerHeader")
    public OVRLayerHeader Header() {
        return OVRLayerUnion.nHeader(this.address());
    }

    public OVRLayerUnion Header(Consumer<OVRLayerHeader> consumer) {
        consumer.accept(this.Header());
        return this;
    }

    @NativeType(value="ovrLayerEyeFov")
    public OVRLayerEyeFov EyeFov() {
        return OVRLayerUnion.nEyeFov(this.address());
    }

    public OVRLayerUnion EyeFov(Consumer<OVRLayerEyeFov> consumer) {
        consumer.accept(this.EyeFov());
        return this;
    }

    @NativeType(value="ovrLayerEyeFovDepth")
    public OVRLayerEyeFovDepth EyeFovDepth() {
        return OVRLayerUnion.nEyeFovDepth(this.address());
    }

    public OVRLayerUnion EyeFovDepth(Consumer<OVRLayerEyeFovDepth> consumer) {
        consumer.accept(this.EyeFovDepth());
        return this;
    }

    @NativeType(value="ovrLayerEyeMatrix")
    public OVRLayerEyeMatrix EyeMatrix() {
        return OVRLayerUnion.nEyeMatrix(this.address());
    }

    public OVRLayerUnion EyeMatrix(Consumer<OVRLayerEyeMatrix> consumer) {
        consumer.accept(this.EyeMatrix());
        return this;
    }

    @NativeType(value="ovrLayerEyeFovMultires")
    public OVRLayerEyeFovMultires Multires() {
        return OVRLayerUnion.nMultires(this.address());
    }

    public OVRLayerUnion Multires(Consumer<OVRLayerEyeFovMultires> consumer) {
        consumer.accept(this.Multires());
        return this;
    }

    @NativeType(value="ovrLayerCylinder")
    public OVRLayerCylinder Cylinder() {
        return OVRLayerUnion.nCylinder(this.address());
    }

    public OVRLayerUnion Cylinder(Consumer<OVRLayerCylinder> consumer) {
        consumer.accept(this.Cylinder());
        return this;
    }

    @NativeType(value="ovrLayerCube")
    public OVRLayerCube Cube() {
        return OVRLayerUnion.nCube(this.address());
    }

    public OVRLayerUnion Cube(Consumer<OVRLayerCube> consumer) {
        consumer.accept(this.Cube());
        return this;
    }

    @NativeType(value="ovrLayerQuad")
    public OVRLayerQuad Quad() {
        return OVRLayerUnion.nQuad(this.address());
    }

    public OVRLayerUnion Quad(Consumer<OVRLayerQuad> consumer) {
        consumer.accept(this.Quad());
        return this;
    }

    public OVRLayerUnion Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
        OVRLayerUnion.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerUnion EyeFov(@NativeType(value="ovrLayerEyeFov") OVRLayerEyeFov value) {
        OVRLayerUnion.nEyeFov(this.address(), value);
        return this;
    }

    public OVRLayerUnion EyeFovDepth(@NativeType(value="ovrLayerEyeFovDepth") OVRLayerEyeFovDepth value) {
        OVRLayerUnion.nEyeFovDepth(this.address(), value);
        return this;
    }

    public OVRLayerUnion EyeMatrix(@NativeType(value="ovrLayerEyeMatrix") OVRLayerEyeMatrix value) {
        OVRLayerUnion.nEyeMatrix(this.address(), value);
        return this;
    }

    public OVRLayerUnion Multires(@NativeType(value="ovrLayerEyeFovMultires") OVRLayerEyeFovMultires value) {
        OVRLayerUnion.nMultires(this.address(), value);
        return this;
    }

    public OVRLayerUnion Cylinder(@NativeType(value="ovrLayerCylinder") OVRLayerCylinder value) {
        OVRLayerUnion.nCylinder(this.address(), value);
        return this;
    }

    public OVRLayerUnion Cube(@NativeType(value="ovrLayerCube") OVRLayerCube value) {
        OVRLayerUnion.nCube(this.address(), value);
        return this;
    }

    public OVRLayerUnion Quad(@NativeType(value="ovrLayerQuad") OVRLayerQuad value) {
        OVRLayerUnion.nQuad(this.address(), value);
        return this;
    }

    public OVRLayerUnion set(OVRLayerUnion src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRLayerUnion malloc() {
        return OVRLayerUnion.create(MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRLayerUnion calloc() {
        return OVRLayerUnion.create(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRLayerUnion create() {
        return new OVRLayerUnion(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRLayerUnion create(long address) {
        return new OVRLayerUnion(address, null);
    }

    @Nullable
    public static OVRLayerUnion createSafe(long address) {
        return address == 0L ? null : OVRLayerUnion.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRLayerUnion.create(OVRLayerUnion.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRLayerUnion.create(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRLayerUnion.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRLayerUnion.create(address, capacity);
    }

    public static OVRLayerUnion mallocStack() {
        return OVRLayerUnion.mallocStack(MemoryStack.stackGet());
    }

    public static OVRLayerUnion callocStack() {
        return OVRLayerUnion.callocStack(MemoryStack.stackGet());
    }

    public static OVRLayerUnion mallocStack(MemoryStack stack) {
        return OVRLayerUnion.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRLayerUnion callocStack(MemoryStack stack) {
        return OVRLayerUnion.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRLayerUnion.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRLayerUnion.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerUnion.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerUnion.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return OVRLayerHeader.create(struct + (long)HEADER);
    }

    public static OVRLayerEyeFov nEyeFov(long struct) {
        return OVRLayerEyeFov.create(struct + (long)EYEFOV);
    }

    public static OVRLayerEyeFovDepth nEyeFovDepth(long struct) {
        return OVRLayerEyeFovDepth.create(struct + (long)EYEFOVDEPTH);
    }

    public static OVRLayerEyeMatrix nEyeMatrix(long struct) {
        return OVRLayerEyeMatrix.create(struct + (long)EYEMATRIX);
    }

    public static OVRLayerEyeFovMultires nMultires(long struct) {
        return OVRLayerEyeFovMultires.create(struct + (long)MULTIRES);
    }

    public static OVRLayerCylinder nCylinder(long struct) {
        return OVRLayerCylinder.create(struct + (long)CYLINDER);
    }

    public static OVRLayerCube nCube(long struct) {
        return OVRLayerCube.create(struct + (long)CUBE);
    }

    public static OVRLayerQuad nQuad(long struct) {
        return OVRLayerQuad.create(struct + (long)QUAD);
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HEADER), (long)OVRLayerHeader.SIZEOF);
    }

    public static void nEyeFov(long struct, OVRLayerEyeFov value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EYEFOV), (long)OVRLayerEyeFov.SIZEOF);
    }

    public static void nEyeFovDepth(long struct, OVRLayerEyeFovDepth value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EYEFOVDEPTH), (long)OVRLayerEyeFovDepth.SIZEOF);
    }

    public static void nEyeMatrix(long struct, OVRLayerEyeMatrix value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EYEMATRIX), (long)OVRLayerEyeMatrix.SIZEOF);
    }

    public static void nMultires(long struct, OVRLayerEyeFovMultires value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MULTIRES), (long)OVRLayerEyeFovMultires.SIZEOF);
    }

    public static void nCylinder(long struct, OVRLayerCylinder value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CYLINDER), (long)OVRLayerCylinder.SIZEOF);
    }

    public static void nCube(long struct, OVRLayerCube value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CUBE), (long)OVRLayerCube.SIZEOF);
    }

    public static void nQuad(long struct, OVRLayerQuad value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)QUAD), (long)OVRLayerQuad.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRLayerUnion.__union((Struct.Member[])new Struct.Member[]{OVRLayerUnion.__member((int)OVRLayerHeader.SIZEOF, (int)OVRLayerHeader.ALIGNOF), OVRLayerUnion.__member((int)OVRLayerEyeFov.SIZEOF, (int)OVRLayerEyeFov.ALIGNOF), OVRLayerUnion.__member((int)OVRLayerEyeFovDepth.SIZEOF, (int)OVRLayerEyeFovDepth.ALIGNOF), OVRLayerUnion.__member((int)OVRLayerEyeMatrix.SIZEOF, (int)OVRLayerEyeMatrix.ALIGNOF), OVRLayerUnion.__member((int)OVRLayerEyeFovMultires.SIZEOF, (int)OVRLayerEyeFovMultires.ALIGNOF), OVRLayerUnion.__member((int)OVRLayerCylinder.SIZEOF, (int)OVRLayerCylinder.ALIGNOF), OVRLayerUnion.__member((int)OVRLayerCube.SIZEOF, (int)OVRLayerCube.ALIGNOF), OVRLayerUnion.__member((int)OVRLayerQuad.SIZEOF, (int)OVRLayerQuad.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADER = layout.offsetof(0);
        EYEFOV = layout.offsetof(1);
        EYEFOVDEPTH = layout.offsetof(2);
        EYEMATRIX = layout.offsetof(3);
        MULTIRES = layout.offsetof(4);
        CYLINDER = layout.offsetof(5);
        CUBE = layout.offsetof(6);
        QUAD = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerUnion, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRLayerUnion newInstance(long address) {
            return new OVRLayerUnion(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrLayerHeader")
        public OVRLayerHeader Header() {
            return OVRLayerUnion.nHeader(this.address());
        }

        public Buffer Header(Consumer<OVRLayerHeader> consumer) {
            consumer.accept(this.Header());
            return this;
        }

        @NativeType(value="ovrLayerEyeFov")
        public OVRLayerEyeFov EyeFov() {
            return OVRLayerUnion.nEyeFov(this.address());
        }

        public Buffer EyeFov(Consumer<OVRLayerEyeFov> consumer) {
            consumer.accept(this.EyeFov());
            return this;
        }

        @NativeType(value="ovrLayerEyeFovDepth")
        public OVRLayerEyeFovDepth EyeFovDepth() {
            return OVRLayerUnion.nEyeFovDepth(this.address());
        }

        public Buffer EyeFovDepth(Consumer<OVRLayerEyeFovDepth> consumer) {
            consumer.accept(this.EyeFovDepth());
            return this;
        }

        @NativeType(value="ovrLayerEyeMatrix")
        public OVRLayerEyeMatrix EyeMatrix() {
            return OVRLayerUnion.nEyeMatrix(this.address());
        }

        public Buffer EyeMatrix(Consumer<OVRLayerEyeMatrix> consumer) {
            consumer.accept(this.EyeMatrix());
            return this;
        }

        @NativeType(value="ovrLayerEyeFovMultires")
        public OVRLayerEyeFovMultires Multires() {
            return OVRLayerUnion.nMultires(this.address());
        }

        public Buffer Multires(Consumer<OVRLayerEyeFovMultires> consumer) {
            consumer.accept(this.Multires());
            return this;
        }

        @NativeType(value="ovrLayerCylinder")
        public OVRLayerCylinder Cylinder() {
            return OVRLayerUnion.nCylinder(this.address());
        }

        public Buffer Cylinder(Consumer<OVRLayerCylinder> consumer) {
            consumer.accept(this.Cylinder());
            return this;
        }

        @NativeType(value="ovrLayerCube")
        public OVRLayerCube Cube() {
            return OVRLayerUnion.nCube(this.address());
        }

        public Buffer Cube(Consumer<OVRLayerCube> consumer) {
            consumer.accept(this.Cube());
            return this;
        }

        @NativeType(value="ovrLayerQuad")
        public OVRLayerQuad Quad() {
            return OVRLayerUnion.nQuad(this.address());
        }

        public Buffer Quad(Consumer<OVRLayerQuad> consumer) {
            consumer.accept(this.Quad());
            return this;
        }

        public Buffer Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
            OVRLayerUnion.nHeader(this.address(), value);
            return this;
        }

        public Buffer EyeFov(@NativeType(value="ovrLayerEyeFov") OVRLayerEyeFov value) {
            OVRLayerUnion.nEyeFov(this.address(), value);
            return this;
        }

        public Buffer EyeFovDepth(@NativeType(value="ovrLayerEyeFovDepth") OVRLayerEyeFovDepth value) {
            OVRLayerUnion.nEyeFovDepth(this.address(), value);
            return this;
        }

        public Buffer EyeMatrix(@NativeType(value="ovrLayerEyeMatrix") OVRLayerEyeMatrix value) {
            OVRLayerUnion.nEyeMatrix(this.address(), value);
            return this;
        }

        public Buffer Multires(@NativeType(value="ovrLayerEyeFovMultires") OVRLayerEyeFovMultires value) {
            OVRLayerUnion.nMultires(this.address(), value);
            return this;
        }

        public Buffer Cylinder(@NativeType(value="ovrLayerCylinder") OVRLayerCylinder value) {
            OVRLayerUnion.nCylinder(this.address(), value);
            return this;
        }

        public Buffer Cube(@NativeType(value="ovrLayerCube") OVRLayerCube value) {
            OVRLayerUnion.nCube(this.address(), value);
            return this;
        }

        public Buffer Quad(@NativeType(value="ovrLayerQuad") OVRLayerQuad value) {
            OVRLayerUnion.nQuad(this.address(), value);
            return this;
        }
    }
}

