/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRRecti;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrLayerEyeFov")
public class OVRLayerEyeFov
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADER;
    public static final int COLORTEXTURE;
    public static final int VIEWPORT;
    public static final int FOV;
    public static final int RENDERPOSE;
    public static final int SENSORSAMPLETIME;

    OVRLayerEyeFov(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRLayerEyeFov(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRLayerEyeFov.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrLayerHeader")
    public OVRLayerHeader Header() {
        return OVRLayerEyeFov.nHeader(this.address());
    }

    public OVRLayerEyeFov Header(Consumer<OVRLayerHeader> consumer) {
        consumer.accept(this.Header());
        return this;
    }

    @NativeType(value="ovrTextureSwapChain[ovrEye_Count]")
    public PointerBuffer ColorTexture() {
        return OVRLayerEyeFov.nColorTexture(this.address());
    }

    @NativeType(value="ovrTextureSwapChain")
    public long ColorTexture(int index) {
        return OVRLayerEyeFov.nColorTexture(this.address(), index);
    }

    @NativeType(value="ovrRecti[ovrEye_Count]")
    public OVRRecti.Buffer Viewport() {
        return OVRLayerEyeFov.nViewport(this.address());
    }

    @NativeType(value="ovrRecti")
    public OVRRecti Viewport(int index) {
        return OVRLayerEyeFov.nViewport(this.address(), index);
    }

    @NativeType(value="ovrFovPort[ovrEye_Count]")
    public OVRFovPort.Buffer Fov() {
        return OVRLayerEyeFov.nFov(this.address());
    }

    @NativeType(value="ovrFovPort")
    public OVRFovPort Fov(int index) {
        return OVRLayerEyeFov.nFov(this.address(), index);
    }

    @NativeType(value="ovrPosef[ovrEye_Count]")
    public OVRPosef.Buffer RenderPose() {
        return OVRLayerEyeFov.nRenderPose(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef RenderPose(int index) {
        return OVRLayerEyeFov.nRenderPose(this.address(), index);
    }

    public double SensorSampleTime() {
        return OVRLayerEyeFov.nSensorSampleTime(this.address());
    }

    public OVRLayerEyeFov Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
        OVRLayerEyeFov.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerEyeFov ColorTexture(@NativeType(value="ovrTextureSwapChain[ovrEye_Count]") PointerBuffer value) {
        OVRLayerEyeFov.nColorTexture(this.address(), value);
        return this;
    }

    public OVRLayerEyeFov ColorTexture(int index, @NativeType(value="ovrTextureSwapChain") long value) {
        OVRLayerEyeFov.nColorTexture(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFov Viewport(@NativeType(value="ovrRecti[ovrEye_Count]") OVRRecti.Buffer value) {
        OVRLayerEyeFov.nViewport(this.address(), value);
        return this;
    }

    public OVRLayerEyeFov Viewport(int index, @NativeType(value="ovrRecti") OVRRecti value) {
        OVRLayerEyeFov.nViewport(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFov Fov(@NativeType(value="ovrFovPort[ovrEye_Count]") OVRFovPort.Buffer value) {
        OVRLayerEyeFov.nFov(this.address(), value);
        return this;
    }

    public OVRLayerEyeFov Fov(int index, @NativeType(value="ovrFovPort") OVRFovPort value) {
        OVRLayerEyeFov.nFov(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFov RenderPose(@NativeType(value="ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) {
        OVRLayerEyeFov.nRenderPose(this.address(), value);
        return this;
    }

    public OVRLayerEyeFov RenderPose(int index, @NativeType(value="ovrPosef") OVRPosef value) {
        OVRLayerEyeFov.nRenderPose(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFov SensorSampleTime(double value) {
        OVRLayerEyeFov.nSensorSampleTime(this.address(), value);
        return this;
    }

    public OVRLayerEyeFov set(OVRLayerHeader Header, PointerBuffer ColorTexture, OVRRecti.Buffer Viewport, OVRFovPort.Buffer Fov, OVRPosef.Buffer RenderPose, double SensorSampleTime) {
        this.Header(Header);
        this.ColorTexture(ColorTexture);
        this.Viewport(Viewport);
        this.Fov(Fov);
        this.RenderPose(RenderPose);
        this.SensorSampleTime(SensorSampleTime);
        return this;
    }

    public OVRLayerEyeFov set(OVRLayerEyeFov src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRLayerEyeFov malloc() {
        return OVRLayerEyeFov.create(MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRLayerEyeFov calloc() {
        return OVRLayerEyeFov.create(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRLayerEyeFov create() {
        return new OVRLayerEyeFov(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRLayerEyeFov create(long address) {
        return new OVRLayerEyeFov(address, null);
    }

    @Nullable
    public static OVRLayerEyeFov createSafe(long address) {
        return address == 0L ? null : OVRLayerEyeFov.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRLayerEyeFov.create(OVRLayerEyeFov.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRLayerEyeFov.create(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRLayerEyeFov.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRLayerEyeFov.create(address, capacity);
    }

    public static OVRLayerEyeFov mallocStack() {
        return OVRLayerEyeFov.mallocStack(MemoryStack.stackGet());
    }

    public static OVRLayerEyeFov callocStack() {
        return OVRLayerEyeFov.callocStack(MemoryStack.stackGet());
    }

    public static OVRLayerEyeFov mallocStack(MemoryStack stack) {
        return OVRLayerEyeFov.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRLayerEyeFov callocStack(MemoryStack stack) {
        return OVRLayerEyeFov.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRLayerEyeFov.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRLayerEyeFov.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerEyeFov.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerEyeFov.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return OVRLayerHeader.create(struct + (long)HEADER);
    }

    public static PointerBuffer nColorTexture(long struct) {
        return MemoryUtil.memPointerBuffer((long)(struct + (long)COLORTEXTURE), (int)2);
    }

    public static long nColorTexture(long struct, int index) {
        return MemoryUtil.memGetAddress((long)(struct + (long)COLORTEXTURE + Checks.check((int)index, (int)2) * (long)POINTER_SIZE));
    }

    public static OVRRecti.Buffer nViewport(long struct) {
        return OVRRecti.create(struct + (long)VIEWPORT, 2);
    }

    public static OVRRecti nViewport(long struct, int index) {
        return OVRRecti.create(struct + (long)VIEWPORT + Checks.check((int)index, (int)2) * (long)OVRRecti.SIZEOF);
    }

    public static OVRFovPort.Buffer nFov(long struct) {
        return OVRFovPort.create(struct + (long)FOV, 2);
    }

    public static OVRFovPort nFov(long struct, int index) {
        return OVRFovPort.create(struct + (long)FOV + Checks.check((int)index, (int)2) * (long)OVRFovPort.SIZEOF);
    }

    public static OVRPosef.Buffer nRenderPose(long struct) {
        return OVRPosef.create(struct + (long)RENDERPOSE, 2);
    }

    public static OVRPosef nRenderPose(long struct, int index) {
        return OVRPosef.create(struct + (long)RENDERPOSE + Checks.check((int)index, (int)2) * (long)OVRPosef.SIZEOF);
    }

    public static double nSensorSampleTime(long struct) {
        return MemoryUtil.memGetDouble((long)(struct + (long)SENSORSAMPLETIME));
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HEADER), (long)OVRLayerHeader.SIZEOF);
    }

    public static void nColorTexture(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((CustomBuffer)value), (long)(struct + (long)COLORTEXTURE), (long)(value.remaining() * POINTER_SIZE));
    }

    public static void nColorTexture(long struct, int index, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)COLORTEXTURE + Checks.check((int)index, (int)2) * (long)POINTER_SIZE), (long)value);
    }

    public static void nViewport(long struct, OVRRecti.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VIEWPORT), (long)(value.remaining() * OVRRecti.SIZEOF));
    }

    public static void nViewport(long struct, int index, OVRRecti value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VIEWPORT + Checks.check((int)index, (int)2) * (long)OVRRecti.SIZEOF), (long)OVRRecti.SIZEOF);
    }

    public static void nFov(long struct, OVRFovPort.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FOV), (long)(value.remaining() * OVRFovPort.SIZEOF));
    }

    public static void nFov(long struct, int index, OVRFovPort value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FOV + Checks.check((int)index, (int)2) * (long)OVRFovPort.SIZEOF), (long)OVRFovPort.SIZEOF);
    }

    public static void nRenderPose(long struct, OVRPosef.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RENDERPOSE), (long)(value.remaining() * OVRPosef.SIZEOF));
    }

    public static void nRenderPose(long struct, int index, OVRPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RENDERPOSE + Checks.check((int)index, (int)2) * (long)OVRPosef.SIZEOF), (long)OVRPosef.SIZEOF);
    }

    public static void nSensorSampleTime(long struct, double value) {
        MemoryUtil.memPutDouble((long)(struct + (long)SENSORSAMPLETIME), (double)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)COLORTEXTURE)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            OVRLayerEyeFov.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = OVRLayerEyeFov.__struct((Struct.Member[])new Struct.Member[]{OVRLayerEyeFov.__member((int)OVRLayerHeader.SIZEOF, (int)OVRLayerHeader.ALIGNOF), OVRLayerEyeFov.__array((int)POINTER_SIZE, (int)2), OVRLayerEyeFov.__array((int)OVRRecti.SIZEOF, (int)OVRRecti.ALIGNOF, (int)2), OVRLayerEyeFov.__array((int)OVRFovPort.SIZEOF, (int)OVRFovPort.ALIGNOF, (int)2), OVRLayerEyeFov.__array((int)OVRPosef.SIZEOF, (int)OVRPosef.ALIGNOF, (int)2), OVRLayerEyeFov.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADER = layout.offsetof(0);
        COLORTEXTURE = layout.offsetof(1);
        VIEWPORT = layout.offsetof(2);
        FOV = layout.offsetof(3);
        RENDERPOSE = layout.offsetof(4);
        SENSORSAMPLETIME = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerEyeFov, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRLayerEyeFov newInstance(long address) {
            return new OVRLayerEyeFov(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrLayerHeader")
        public OVRLayerHeader Header() {
            return OVRLayerEyeFov.nHeader(this.address());
        }

        public Buffer Header(Consumer<OVRLayerHeader> consumer) {
            consumer.accept(this.Header());
            return this;
        }

        @NativeType(value="ovrTextureSwapChain[ovrEye_Count]")
        public PointerBuffer ColorTexture() {
            return OVRLayerEyeFov.nColorTexture(this.address());
        }

        @NativeType(value="ovrTextureSwapChain")
        public long ColorTexture(int index) {
            return OVRLayerEyeFov.nColorTexture(this.address(), index);
        }

        @NativeType(value="ovrRecti[ovrEye_Count]")
        public OVRRecti.Buffer Viewport() {
            return OVRLayerEyeFov.nViewport(this.address());
        }

        @NativeType(value="ovrRecti")
        public OVRRecti Viewport(int index) {
            return OVRLayerEyeFov.nViewport(this.address(), index);
        }

        @NativeType(value="ovrFovPort[ovrEye_Count]")
        public OVRFovPort.Buffer Fov() {
            return OVRLayerEyeFov.nFov(this.address());
        }

        @NativeType(value="ovrFovPort")
        public OVRFovPort Fov(int index) {
            return OVRLayerEyeFov.nFov(this.address(), index);
        }

        @NativeType(value="ovrPosef[ovrEye_Count]")
        public OVRPosef.Buffer RenderPose() {
            return OVRLayerEyeFov.nRenderPose(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef RenderPose(int index) {
            return OVRLayerEyeFov.nRenderPose(this.address(), index);
        }

        public double SensorSampleTime() {
            return OVRLayerEyeFov.nSensorSampleTime(this.address());
        }

        public Buffer Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
            OVRLayerEyeFov.nHeader(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(@NativeType(value="ovrTextureSwapChain[ovrEye_Count]") PointerBuffer value) {
            OVRLayerEyeFov.nColorTexture(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(int index, @NativeType(value="ovrTextureSwapChain") long value) {
            OVRLayerEyeFov.nColorTexture(this.address(), index, value);
            return this;
        }

        public Buffer Viewport(@NativeType(value="ovrRecti[ovrEye_Count]") OVRRecti.Buffer value) {
            OVRLayerEyeFov.nViewport(this.address(), value);
            return this;
        }

        public Buffer Viewport(int index, @NativeType(value="ovrRecti") OVRRecti value) {
            OVRLayerEyeFov.nViewport(this.address(), index, value);
            return this;
        }

        public Buffer Fov(@NativeType(value="ovrFovPort[ovrEye_Count]") OVRFovPort.Buffer value) {
            OVRLayerEyeFov.nFov(this.address(), value);
            return this;
        }

        public Buffer Fov(int index, @NativeType(value="ovrFovPort") OVRFovPort value) {
            OVRLayerEyeFov.nFov(this.address(), index, value);
            return this;
        }

        public Buffer RenderPose(@NativeType(value="ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) {
            OVRLayerEyeFov.nRenderPose(this.address(), value);
            return this;
        }

        public Buffer RenderPose(int index, @NativeType(value="ovrPosef") OVRPosef value) {
            OVRLayerEyeFov.nRenderPose(this.address(), index, value);
            return this;
        }

        public Buffer SensorSampleTime(double value) {
            OVRLayerEyeFov.nSensorSampleTime(this.address(), value);
            return this;
        }
    }
}

