/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrDetectResult")
public class OVRDetectResult
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ISOCULUSSERVICERUNNING;
    public static final int ISOCULUSHMDCONNECTED;

    OVRDetectResult(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRDetectResult(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRDetectResult.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrBool")
    public boolean IsOculusServiceRunning() {
        return OVRDetectResult.nIsOculusServiceRunning(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean IsOculusHMDConnected() {
        return OVRDetectResult.nIsOculusHMDConnected(this.address());
    }

    public static OVRDetectResult malloc() {
        return OVRDetectResult.create(MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRDetectResult calloc() {
        return OVRDetectResult.create(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRDetectResult create() {
        return new OVRDetectResult(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRDetectResult create(long address) {
        return new OVRDetectResult(address, null);
    }

    @Nullable
    public static OVRDetectResult createSafe(long address) {
        return address == 0L ? null : OVRDetectResult.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRDetectResult.create(OVRDetectResult.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRDetectResult.create(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRDetectResult.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRDetectResult.create(address, capacity);
    }

    public static OVRDetectResult mallocStack() {
        return OVRDetectResult.mallocStack(MemoryStack.stackGet());
    }

    public static OVRDetectResult callocStack() {
        return OVRDetectResult.callocStack(MemoryStack.stackGet());
    }

    public static OVRDetectResult mallocStack(MemoryStack stack) {
        return OVRDetectResult.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRDetectResult callocStack(MemoryStack stack) {
        return OVRDetectResult.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRDetectResult.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRDetectResult.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRDetectResult.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRDetectResult.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nIsOculusServiceRunning(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)ISOCULUSSERVICERUNNING)) != 0;
    }

    public static boolean nIsOculusHMDConnected(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)ISOCULUSHMDCONNECTED)) != 0;
    }

    static {
        Struct.Layout layout = OVRDetectResult.__struct((Struct.Member[])new Struct.Member[]{OVRDetectResult.__member((int)1), OVRDetectResult.__member((int)1), OVRDetectResult.__padding((int)6, (boolean)true)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ISOCULUSSERVICERUNNING = layout.offsetof(0);
        ISOCULUSHMDCONNECTED = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRDetectResult, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRDetectResult newInstance(long address) {
            return new OVRDetectResult(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrBool")
        public boolean IsOculusServiceRunning() {
            return OVRDetectResult.nIsOculusServiceRunning(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean IsOculusHMDConnected() {
            return OVRDetectResult.nIsOculusHMDConnected(this.address());
        }
    }
}

