/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrBoundaryTestResult")
public class OVRBoundaryTestResult
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ISTRIGGERING;
    public static final int CLOSESTDISTANCE;
    public static final int CLOSESTPOINT;
    public static final int CLOSESTPOINTNORMAL;

    OVRBoundaryTestResult(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public OVRBoundaryTestResult(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRBoundaryTestResult.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrBool")
    public boolean IsTriggering() {
        return OVRBoundaryTestResult.nIsTriggering(this.address());
    }

    public float ClosestDistance() {
        return OVRBoundaryTestResult.nClosestDistance(this.address());
    }

    @NativeType(value="ovrVector3f")
    public OVRVector3f ClosestPoint() {
        return OVRBoundaryTestResult.nClosestPoint(this.address());
    }

    public OVRBoundaryTestResult ClosestPoint(Consumer<OVRVector3f> consumer) {
        consumer.accept(this.ClosestPoint());
        return this;
    }

    @NativeType(value="ovrVector3f")
    public OVRVector3f ClosestPointNormal() {
        return OVRBoundaryTestResult.nClosestPointNormal(this.address());
    }

    public OVRBoundaryTestResult ClosestPointNormal(Consumer<OVRVector3f> consumer) {
        consumer.accept(this.ClosestPointNormal());
        return this;
    }

    public static OVRBoundaryTestResult malloc() {
        return OVRBoundaryTestResult.create(MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRBoundaryTestResult calloc() {
        return OVRBoundaryTestResult.create(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRBoundaryTestResult create() {
        return new OVRBoundaryTestResult(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRBoundaryTestResult create(long address) {
        return new OVRBoundaryTestResult(address, null);
    }

    @Nullable
    public static OVRBoundaryTestResult createSafe(long address) {
        return address == 0L ? null : OVRBoundaryTestResult.create(address);
    }

    public static Buffer malloc(int capacity) {
        return OVRBoundaryTestResult.create(OVRBoundaryTestResult.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRBoundaryTestResult.create(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRBoundaryTestResult.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OVRBoundaryTestResult.create(address, capacity);
    }

    public static OVRBoundaryTestResult mallocStack() {
        return OVRBoundaryTestResult.mallocStack(MemoryStack.stackGet());
    }

    public static OVRBoundaryTestResult callocStack() {
        return OVRBoundaryTestResult.callocStack(MemoryStack.stackGet());
    }

    public static OVRBoundaryTestResult mallocStack(MemoryStack stack) {
        return OVRBoundaryTestResult.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRBoundaryTestResult callocStack(MemoryStack stack) {
        return OVRBoundaryTestResult.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRBoundaryTestResult.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRBoundaryTestResult.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRBoundaryTestResult.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRBoundaryTestResult.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nIsTriggering(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)ISTRIGGERING)) != 0;
    }

    public static float nClosestDistance(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)CLOSESTDISTANCE));
    }

    public static OVRVector3f nClosestPoint(long struct) {
        return OVRVector3f.create(struct + (long)CLOSESTPOINT);
    }

    public static OVRVector3f nClosestPointNormal(long struct) {
        return OVRVector3f.create(struct + (long)CLOSESTPOINTNORMAL);
    }

    static {
        Struct.Layout layout = OVRBoundaryTestResult.__struct((Struct.Member[])new Struct.Member[]{OVRBoundaryTestResult.__member((int)1), OVRBoundaryTestResult.__member((int)4), OVRBoundaryTestResult.__member((int)OVRVector3f.SIZEOF, (int)OVRVector3f.ALIGNOF), OVRBoundaryTestResult.__member((int)OVRVector3f.SIZEOF, (int)OVRVector3f.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ISTRIGGERING = layout.offsetof(0);
        CLOSESTDISTANCE = layout.offsetof(1);
        CLOSESTPOINT = layout.offsetof(2);
        CLOSESTPOINTNORMAL = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OVRBoundaryTestResult, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRBoundaryTestResult newInstance(long address) {
            return new OVRBoundaryTestResult(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrBool")
        public boolean IsTriggering() {
            return OVRBoundaryTestResult.nIsTriggering(this.address());
        }

        public float ClosestDistance() {
            return OVRBoundaryTestResult.nClosestDistance(this.address());
        }

        @NativeType(value="ovrVector3f")
        public OVRVector3f ClosestPoint() {
            return OVRBoundaryTestResult.nClosestPoint(this.address());
        }

        public Buffer ClosestPoint(Consumer<OVRVector3f> consumer) {
            consumer.accept(this.ClosestPoint());
            return this;
        }

        @NativeType(value="ovrVector3f")
        public OVRVector3f ClosestPointNormal() {
            return OVRBoundaryTestResult.nClosestPointNormal(this.address());
        }

        public Buffer ClosestPointNormal(Consumer<OVRVector3f> consumer) {
            consumer.accept(this.ClosestPointNormal());
            return this;
        }
    }
}

