/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.ovr.LibOVR;
import org.lwjgl.ovr.OVRBoundaryLookAndFeel;
import org.lwjgl.ovr.OVRBoundaryTestResult;
import org.lwjgl.ovr.OVRCameraExtrinsics;
import org.lwjgl.ovr.OVRCameraIntrinsics;
import org.lwjgl.ovr.OVRErrorInfo;
import org.lwjgl.ovr.OVRExternalCamera;
import org.lwjgl.ovr.OVREyeRenderDesc;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRGraphicsLuid;
import org.lwjgl.ovr.OVRHapticsBuffer;
import org.lwjgl.ovr.OVRHapticsPlaybackState;
import org.lwjgl.ovr.OVRHmdDesc;
import org.lwjgl.ovr.OVRInitParams;
import org.lwjgl.ovr.OVRInputState;
import org.lwjgl.ovr.OVRPerfStats;
import org.lwjgl.ovr.OVRPoseStatef;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRSessionStatus;
import org.lwjgl.ovr.OVRSizei;
import org.lwjgl.ovr.OVRTextureSwapChainDesc;
import org.lwjgl.ovr.OVRTouchHapticsDesc;
import org.lwjgl.ovr.OVRTrackerDesc;
import org.lwjgl.ovr.OVRTrackerPose;
import org.lwjgl.ovr.OVRTrackingState;
import org.lwjgl.ovr.OVRVector3f;
import org.lwjgl.ovr.OVRViewScaleDesc;
import org.lwjgl.ovr.OVRViewportStencilDesc;
import org.lwjgl.ovr.OVRViewportStencilMeshBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class OVR {
    public static final int ovrFalse = 0;
    public static final int ovrTrue = 1;
    public static final int ovrInit_Debug = 1;
    public static final int ovrInit_RequestVersion = 4;
    public static final int ovrInit_Invisible = 16;
    public static final int ovrInit_MixedRendering = 32;
    public static final int ovrInit_FocusAware = 64;
    public static final int ovrInit_WritableBits = 0xFFFFFF;
    public static final int ovrLogLevel_Debug = 0;
    public static final int ovrLogLevel_Info = 1;
    public static final int ovrLogLevel_Error = 2;
    public static final int ovrHmd_None = 0;
    public static final int ovrHmd_DK1 = 3;
    public static final int ovrHmd_DKHD = 4;
    public static final int ovrHmd_DK2 = 6;
    public static final int ovrHmd_CB = 8;
    public static final int ovrHmd_Other = 9;
    public static final int ovrHmd_E3_2015 = 10;
    public static final int ovrHmd_ES06 = 11;
    public static final int ovrHmd_ES09 = 12;
    public static final int ovrHmd_ES11 = 13;
    public static final int ovrHmd_CV1 = 14;
    public static final int ovrHmdCap_DebugDevice = 16;
    public static final int ovrTrackingCap_Orientation = 16;
    public static final int ovrTrackingCap_MagYawCorrection = 32;
    public static final int ovrTrackingCap_Position = 64;
    public static final int ovrExtension_TextureLayout_Octilinear = 0;
    public static final int ovrEye_Left = 0;
    public static final int ovrEye_Right = 1;
    public static final int ovrEye_Count = 2;
    public static final int ovrTrackingOrigin_EyeLevel = 0;
    public static final int ovrTrackingOrigin_FloorLevel = 1;
    public static final int ovrStatus_OrientationTracked = 1;
    public static final int ovrStatus_PositionTracked = 2;
    public static final int ovrTracker_Connected = 32;
    public static final int ovrTracker_PoseTracked = 4;
    public static final int ovrTexture_2D = 0;
    public static final int ovrTexture_2D_External = 1;
    public static final int ovrTexture_Cube = 2;
    public static final int ovrTextureBind_None = 0;
    public static final int ovrTextureBind_DX_RenderTarget = 1;
    public static final int ovrTextureBind_DX_UnorderedAccess = 2;
    public static final int ovrTextureBind_DX_DepthStencil = 4;
    public static final int OVR_FORMAT_UNKNOWN = 0;
    public static final int OVR_FORMAT_B5G6R5_UNORM = 1;
    public static final int OVR_FORMAT_B5G5R5A1_UNORM = 2;
    public static final int OVR_FORMAT_B4G4R4A4_UNORM = 3;
    public static final int OVR_FORMAT_R8G8B8A8_UNORM = 4;
    public static final int OVR_FORMAT_R8G8B8A8_UNORM_SRGB = 5;
    public static final int OVR_FORMAT_B8G8R8A8_UNORM = 6;
    public static final int OVR_FORMAT_B8G8R8_UNORM = 27;
    public static final int OVR_FORMAT_B8G8R8A8_UNORM_SRGB = 7;
    public static final int OVR_FORMAT_B8G8R8X8_UNORM = 8;
    public static final int OVR_FORMAT_B8G8R8X8_UNORM_SRGB = 9;
    public static final int OVR_FORMAT_R16G16B16A16_FLOAT = 10;
    public static final int OVR_FORMAT_R11G11B10_FLOAT = 25;
    public static final int OVR_FORMAT_D16_UNORM = 11;
    public static final int OVR_FORMAT_D24_UNORM_S8_UINT = 12;
    public static final int OVR_FORMAT_D32_FLOAT = 13;
    public static final int OVR_FORMAT_D32_FLOAT_S8X24_UINT = 14;
    public static final int OVR_FORMAT_BC1_UNORM = 15;
    public static final int OVR_FORMAT_BC1_UNORM_SRGB = 16;
    public static final int OVR_FORMAT_BC2_UNORM = 17;
    public static final int OVR_FORMAT_BC2_UNORM_SRGB = 18;
    public static final int OVR_FORMAT_BC3_UNORM = 19;
    public static final int OVR_FORMAT_BC3_UNORM_SRGB = 20;
    public static final int OVR_FORMAT_BC6H_UF16 = 21;
    public static final int OVR_FORMAT_BC6H_SF16 = 22;
    public static final int OVR_FORMAT_BC7_UNORM = 23;
    public static final int OVR_FORMAT_BC7_UNORM_SRGB = 24;
    public static final int ovrTextureMisc_None = 0;
    public static final int ovrTextureMisc_DX_Typeless = 1;
    public static final int ovrTextureMisc_AllowGenerateMips = 2;
    public static final int ovrTextureMisc_ProtectedContent = 4;
    public static final int ovrTextureMisc_AutoGenerateMips = 8;
    public static final int ovrMirrorOption_Default = 0;
    public static final int ovrMirrorOption_PostDistortion = 1;
    public static final int ovrMirrorOption_LeftEyeOnly = 2;
    public static final int ovrMirrorOption_RightEyeOnly = 4;
    public static final int ovrMirrorOption_IncludeGuardian = 8;
    public static final int ovrMirrorOption_IncludeNotifications = 16;
    public static final int ovrMirrorOption_IncludeSystemGui = 32;
    public static final int ovrViewportStencil_HiddenArea = 0;
    public static final int ovrViewportStencil_VisibleArea = 1;
    public static final int ovrViewportStencil_BorderLine = 2;
    public static final int ovrButton_A = 1;
    public static final int ovrButton_B = 2;
    public static final int ovrButton_RThumb = 4;
    public static final int ovrButton_RShoulder = 8;
    public static final int ovrButton_X = 256;
    public static final int ovrButton_Y = 512;
    public static final int ovrButton_LThumb = 1024;
    public static final int ovrButton_LShoulder = 2048;
    public static final int ovrButton_Up = 65536;
    public static final int ovrButton_Down = 131072;
    public static final int ovrButton_Left = 262144;
    public static final int ovrButton_Right = 524288;
    public static final int ovrButton_Enter = 0x100000;
    public static final int ovrButton_Back = 0x200000;
    public static final int ovrButton_VolUp = 0x400000;
    public static final int ovrButton_VolDown = 0x800000;
    public static final int ovrButton_Home = 0x1000000;
    public static final int ovrButton_Private = 0x1C00000;
    public static final int ovrButton_RMask = 15;
    public static final int ovrButton_LMask = 0x100F00;
    public static final int ovrTouch_A = 1;
    public static final int ovrTouch_B = 2;
    public static final int ovrTouch_RThumb = 4;
    public static final int ovrTouch_RThumbRest = 8;
    public static final int ovrTouch_RIndexTrigger = 16;
    public static final int ovrTouch_RButtonMask = 31;
    public static final int ovrTouch_X = 256;
    public static final int ovrTouch_Y = 512;
    public static final int ovrTouch_LThumb = 1024;
    public static final int ovrTouch_LThumbRest = 2048;
    public static final int ovrTouch_LIndexTrigger = 4096;
    public static final int ovrTouch_LButtonMask = 7936;
    public static final int ovrTouch_RIndexPointing = 32;
    public static final int ovrTouch_RThumbUp = 64;
    public static final int ovrTouch_LIndexPointing = 8192;
    public static final int ovrTouch_LThumbUp = 16384;
    public static final int ovrTouch_RPoseMask = 96;
    public static final int ovrTouch_LPoseMask = 24576;
    public static final int ovrControllerType_None = 0;
    public static final int ovrControllerType_LTouch = 1;
    public static final int ovrControllerType_RTouch = 2;
    public static final int ovrControllerType_Touch = 3;
    public static final int ovrControllerType_Remote = 4;
    public static final int ovrControllerType_XBox = 16;
    public static final int ovrControllerType_Object0 = 256;
    public static final int ovrControllerType_Object1 = 512;
    public static final int ovrControllerType_Object2 = 1024;
    public static final int ovrControllerType_Object3 = 2048;
    public static final int ovrControllerType_Active = -1;
    public static final int ovrHapticsBufferSubmit_Enqueue = 0;
    public static final int ovrTrackedDevice_None = 0;
    public static final int ovrTrackedDevice_HMD = 1;
    public static final int ovrTrackedDevice_LTouch = 2;
    public static final int ovrTrackedDevice_RTouch = 4;
    public static final int ovrTrackedDevice_Touch = 6;
    public static final int ovrTrackedDevice_Object0 = 16;
    public static final int ovrTrackedDevice_Object1 = 32;
    public static final int ovrTrackedDevice_Object2 = 64;
    public static final int ovrTrackedDevice_Object3 = 128;
    public static final int ovrTrackedDevice_All = 65535;
    public static final int ovrCameraStatus_None = 0;
    public static final int ovrCameraStatus_Connected = 1;
    public static final int ovrCameraStatus_Calibrating = 2;
    public static final int ovrCameraStatus_CalibrationFailed = 4;
    public static final int ovrCameraStatus_Calibrated = 8;
    public static final int ovrCameraStatus_Capturing = 16;
    public static final int ovrBoundary_Outer = 1;
    public static final int ovrBoundary_PlayArea = 256;
    public static final int ovrHand_Left = 0;
    public static final int ovrHand_Right = 1;
    public static final int ovrHand_Count = 2;
    public static final int ovrMaxProvidedFrameStats = 5;
    public static final int OVR_HAPTICS_BUFFER_SAMPLES_MAX = 256;
    public static final int OVR_MAX_EXTERNAL_CAMERA_COUNT = 16;
    public static final int OVR_EXTERNAL_CAMERA_NAME_SIZE = 32;
    public static final int ovrMaxLayerCount = 16;
    public static final int ovrLayerType_Disabled = 0;
    public static final int ovrLayerType_EyeFov = 1;
    public static final int ovrLayerType_EyeFovDepth = 2;
    public static final int ovrLayerType_Quad = 3;
    public static final int ovrLayerType_EyeMatrix = 5;
    public static final int ovrLayerType_EyeFovMultires = 7;
    public static final int ovrLayerType_Cylinder = 8;
    public static final int ovrLayerType_Cube = 10;
    public static final int ovrLayerFlag_HighQuality = 1;
    public static final int ovrLayerFlag_TextureOriginAtBottomLeft = 2;
    public static final int ovrLayerFlag_HeadLocked = 4;
    public static final int ovrTextureLayout_Rectilinear = 0;
    public static final int ovrTextureLayout_Octilinear = 1;
    public static final int ovrPerfHud_Off = 0;
    public static final int ovrPerfHud_PerfSummary = 1;
    public static final int ovrPerfHud_LatencyTiming = 2;
    public static final int ovrPerfHud_AppRenderTiming = 3;
    public static final int ovrPerfHud_CompRenderTiming = 4;
    public static final int ovrPerfHud_AwsStats = 6;
    public static final int ovrPerfHud_VersionInfo = 5;
    public static final int ovrLayerHud_Off = 0;
    public static final int ovrLayerHud_Info = 1;
    public static final int ovrDebugHudStereo_Off = 0;
    public static final int ovrDebugHudStereo_Quad = 1;
    public static final int ovrDebugHudStereo_QuadWithCrosshair = 2;
    public static final int ovrDebugHudStereo_CrosshairAtInfinity = 3;

    protected OVR() {
        throw new UnsupportedOperationException();
    }

    public static native int novr_Initialize(long var0);

    @NativeType(value="ovrResult")
    public static int ovr_Initialize(@Nullable @NativeType(value="ovrInitParams const *") OVRInitParams params) {
        return OVR.novr_Initialize(MemoryUtil.memAddressSafe((Pointer)params));
    }

    public static native void ovr_Shutdown();

    public static native void novr_GetLastErrorInfo(long var0);

    public static void ovr_GetLastErrorInfo(@NativeType(value="ovrErrorInfo *") OVRErrorInfo errorInfo) {
        OVR.novr_GetLastErrorInfo(errorInfo.address());
    }

    public static native long novr_GetVersionString();

    @NativeType(value="char const *")
    public static String ovr_GetVersionString() {
        long __result = OVR.novr_GetVersionString();
        return MemoryUtil.memUTF8((long)__result);
    }

    public static native int novr_TraceMessage(int var0, long var1);

    public static int ovr_TraceMessage(int level, @NativeType(value="char const *") ByteBuffer message) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)message);
        }
        return OVR.novr_TraceMessage(level, MemoryUtil.memAddress((ByteBuffer)message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ovr_TraceMessage(int level, @NativeType(value="char const *") CharSequence message) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer messageEncoded = stack.UTF8(message);
            int n = OVR.novr_TraceMessage(level, MemoryUtil.memAddress((ByteBuffer)messageEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int novr_IdentifyClient(long var0);

    @NativeType(value="ovrResult")
    public static int ovr_IdentifyClient(@NativeType(value="char const *") ByteBuffer identity) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)identity);
        }
        return OVR.novr_IdentifyClient(MemoryUtil.memAddress((ByteBuffer)identity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="ovrResult")
    public static int ovr_IdentifyClient(@NativeType(value="char const *") CharSequence identity) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer identityEncoded = stack.UTF8(identity);
            int n = OVR.novr_IdentifyClient(MemoryUtil.memAddress((ByteBuffer)identityEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void novr_GetHmdDesc(long var0, long var2);

    @NativeType(value="ovrHmdDesc")
    public static OVRHmdDesc ovr_GetHmdDesc(@NativeType(value="ovrSession") long session, OVRHmdDesc __result) {
        OVR.novr_GetHmdDesc(session, __result.address());
        return __result;
    }

    public static native int novr_GetTrackerCount(long var0);

    @NativeType(value="unsigned int")
    public static int ovr_GetTrackerCount(@NativeType(value="ovrSession") long session) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_GetTrackerCount(session);
    }

    public static native void novr_GetTrackerDesc(long var0, int var2, long var3);

    @NativeType(value="ovrTrackerDesc")
    public static OVRTrackerDesc ovr_GetTrackerDesc(@NativeType(value="ovrSession") long session, @NativeType(value="unsigned int") int trackerDescIndex, OVRTrackerDesc __result) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        OVR.novr_GetTrackerDesc(session, trackerDescIndex, __result.address());
        return __result;
    }

    public static native int novr_Create(long var0, long var2);

    @NativeType(value="ovrResult")
    public static int ovr_Create(@NativeType(value="ovrSession *") PointerBuffer pSession, @NativeType(value="ovrGraphicsLuid *") OVRGraphicsLuid pLuid) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pSession, (int)1);
        }
        return OVR.novr_Create(MemoryUtil.memAddress((CustomBuffer)pSession), pLuid.address());
    }

    public static native void novr_Destroy(long var0);

    public static void ovr_Destroy(@NativeType(value="ovrSession") long session) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        OVR.novr_Destroy(session);
    }

    public static native int novr_GetSessionStatus(long var0, long var2);

    @NativeType(value="ovrResult")
    public static int ovr_GetSessionStatus(@NativeType(value="ovrSession") long session, @NativeType(value="ovrSessionStatus *") OVRSessionStatus sessionStatus) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_GetSessionStatus(session, sessionStatus.address());
    }

    public static native int novr_IsExtensionSupported(long var0, int var2, long var3);

    @NativeType(value="ovrResult")
    public static int ovr_IsExtensionSupported(@NativeType(value="ovrSession") long session, @NativeType(value="ovrExtensions") int extension, @NativeType(value="ovrBool *") ByteBuffer outExtensionSupported) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.check((Buffer)outExtensionSupported, (int)1);
        }
        return OVR.novr_IsExtensionSupported(session, extension, MemoryUtil.memAddress((ByteBuffer)outExtensionSupported));
    }

    public static native int novr_EnableExtension(long var0, int var2);

    @NativeType(value="ovrResult")
    public static int ovr_EnableExtension(@NativeType(value="ovrSession") long session, @NativeType(value="ovrExtensions") int extension) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_EnableExtension(session, extension);
    }

    public static native int novr_SetTrackingOriginType(long var0, int var2);

    @NativeType(value="ovrResult")
    public static int ovr_SetTrackingOriginType(@NativeType(value="ovrSession") long session, @NativeType(value="ovrTrackingOrigin") int origin) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_SetTrackingOriginType(session, origin);
    }

    public static native int novr_GetTrackingOriginType(long var0);

    @NativeType(value="ovrTrackingOrigin")
    public static int ovr_GetTrackingOriginType(@NativeType(value="ovrSession") long session) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_GetTrackingOriginType(session);
    }

    public static native int novr_RecenterTrackingOrigin(long var0);

    @NativeType(value="ovrResult")
    public static int ovr_RecenterTrackingOrigin(@NativeType(value="ovrSession") long session) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_RecenterTrackingOrigin(session);
    }

    public static native int novr_SpecifyTrackingOrigin(long var0, long var2);

    @NativeType(value="ovrResult")
    public static int ovr_SpecifyTrackingOrigin(@NativeType(value="ovrSession") long session, @NativeType(value="ovrPosef") OVRPosef originPose) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_SpecifyTrackingOrigin(session, originPose.address());
    }

    public static native void novr_ClearShouldRecenterFlag(long var0);

    public static void ovr_ClearShouldRecenterFlag(@NativeType(value="ovrSession") long session) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        OVR.novr_ClearShouldRecenterFlag(session);
    }

    public static native void novr_GetTrackingState(long var0, double var2, boolean var4, long var5);

    @NativeType(value="ovrTrackingState")
    public static OVRTrackingState ovr_GetTrackingState(@NativeType(value="ovrSession") long session, double absTime, @NativeType(value="ovrBool") boolean latencyMarker, OVRTrackingState __result) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        OVR.novr_GetTrackingState(session, absTime, latencyMarker, __result.address());
        return __result;
    }

    public static native int novr_GetDevicePoses(long var0, long var2, int var4, double var5, long var7);

    @NativeType(value="ovrResult")
    public static int ovr_GetDevicePoses(@NativeType(value="ovrSession") long session, @NativeType(value="ovrTrackedDeviceType *") IntBuffer deviceTypes, double absTime, @NativeType(value="ovrPoseStatef *") OVRPoseStatef.Buffer outDevicePoses) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.check((CustomBuffer)outDevicePoses, (int)deviceTypes.remaining());
        }
        return OVR.novr_GetDevicePoses(session, MemoryUtil.memAddress((IntBuffer)deviceTypes), deviceTypes.remaining(), absTime, outDevicePoses.address());
    }

    public static native void novr_GetTrackerPose(long var0, int var2, long var3);

    @NativeType(value="ovrTrackerPose")
    public static OVRTrackerPose ovr_GetTrackerPose(@NativeType(value="ovrSession") long session, @NativeType(value="unsigned int") int trackerPoseIndex, OVRTrackerPose __result) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        OVR.novr_GetTrackerPose(session, trackerPoseIndex, __result.address());
        return __result;
    }

    public static native int novr_GetInputState(long var0, int var2, long var3);

    @NativeType(value="ovrResult")
    public static int ovr_GetInputState(@NativeType(value="ovrSession") long session, @NativeType(value="ovrControllerType") int controllerType, @NativeType(value="ovrInputState *") OVRInputState inputState) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_GetInputState(session, controllerType, inputState.address());
    }

    public static native int novr_GetConnectedControllerTypes(long var0);

    @NativeType(value="unsigned int")
    public static int ovr_GetConnectedControllerTypes(@NativeType(value="ovrSession") long session) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_GetConnectedControllerTypes(session);
    }

    public static native void novr_GetTouchHapticsDesc(long var0, int var2, long var3);

    @NativeType(value="ovrTouchHapticsDesc")
    public static OVRTouchHapticsDesc ovr_GetTouchHapticsDesc(@NativeType(value="ovrSession") long session, @NativeType(value="ovrControllerType") int controllerType, OVRTouchHapticsDesc __result) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        OVR.novr_GetTouchHapticsDesc(session, controllerType, __result.address());
        return __result;
    }

    public static native int novr_SetControllerVibration(long var0, int var2, float var3, float var4);

    @NativeType(value="ovrResult")
    public static int ovr_SetControllerVibration(@NativeType(value="ovrSession") long session, @NativeType(value="ovrControllerType") int controllerType, float frequency, float amplitude) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_SetControllerVibration(session, controllerType, frequency, amplitude);
    }

    public static native int novr_SubmitControllerVibration(long var0, int var2, long var3);

    @NativeType(value="ovrResult")
    public static int ovr_SubmitControllerVibration(@NativeType(value="ovrSession") long session, @NativeType(value="ovrControllerType") int controllerType, @NativeType(value="ovrHapticsBuffer const *") OVRHapticsBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            OVRHapticsBuffer.validate(buffer.address());
        }
        return OVR.novr_SubmitControllerVibration(session, controllerType, buffer.address());
    }

    public static native int novr_GetControllerVibrationState(long var0, int var2, long var3);

    @NativeType(value="ovrResult")
    public static int ovr_GetControllerVibrationState(@NativeType(value="ovrSession") long session, @NativeType(value="ovrControllerType") int controllerType, @NativeType(value="ovrHapticsPlaybackState *") OVRHapticsPlaybackState outState) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_GetControllerVibrationState(session, controllerType, outState.address());
    }

    public static native int novr_TestBoundary(long var0, int var2, int var3, long var4);

    @NativeType(value="ovrResult")
    public static int ovr_TestBoundary(@NativeType(value="ovrSession") long session, @NativeType(value="ovrTrackedDeviceType") int deviceBitmask, @NativeType(value="ovrBoundaryType") int boundaryType, @NativeType(value="ovrBoundaryTestResult *") OVRBoundaryTestResult outTestResult) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_TestBoundary(session, deviceBitmask, boundaryType, outTestResult.address());
    }

    public static native int novr_TestBoundaryPoint(long var0, long var2, int var4, long var5);

    @NativeType(value="ovrResult")
    public static int ovr_TestBoundaryPoint(@NativeType(value="ovrSession") long session, @NativeType(value="ovrVector3f const *") OVRVector3f point, @NativeType(value="ovrBoundaryType") int singleBoundaryType, @NativeType(value="ovrBoundaryTestResult *") OVRBoundaryTestResult outTestResult) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_TestBoundaryPoint(session, point.address(), singleBoundaryType, outTestResult.address());
    }

    public static native int novr_SetBoundaryLookAndFeel(long var0, long var2);

    @NativeType(value="ovrResult")
    public static int ovr_SetBoundaryLookAndFeel(@NativeType(value="ovrSession") long session, @NativeType(value="ovrBoundaryLookAndFeel const *") OVRBoundaryLookAndFeel lookAndFeel) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_SetBoundaryLookAndFeel(session, lookAndFeel.address());
    }

    public static native int novr_ResetBoundaryLookAndFeel(long var0);

    @NativeType(value="ovrResult")
    public static int ovr_ResetBoundaryLookAndFeel(@NativeType(value="ovrSession") long session) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_ResetBoundaryLookAndFeel(session);
    }

    public static native int novr_GetBoundaryGeometry(long var0, int var2, long var3, long var5);

    @NativeType(value="ovrResult")
    public static int ovr_GetBoundaryGeometry(@NativeType(value="ovrSession") long session, @NativeType(value="ovrBoundaryType") int boundaryType, @Nullable @NativeType(value="ovrVector3f *") OVRVector3f outFloorPoints, @Nullable @NativeType(value="int *") IntBuffer outFloorPointsCount) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.checkSafe((Buffer)outFloorPointsCount, (int)1);
        }
        return OVR.novr_GetBoundaryGeometry(session, boundaryType, MemoryUtil.memAddressSafe((Pointer)outFloorPoints), MemoryUtil.memAddressSafe((IntBuffer)outFloorPointsCount));
    }

    public static native int novr_GetBoundaryDimensions(long var0, int var2, long var3);

    @NativeType(value="ovrResult")
    public static int ovr_GetBoundaryDimensions(@NativeType(value="ovrSession") long session, @NativeType(value="ovrBoundaryType") int boundaryType, @NativeType(value="ovrVector3f *") OVRVector3f outDimensions) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_GetBoundaryDimensions(session, boundaryType, outDimensions.address());
    }

    public static native int novr_GetBoundaryVisible(long var0, long var2);

    @NativeType(value="ovrResult")
    public static int ovr_GetBoundaryVisible(@NativeType(value="ovrSession") long session, @NativeType(value="ovrBool *") ByteBuffer outIsVisible) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.check((Buffer)outIsVisible, (int)1);
        }
        return OVR.novr_GetBoundaryVisible(session, MemoryUtil.memAddress((ByteBuffer)outIsVisible));
    }

    public static native int novr_RequestBoundaryVisible(long var0, boolean var2);

    @NativeType(value="ovrResult")
    public static int ovr_RequestBoundaryVisible(@NativeType(value="ovrSession") long session, @NativeType(value="ovrBool") boolean visible) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_RequestBoundaryVisible(session, visible);
    }

    public static native int novr_GetExternalCameras(long var0, long var2, long var4);

    @NativeType(value="ovrResult")
    public static int ovr_GetExternalCameras(@NativeType(value="ovrSession") long session, @Nullable @NativeType(value="ovrExternalCamera *") OVRExternalCamera.Buffer cameras, @NativeType(value="unsigned int *") IntBuffer inoutCameraCount) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.check((Buffer)inoutCameraCount, (int)1);
            Checks.checkSafe((CustomBuffer)cameras, (int)inoutCameraCount.get(inoutCameraCount.position()));
        }
        return OVR.novr_GetExternalCameras(session, MemoryUtil.memAddressSafe((Pointer)cameras), MemoryUtil.memAddress((IntBuffer)inoutCameraCount));
    }

    public static native int novr_SetExternalCameraProperties(long var0, long var2, long var4, long var6);

    @NativeType(value="ovrResult")
    public static int ovr_SetExternalCameraProperties(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="ovrCameraIntrinsics const * const") OVRCameraIntrinsics intrinsics, @NativeType(value="ovrCameraExtrinsics const * const") OVRCameraExtrinsics extrinsics) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.checkNT1((ByteBuffer)name);
        }
        return OVR.novr_SetExternalCameraProperties(session, MemoryUtil.memAddress((ByteBuffer)name), intrinsics.address(), extrinsics.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="ovrResult")
    public static int ovr_SetExternalCameraProperties(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") CharSequence name, @NativeType(value="ovrCameraIntrinsics const * const") OVRCameraIntrinsics intrinsics, @NativeType(value="ovrCameraExtrinsics const * const") OVRCameraExtrinsics extrinsics) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = OVR.novr_SetExternalCameraProperties(session, MemoryUtil.memAddress((ByteBuffer)nameEncoded), intrinsics.address(), extrinsics.address());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int novr_GetTextureSwapChainLength(long var0, long var2, long var4);

    @NativeType(value="ovrResult")
    public static int ovr_GetTextureSwapChainLength(@NativeType(value="ovrSession") long session, @NativeType(value="ovrTextureSwapChain") long chain, @NativeType(value="int *") IntBuffer out_Length) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.check((long)chain);
            Checks.check((Buffer)out_Length, (int)1);
        }
        return OVR.novr_GetTextureSwapChainLength(session, chain, MemoryUtil.memAddress((IntBuffer)out_Length));
    }

    public static native int novr_GetTextureSwapChainCurrentIndex(long var0, long var2, long var4);

    @NativeType(value="ovrResult")
    public static int ovr_GetTextureSwapChainCurrentIndex(@NativeType(value="ovrSession") long session, @NativeType(value="ovrTextureSwapChain") long chain, @NativeType(value="int *") IntBuffer out_Index) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.check((long)chain);
            Checks.check((Buffer)out_Index, (int)1);
        }
        return OVR.novr_GetTextureSwapChainCurrentIndex(session, chain, MemoryUtil.memAddress((IntBuffer)out_Index));
    }

    public static native int novr_GetTextureSwapChainDesc(long var0, long var2, long var4);

    @NativeType(value="ovrResult")
    public static int ovr_GetTextureSwapChainDesc(@NativeType(value="ovrSession") long session, @NativeType(value="ovrTextureSwapChain") long chain, @NativeType(value="ovrTextureSwapChainDesc *") OVRTextureSwapChainDesc out_Desc) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.check((long)chain);
        }
        return OVR.novr_GetTextureSwapChainDesc(session, chain, out_Desc.address());
    }

    public static native int novr_CommitTextureSwapChain(long var0, long var2);

    @NativeType(value="ovrResult")
    public static int ovr_CommitTextureSwapChain(@NativeType(value="ovrSession") long session, @NativeType(value="ovrTextureSwapChain") long chain) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.check((long)chain);
        }
        return OVR.novr_CommitTextureSwapChain(session, chain);
    }

    public static native void novr_DestroyTextureSwapChain(long var0, long var2);

    public static void ovr_DestroyTextureSwapChain(@NativeType(value="ovrSession") long session, @NativeType(value="ovrTextureSwapChain") long chain) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        OVR.novr_DestroyTextureSwapChain(session, chain);
    }

    public static native void novr_DestroyMirrorTexture(long var0, long var2);

    public static void ovr_DestroyMirrorTexture(@NativeType(value="ovrSession") long session, @NativeType(value="ovrMirrorTexture") long mirrorTexture) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        OVR.novr_DestroyMirrorTexture(session, mirrorTexture);
    }

    public static native void novr_GetFovTextureSize(long var0, int var2, long var3, float var5, long var6);

    @NativeType(value="ovrSizei")
    public static OVRSizei ovr_GetFovTextureSize(@NativeType(value="ovrSession") long session, @NativeType(value="ovrEyeType") int eye, @NativeType(value="ovrFovPort") OVRFovPort fov, float pixelsPerDisplayPixel, OVRSizei __result) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        OVR.novr_GetFovTextureSize(session, eye, fov.address(), pixelsPerDisplayPixel, __result.address());
        return __result;
    }

    public static native void novr_GetRenderDesc(long var0, int var2, long var3, long var5);

    @NativeType(value="ovrEyeRenderDesc")
    public static OVREyeRenderDesc ovr_GetRenderDesc(@NativeType(value="ovrSession") long session, @NativeType(value="ovrEyeType") int eyeType, @NativeType(value="ovrFovPort") OVRFovPort fov, OVREyeRenderDesc __result) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        OVR.novr_GetRenderDesc(session, eyeType, fov.address(), __result.address());
        return __result;
    }

    public static native int novr_GetViewportStencil(long var0, long var2, long var4);

    @NativeType(value="ovrResult")
    public static int ovr_GetViewportStencil(@NativeType(value="ovrSession") long session, @NativeType(value="ovrViewportStencilDesc const *") OVRViewportStencilDesc viewportStencilDesc, @NativeType(value="ovrViewportStencilMeshBuffer *") OVRViewportStencilMeshBuffer outMeshBuffer) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            OVRViewportStencilMeshBuffer.validate(outMeshBuffer.address());
        }
        return OVR.novr_GetViewportStencil(session, viewportStencilDesc.address(), outMeshBuffer.address());
    }

    public static native int novr_WaitToBeginFrame(long var0, long var2);

    @NativeType(value="ovrResult")
    public static int ovr_WaitToBeginFrame(@NativeType(value="ovrSession") long session, @NativeType(value="long long") long frameIndex) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_WaitToBeginFrame(session, frameIndex);
    }

    public static native int novr_BeginFrame(long var0, long var2);

    @NativeType(value="ovrResult")
    public static int ovr_BeginFrame(@NativeType(value="ovrSession") long session, @NativeType(value="long long") long frameIndex) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_BeginFrame(session, frameIndex);
    }

    public static native int novr_EndFrame(long var0, long var2, long var4, long var6, int var8);

    @NativeType(value="ovrResult")
    public static int ovr_EndFrame(@NativeType(value="ovrSession") long session, @NativeType(value="long long") long frameIndex, @Nullable @NativeType(value="ovrViewScaleDesc const *") OVRViewScaleDesc viewScaleDesc, @NativeType(value="ovrLayerHeader const * const *") PointerBuffer layerPtrList) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_EndFrame(session, frameIndex, MemoryUtil.memAddressSafe((Pointer)viewScaleDesc), MemoryUtil.memAddress((CustomBuffer)layerPtrList), layerPtrList.remaining());
    }

    public static native int novr_SubmitFrame(long var0, long var2, long var4, long var6, int var8);

    @NativeType(value="ovrResult")
    public static int ovr_SubmitFrame(@NativeType(value="ovrSession") long session, @NativeType(value="long long") long frameIndex, @Nullable @NativeType(value="ovrViewScaleDesc const *") OVRViewScaleDesc viewScaleDesc, @NativeType(value="ovrLayerHeader const * const *") PointerBuffer layerPtrList) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_SubmitFrame(session, frameIndex, MemoryUtil.memAddressSafe((Pointer)viewScaleDesc), MemoryUtil.memAddress((CustomBuffer)layerPtrList), layerPtrList.remaining());
    }

    public static native int novr_GetPerfStats(long var0, long var2);

    @NativeType(value="ovrResult")
    public static int ovr_GetPerfStats(@NativeType(value="ovrSession") long session, @NativeType(value="ovrPerfStats *") OVRPerfStats outStats) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_GetPerfStats(session, outStats.address());
    }

    public static native int novr_ResetPerfStats(long var0);

    @NativeType(value="ovrResult")
    public static int ovr_ResetPerfStats(@NativeType(value="ovrSession") long session) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_ResetPerfStats(session);
    }

    public static native double novr_GetPredictedDisplayTime(long var0, long var2);

    public static double ovr_GetPredictedDisplayTime(@NativeType(value="ovrSession") long session, @NativeType(value="long long") long frameIndex) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        return OVR.novr_GetPredictedDisplayTime(session, frameIndex);
    }

    public static native double ovr_GetTimeInSeconds();

    public static native boolean novr_GetBool(long var0, long var2, boolean var4);

    @NativeType(value="ovrBool")
    public static boolean ovr_GetBool(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") ByteBuffer propertyName, @NativeType(value="ovrBool") boolean defaultVal) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.checkNT1((ByteBuffer)propertyName);
        }
        return OVR.novr_GetBool(session, MemoryUtil.memAddress((ByteBuffer)propertyName), defaultVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="ovrBool")
    public static boolean ovr_GetBool(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") CharSequence propertyName, @NativeType(value="ovrBool") boolean defaultVal) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            boolean bl = OVR.novr_GetBool(session, MemoryUtil.memAddress((ByteBuffer)propertyNameEncoded), defaultVal);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean novr_SetBool(long var0, long var2, boolean var4);

    @NativeType(value="ovrBool")
    public static boolean ovr_SetBool(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") ByteBuffer propertyName, @NativeType(value="ovrBool") boolean value) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.checkNT1((ByteBuffer)propertyName);
        }
        return OVR.novr_SetBool(session, MemoryUtil.memAddress((ByteBuffer)propertyName), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="ovrBool")
    public static boolean ovr_SetBool(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") CharSequence propertyName, @NativeType(value="ovrBool") boolean value) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            boolean bl = OVR.novr_SetBool(session, MemoryUtil.memAddress((ByteBuffer)propertyNameEncoded), value);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int novr_GetInt(long var0, long var2, int var4);

    public static int ovr_GetInt(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") ByteBuffer propertyName, int defaultVal) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.checkNT1((ByteBuffer)propertyName);
        }
        return OVR.novr_GetInt(session, MemoryUtil.memAddress((ByteBuffer)propertyName), defaultVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ovr_GetInt(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") CharSequence propertyName, int defaultVal) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            int n = OVR.novr_GetInt(session, MemoryUtil.memAddress((ByteBuffer)propertyNameEncoded), defaultVal);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean novr_SetInt(long var0, long var2, int var4);

    @NativeType(value="ovrBool")
    public static boolean ovr_SetInt(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") ByteBuffer propertyName, int value) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.checkNT1((ByteBuffer)propertyName);
        }
        return OVR.novr_SetInt(session, MemoryUtil.memAddress((ByteBuffer)propertyName), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="ovrBool")
    public static boolean ovr_SetInt(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") CharSequence propertyName, int value) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            boolean bl = OVR.novr_SetInt(session, MemoryUtil.memAddress((ByteBuffer)propertyNameEncoded), value);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native float novr_GetFloat(long var0, long var2, float var4);

    public static float ovr_GetFloat(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") ByteBuffer propertyName, float defaultVal) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.checkNT1((ByteBuffer)propertyName);
        }
        return OVR.novr_GetFloat(session, MemoryUtil.memAddress((ByteBuffer)propertyName), defaultVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float ovr_GetFloat(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") CharSequence propertyName, float defaultVal) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            float f = OVR.novr_GetFloat(session, MemoryUtil.memAddress((ByteBuffer)propertyNameEncoded), defaultVal);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean novr_SetFloat(long var0, long var2, float var4);

    @NativeType(value="ovrBool")
    public static boolean ovr_SetFloat(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") ByteBuffer propertyName, float value) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.checkNT1((ByteBuffer)propertyName);
        }
        return OVR.novr_SetFloat(session, MemoryUtil.memAddress((ByteBuffer)propertyName), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="ovrBool")
    public static boolean ovr_SetFloat(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") CharSequence propertyName, float value) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            boolean bl = OVR.novr_SetFloat(session, MemoryUtil.memAddress((ByteBuffer)propertyNameEncoded), value);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int novr_GetFloatArray(long var0, long var2, long var4, int var6);

    @NativeType(value="unsigned int")
    public static int ovr_GetFloatArray(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") ByteBuffer propertyName, @NativeType(value="float *") FloatBuffer values) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.checkNT1((ByteBuffer)propertyName);
        }
        return OVR.novr_GetFloatArray(session, MemoryUtil.memAddress((ByteBuffer)propertyName), MemoryUtil.memAddress((FloatBuffer)values), values.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="unsigned int")
    public static int ovr_GetFloatArray(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") CharSequence propertyName, @NativeType(value="float *") FloatBuffer values) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            int n = OVR.novr_GetFloatArray(session, MemoryUtil.memAddress((ByteBuffer)propertyNameEncoded), MemoryUtil.memAddress((FloatBuffer)values), values.remaining());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean novr_SetFloatArray(long var0, long var2, long var4, int var6);

    @NativeType(value="ovrBool")
    public static boolean ovr_SetFloatArray(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") ByteBuffer propertyName, @NativeType(value="float *") FloatBuffer values) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.checkNT1((ByteBuffer)propertyName);
        }
        return OVR.novr_SetFloatArray(session, MemoryUtil.memAddress((ByteBuffer)propertyName), MemoryUtil.memAddress((FloatBuffer)values), values.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="ovrBool")
    public static boolean ovr_SetFloatArray(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") CharSequence propertyName, @NativeType(value="float *") FloatBuffer values) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            boolean bl = OVR.novr_SetFloatArray(session, MemoryUtil.memAddress((ByteBuffer)propertyNameEncoded), MemoryUtil.memAddress((FloatBuffer)values), values.remaining());
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long novr_GetString(long var0, long var2, long var4);

    @Nullable
    @NativeType(value="char const *")
    public static String ovr_GetString(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") ByteBuffer propertyName, @Nullable @NativeType(value="char const *") ByteBuffer defaultVal) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.checkNT1((ByteBuffer)propertyName);
            Checks.checkNT1Safe((ByteBuffer)defaultVal);
        }
        long __result = OVR.novr_GetString(session, MemoryUtil.memAddress((ByteBuffer)propertyName), MemoryUtil.memAddressSafe((ByteBuffer)defaultVal));
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String ovr_GetString(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") CharSequence propertyName, @Nullable @NativeType(value="char const *") CharSequence defaultVal) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            ByteBuffer defaultValEncoded = stack.UTF8Safe(defaultVal);
            long __result = OVR.novr_GetString(session, MemoryUtil.memAddress((ByteBuffer)propertyNameEncoded), MemoryUtil.memAddressSafe((ByteBuffer)defaultValEncoded));
            String string = MemoryUtil.memUTF8Safe((long)__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean novr_SetString(long var0, long var2, long var4);

    @NativeType(value="ovrBool")
    public static boolean ovr_SetString(@NativeType(value="ovrSession") long hmddesc, @NativeType(value="char const *") ByteBuffer propertyName, @NativeType(value="char const *") ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((long)hmddesc);
            Checks.checkNT1((ByteBuffer)propertyName);
            Checks.checkNT1((ByteBuffer)value);
        }
        return OVR.novr_SetString(hmddesc, MemoryUtil.memAddress((ByteBuffer)propertyName), MemoryUtil.memAddress((ByteBuffer)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="ovrBool")
    public static boolean ovr_SetString(@NativeType(value="ovrSession") long hmddesc, @NativeType(value="char const *") CharSequence propertyName, @NativeType(value="char const *") CharSequence value) {
        if (Checks.CHECKS) {
            Checks.check((long)hmddesc);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            ByteBuffer valueEncoded = stack.ASCII(value);
            boolean bl = OVR.novr_SetString(hmddesc, MemoryUtil.memAddress((ByteBuffer)propertyNameEncoded), MemoryUtil.memAddress((ByteBuffer)valueEncoded));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int novr_GetDevicePoses(long var0, int[] var2, int var3, double var4, long var6);

    @NativeType(value="ovrResult")
    public static int ovr_GetDevicePoses(@NativeType(value="ovrSession") long session, @NativeType(value="ovrTrackedDeviceType *") int[] deviceTypes, double absTime, @NativeType(value="ovrPoseStatef *") OVRPoseStatef.Buffer outDevicePoses) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.check((CustomBuffer)outDevicePoses, (int)deviceTypes.length);
        }
        return OVR.novr_GetDevicePoses(session, deviceTypes, deviceTypes.length, absTime, outDevicePoses.address());
    }

    public static native int novr_GetBoundaryGeometry(long var0, int var2, long var3, int[] var5);

    @NativeType(value="ovrResult")
    public static int ovr_GetBoundaryGeometry(@NativeType(value="ovrSession") long session, @NativeType(value="ovrBoundaryType") int boundaryType, @Nullable @NativeType(value="ovrVector3f *") OVRVector3f outFloorPoints, @Nullable @NativeType(value="int *") int[] outFloorPointsCount) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.checkSafe((int[])outFloorPointsCount, (int)1);
        }
        return OVR.novr_GetBoundaryGeometry(session, boundaryType, MemoryUtil.memAddressSafe((Pointer)outFloorPoints), outFloorPointsCount);
    }

    public static native int novr_GetExternalCameras(long var0, long var2, int[] var4);

    @NativeType(value="ovrResult")
    public static int ovr_GetExternalCameras(@NativeType(value="ovrSession") long session, @Nullable @NativeType(value="ovrExternalCamera *") OVRExternalCamera.Buffer cameras, @NativeType(value="unsigned int *") int[] inoutCameraCount) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.check((int[])inoutCameraCount, (int)1);
            Checks.checkSafe((CustomBuffer)cameras, (int)inoutCameraCount[0]);
        }
        return OVR.novr_GetExternalCameras(session, MemoryUtil.memAddressSafe((Pointer)cameras), inoutCameraCount);
    }

    public static native int novr_GetTextureSwapChainLength(long var0, long var2, int[] var4);

    @NativeType(value="ovrResult")
    public static int ovr_GetTextureSwapChainLength(@NativeType(value="ovrSession") long session, @NativeType(value="ovrTextureSwapChain") long chain, @NativeType(value="int *") int[] out_Length) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.check((long)chain);
            Checks.check((int[])out_Length, (int)1);
        }
        return OVR.novr_GetTextureSwapChainLength(session, chain, out_Length);
    }

    public static native int novr_GetTextureSwapChainCurrentIndex(long var0, long var2, int[] var4);

    @NativeType(value="ovrResult")
    public static int ovr_GetTextureSwapChainCurrentIndex(@NativeType(value="ovrSession") long session, @NativeType(value="ovrTextureSwapChain") long chain, @NativeType(value="int *") int[] out_Index) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.check((long)chain);
            Checks.check((int[])out_Index, (int)1);
        }
        return OVR.novr_GetTextureSwapChainCurrentIndex(session, chain, out_Index);
    }

    public static native int novr_GetFloatArray(long var0, long var2, float[] var4, int var5);

    @NativeType(value="unsigned int")
    public static int ovr_GetFloatArray(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") ByteBuffer propertyName, @NativeType(value="float *") float[] values) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.checkNT1((ByteBuffer)propertyName);
        }
        return OVR.novr_GetFloatArray(session, MemoryUtil.memAddress((ByteBuffer)propertyName), values, values.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="unsigned int")
    public static int ovr_GetFloatArray(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") CharSequence propertyName, @NativeType(value="float *") float[] values) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            int n = OVR.novr_GetFloatArray(session, MemoryUtil.memAddress((ByteBuffer)propertyNameEncoded), values, values.length);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native boolean novr_SetFloatArray(long var0, long var2, float[] var4, int var5);

    @NativeType(value="ovrBool")
    public static boolean ovr_SetFloatArray(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") ByteBuffer propertyName, @NativeType(value="float *") float[] values) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
            Checks.checkNT1((ByteBuffer)propertyName);
        }
        return OVR.novr_SetFloatArray(session, MemoryUtil.memAddress((ByteBuffer)propertyName), values, values.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="ovrBool")
    public static boolean ovr_SetFloatArray(@NativeType(value="ovrSession") long session, @NativeType(value="char const *") CharSequence propertyName, @NativeType(value="float *") float[] values) {
        if (Checks.CHECKS) {
            Checks.check((long)session);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer propertyNameEncoded = stack.ASCII(propertyName);
            boolean bl = OVR.novr_SetFloatArray(session, MemoryUtil.memAddress((ByteBuffer)propertyNameEncoded), values, values.length);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    static {
        LibOVR.initialize();
    }
}

