/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrViewScaleDesc")
public class OVRViewScaleDesc
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HMDTOEYEPOSE;
    public static final int HMDSPACETOWORLDSCALEINMETERS;

    OVRViewScaleDesc(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRViewScaleDesc(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRViewScaleDesc.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrPosef[ovrEye_Count]")
    public OVRPosef.Buffer HmdToEyePose() {
        return OVRViewScaleDesc.nHmdToEyePose(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef HmdToEyePose(int index) {
        return OVRViewScaleDesc.nHmdToEyePose(this.address(), index);
    }

    public float HmdSpaceToWorldScaleInMeters() {
        return OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address());
    }

    public OVRViewScaleDesc HmdToEyePose(@NativeType(value="ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) {
        OVRViewScaleDesc.nHmdToEyePose(this.address(), value);
        return this;
    }

    public OVRViewScaleDesc HmdToEyePose(int index, @NativeType(value="ovrPosef") OVRPosef value) {
        OVRViewScaleDesc.nHmdToEyePose(this.address(), index, value);
        return this;
    }

    public OVRViewScaleDesc HmdSpaceToWorldScaleInMeters(float value) {
        OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address(), value);
        return this;
    }

    public OVRViewScaleDesc set(OVRPosef.Buffer HmdToEyePose, float HmdSpaceToWorldScaleInMeters) {
        this.HmdToEyePose(HmdToEyePose);
        this.HmdSpaceToWorldScaleInMeters(HmdSpaceToWorldScaleInMeters);
        return this;
    }

    public OVRViewScaleDesc set(OVRViewScaleDesc src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRViewScaleDesc malloc() {
        return OVRViewScaleDesc.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static OVRViewScaleDesc calloc() {
        return OVRViewScaleDesc.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static OVRViewScaleDesc create() {
        return new OVRViewScaleDesc(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRViewScaleDesc create(long address) {
        return address == 0L ? null : new OVRViewScaleDesc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRViewScaleDesc.create(OVRViewScaleDesc.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRViewScaleDesc.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRViewScaleDesc.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRViewScaleDesc mallocStack() {
        return OVRViewScaleDesc.mallocStack(MemoryStack.stackGet());
    }

    public static OVRViewScaleDesc callocStack() {
        return OVRViewScaleDesc.callocStack(MemoryStack.stackGet());
    }

    public static OVRViewScaleDesc mallocStack(MemoryStack stack) {
        return OVRViewScaleDesc.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRViewScaleDesc callocStack(MemoryStack stack) {
        return OVRViewScaleDesc.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRViewScaleDesc.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRViewScaleDesc.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRViewScaleDesc.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRViewScaleDesc.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRPosef.Buffer nHmdToEyePose(long struct) {
        return OVRPosef.create(struct + (long)HMDTOEYEPOSE, 2);
    }

    public static OVRPosef nHmdToEyePose(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check((int)index, (int)2);
        }
        return OVRPosef.create(struct + (long)HMDTOEYEPOSE + (long)(index * OVRPosef.SIZEOF));
    }

    public static float nHmdSpaceToWorldScaleInMeters(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)HMDSPACETOWORLDSCALEINMETERS));
    }

    public static void nHmdToEyePose(long struct, OVRPosef.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((StructBuffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HMDTOEYEPOSE), (long)(value.remaining() * OVRPosef.SIZEOF));
    }

    public static void nHmdToEyePose(long struct, int index, OVRPosef value) {
        if (Checks.CHECKS) {
            Checks.check((int)index, (int)2);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HMDTOEYEPOSE + (long)(index * OVRPosef.SIZEOF)), (long)OVRPosef.SIZEOF);
    }

    public static void nHmdSpaceToWorldScaleInMeters(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)HMDSPACETOWORLDSCALEINMETERS), (float)value);
    }

    static {
        Struct.Layout layout = OVRViewScaleDesc.__struct((Struct.Member[])new Struct.Member[]{OVRViewScaleDesc.__array((int)OVRPosef.SIZEOF, (int)OVRPosef.ALIGNOF, (int)2), OVRViewScaleDesc.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HMDTOEYEPOSE = layout.offsetof(0);
        HMDSPACETOWORLDSCALEINMETERS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRViewScaleDesc, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRViewScaleDesc newInstance(long address) {
            return new OVRViewScaleDesc(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="ovrPosef[ovrEye_Count]")
        public OVRPosef.Buffer HmdToEyePose() {
            return OVRViewScaleDesc.nHmdToEyePose(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef HmdToEyePose(int index) {
            return OVRViewScaleDesc.nHmdToEyePose(this.address(), index);
        }

        public float HmdSpaceToWorldScaleInMeters() {
            return OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address());
        }

        public Buffer HmdToEyePose(@NativeType(value="ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) {
            OVRViewScaleDesc.nHmdToEyePose(this.address(), value);
            return this;
        }

        public Buffer HmdToEyePose(int index, @NativeType(value="ovrPosef") OVRPosef value) {
            OVRViewScaleDesc.nHmdToEyePose(this.address(), index, value);
            return this;
        }

        public Buffer HmdSpaceToWorldScaleInMeters(float value) {
            OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address(), value);
            return this;
        }
    }
}

