/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrTrackerDesc")
public class OVRTrackerDesc
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FRUSTUMHFOVINRADIANS;
    public static final int FRUSTUMVFOVINRADIANS;
    public static final int FRUSTUMNEARZINMETERS;
    public static final int FRUSTUMFARZINMETERS;

    OVRTrackerDesc(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRTrackerDesc(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), OVRTrackerDesc.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float FrustumHFovInRadians() {
        return OVRTrackerDesc.nFrustumHFovInRadians(this.address());
    }

    public float FrustumVFovInRadians() {
        return OVRTrackerDesc.nFrustumVFovInRadians(this.address());
    }

    public float FrustumNearZInMeters() {
        return OVRTrackerDesc.nFrustumNearZInMeters(this.address());
    }

    public float FrustumFarZInMeters() {
        return OVRTrackerDesc.nFrustumFarZInMeters(this.address());
    }

    public static OVRTrackerDesc malloc() {
        return OVRTrackerDesc.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static OVRTrackerDesc calloc() {
        return OVRTrackerDesc.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static OVRTrackerDesc create() {
        return new OVRTrackerDesc(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static OVRTrackerDesc create(long address) {
        return address == 0L ? null : new OVRTrackerDesc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRTrackerDesc.create(OVRTrackerDesc.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRTrackerDesc.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(OVRTrackerDesc.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRTrackerDesc mallocStack() {
        return OVRTrackerDesc.mallocStack(MemoryStack.stackGet());
    }

    public static OVRTrackerDesc callocStack() {
        return OVRTrackerDesc.callocStack(MemoryStack.stackGet());
    }

    public static OVRTrackerDesc mallocStack(MemoryStack stack) {
        return OVRTrackerDesc.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRTrackerDesc callocStack(MemoryStack stack) {
        return OVRTrackerDesc.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRTrackerDesc.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRTrackerDesc.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRTrackerDesc.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRTrackerDesc.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nFrustumHFovInRadians(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)FRUSTUMHFOVINRADIANS));
    }

    public static float nFrustumVFovInRadians(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)FRUSTUMVFOVINRADIANS));
    }

    public static float nFrustumNearZInMeters(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)FRUSTUMNEARZINMETERS));
    }

    public static float nFrustumFarZInMeters(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)FRUSTUMFARZINMETERS));
    }

    static {
        Struct.Layout layout = OVRTrackerDesc.__struct((Struct.Member[])new Struct.Member[]{OVRTrackerDesc.__member((int)4), OVRTrackerDesc.__member((int)4), OVRTrackerDesc.__member((int)4), OVRTrackerDesc.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FRUSTUMHFOVINRADIANS = layout.offsetof(0);
        FRUSTUMVFOVINRADIANS = layout.offsetof(1);
        FRUSTUMNEARZINMETERS = layout.offsetof(2);
        FRUSTUMFARZINMETERS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OVRTrackerDesc, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected OVRTrackerDesc newInstance(long address) {
            return new OVRTrackerDesc(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        public float FrustumHFovInRadians() {
            return OVRTrackerDesc.nFrustumHFovInRadians(this.address());
        }

        public float FrustumVFovInRadians() {
            return OVRTrackerDesc.nFrustumVFovInRadians(this.address());
        }

        public float FrustumNearZInMeters() {
            return OVRTrackerDesc.nFrustumNearZInMeters(this.address());
        }

        public float FrustumFarZInMeters() {
            return OVRTrackerDesc.nFrustumFarZInMeters(this.address());
        }
    }
}

